/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.util.coordinators;

import builderb0y.bigglobe.util.WorldUtil;
import builderb0y.bigglobe.util.coordinators.CoordinateFunctions;
import builderb0y.bigglobe.util.coordinators.ScratchPosCoordinator;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_3218;
import net.minecraft.class_3610;
import net.minecraft.class_5281;

public class WorldCoordinator
extends ScratchPosCoordinator {
    public final class_5281 world;
    public final int setBlockFlags;

    public WorldCoordinator(class_5281 world, int setBlockFlags) {
        this.world = world;
        this.setBlockFlags = setBlockFlags;
    }

    @Override
    public void genericPos(int x, int y, int z, CoordinateFunctions.CoordinatorRunnable callback) {
        callback.run(this, x, y, z);
    }

    @Override
    public <A> void genericPos(int x, int y, int z, A arg, CoordinateFunctions.CoordinatorConsumer<A> callback) {
        callback.run(this, x, y, z, arg);
    }

    @Override
    public <A, B> void genericPos(int x, int y, int z, A arg1, B arg2, CoordinateFunctions.CoordinatorBiConsumer<A, B> callback) {
        callback.run(this, x, y, z, arg1, arg2);
    }

    @Override
    public <A, B, C> void genericPos(int x, int y, int z, A arg1, B arg2, C arg3, CoordinateFunctions.CoordinatorTriConsumer<A, B, C> callback) {
        callback.run(this, x, y, z, arg1, arg2, arg3);
    }

    @Override
    public void getBlockState(int x, int y, int z, CoordinateFunctions.CoordinateConsumer<class_2680> action) {
        action.accept(this.scratchPos.method_10103(x, y, z), this.world.method_8320((class_2338)this.scratchPos));
    }

    @Override
    public void getFluidState(int x, int y, int z, CoordinateFunctions.CoordinateConsumer<class_3610> action) {
        action.accept(this.scratchPos.method_10103(x, y, z), this.world.method_8316((class_2338)this.scratchPos));
    }

    @Override
    public void getBlockEntity(int x, int y, int z, CoordinateFunctions.CoordinateConsumer<class_2586> action) {
        class_2586 blockEntity = this.world.method_8321((class_2338)this.scratchPos.method_10103(x, y, z));
        if (blockEntity != null) {
            action.accept(this.scratchPos, blockEntity);
        }
    }

    @Override
    public <B> void getBlockEntity(int x, int y, int z, Class<B> blockEntityType, CoordinateFunctions.CoordinateConsumer<B> action) {
        B blockEntity = WorldUtil.getBlockEntity((class_1922)this.world, (class_2338)this.scratchPos.method_10103(x, y, z), blockEntityType);
        if (blockEntity != null) {
            action.accept(this.scratchPos, blockEntity);
        }
    }

    @Override
    public <B extends class_2586> void getBlockEntity(int x, int y, int z, class_2591<B> blockEntityType, CoordinateFunctions.CoordinateConsumer<B> action) {
        B blockEntity = WorldUtil.getBlockEntity((class_1922)this.world, (class_2338)this.scratchPos.method_10103(x, y, z), blockEntityType);
        if (blockEntity != null) {
            action.accept(this.scratchPos, blockEntity);
        }
    }

    @Override
    public void getChunk(int x, int y, int z, CoordinateFunctions.CoordinateConsumer<class_2791> action) {
        action.accept(this.scratchPos.method_10103(x, y, z), this.world.method_8392(x >> 4, z >> 4));
    }

    @Override
    public void setBlockState(int x, int y, int z, class_2680 state) {
        if (state == null) {
            return;
        }
        this.world.method_8652((class_2338)this.scratchPos.method_10103(x, y, z), state, this.setBlockFlags);
    }

    @Override
    public void setBlockState(int x, int y, int z, CoordinateFunctions.CoordinateSupplier<class_2680> supplier) {
        if (supplier == null) {
            return;
        }
        class_2680 state = supplier.get(this.scratchPos.method_10103(x, y, z));
        if (state == null) {
            return;
        }
        this.world.method_8652((class_2338)this.scratchPos.method_10103(x, y, z), state, this.setBlockFlags);
    }

    @Override
    public <B> void setBlockStateAndBlockEntity(int x, int y, int z, class_2680 state, Class<B> blockEntityClass, CoordinateFunctions.CoordinateConsumer<B> action) {
        if (state == null) {
            return;
        }
        this.world.method_8652((class_2338)this.scratchPos.method_10103(x, y, z), state, this.setBlockFlags);
        B blockEntity = WorldUtil.getBlockEntity((class_1922)this.world, (class_2338)this.scratchPos, blockEntityClass);
        if (blockEntity != null) {
            action.accept(this.scratchPos, blockEntity);
        }
    }

    @Override
    public <B extends class_2586> void setBlockStateAndBlockEntity(int x, int y, int z, class_2680 state, class_2591<B> blockEntityType, CoordinateFunctions.CoordinateConsumer<B> action) {
        if (state == null) {
            return;
        }
        this.world.method_8652((class_2338)this.scratchPos.method_10103(x, y, z), state, this.setBlockFlags);
        B blockEntity = WorldUtil.getBlockEntity((class_1922)this.world, (class_2338)this.scratchPos, blockEntityType);
        if (blockEntity != null) {
            action.accept(this.scratchPos, blockEntity);
        }
    }

    @Override
    public void modifyBlockState(int x, int y, int z, CoordinateFunctions.CoordinateUnaryOperator<class_2680> mapper) {
        class_2680 newState;
        class_2680 oldState = this.world.method_8320((class_2338)this.scratchPos.method_10103(x, y, z));
        if (oldState != (newState = (class_2680)mapper.apply(this.scratchPos, oldState)) && newState != null) {
            this.world.method_8652((class_2338)this.scratchPos.method_10103(x, y, z), newState, this.setBlockFlags);
        }
    }

    @Override
    public <E extends class_1297> void getEntities(int x, int y, int z, Class<E> entityType, CoordinateFunctions.CoordinateSupplier<class_238> boxSupplier, CoordinateFunctions.CoordinateConsumer<List<E>> entityAction) {
        class_238 box = boxSupplier.get(this.scratchPos.method_10103(x, y, z));
        entityAction.accept(this.scratchPos.method_10103(x, y, z), this.world.method_18467(entityType, box));
    }

    @Override
    public void addEntity(int x, int y, int z, CoordinateFunctions.CoordinateFunction<class_3218, class_1297> supplier) {
        class_1297 entity = supplier.apply(this.scratchPos.method_10103(x, y, z), this.world.method_8410());
        if (entity != null) {
            this.world.method_30771(entity);
        }
    }

    public int hashCode() {
        return this.world.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof WorldCoordinator)) return false;
        WorldCoordinator that = (WorldCoordinator)obj;
        if (!this.world.equals((Object)that.world)) return false;
        return true;
    }

    public String toString() {
        return "WorldCoordinator: { " + String.valueOf(this.world) + " }";
    }
}

