/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.versions;

import builderb0y.autocodec.reflection.reification.ReifiedType;
import builderb0y.autocodec.util.AutoCodecUtil;
import builderb0y.bigglobe.BigGlobeMod;
import builderb0y.bigglobe.codecs.BigGlobeAutoCodec;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.class_2487;
import net.minecraft.class_2491;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import org.slf4j.Logger;

public class DataHelper<T_Owner> {
    public final Class<T_Owner> owner;
    public final List<Entry<?>> entries = new ArrayList(4);

    public DataHelper(Class<T_Owner> owner) {
        this.owner = owner;
    }

    public EntryBuilder<?> begin(String name) {
        return new EntryBuilder(name);
    }

    public void read(T_Owner owner, class_2487 data) {
        for (Entry<?> entry : this.entries) {
            entry.read(owner, data);
        }
    }

    public void write(T_Owner owner, class_2487 data) {
        for (Entry<?> entry : this.entries) {
            entry.write(owner, data);
        }
    }

    public class EntryBuilder<T_Component> {
        public String name;
        public Codec<T_Component> codec;
        public FieldAccessor<T_Owner, T_Component> accessor;

        public EntryBuilder(String name) {
            this.name = name;
        }

        public <T_NewComponent> EntryBuilder<T_NewComponent> codec(Codec<T_NewComponent> codec) {
            EntryBuilder builder = this;
            builder.codec = codec;
            return builder;
        }

        public <T_NewComponent> EntryBuilder<T_NewComponent> codecFromType(ReifiedType<T_NewComponent> type) {
            EntryBuilder builder = this;
            builder.codec = BigGlobeAutoCodec.AUTO_CODEC.createDFUCodec(type);
            return builder;
        }

        public <T_NewComponent> EntryBuilder<T_NewComponent> codecFromClass(Class<T_NewComponent> clazz) {
            EntryBuilder builder = this;
            builder.codec = BigGlobeAutoCodec.AUTO_CODEC.createDFUCodec(clazz);
            return builder;
        }

        public <T_NewComponent> EntryBuilder<T_NewComponent> accessor(FieldAccessor<T_Owner, T_NewComponent> accessor, boolean setCodec) {
            EntryBuilder builder = this;
            builder.accessor = accessor;
            if (setCodec) {
                builder.codec = BigGlobeAutoCodec.AUTO_CODEC.createDFUCodec(accessor.componentType());
            }
            return builder;
        }

        public EntryBuilder<?> fieldAccessor(String fieldName, boolean setCodec) {
            return this.accessor(FieldAccessor.field(DataHelper.this.owner, fieldName), setCodec);
        }

        public EntryBuilder<?> pathAccessor(String path, boolean setCodec) {
            return this.accessor(FieldAccessor.path(DataHelper.this.owner, path), setCodec);
        }

        public DataHelper<T_Owner> add() {
            List<Entry<?>> list = DataHelper.this.entries;
            DataHelper dataHelper = DataHelper.this;
            Objects.requireNonNull(dataHelper);
            list.add(new Entry(dataHelper, this));
            return DataHelper.this;
        }
    }

    public class Entry<T_Component> {
        public final String name;
        public final Codec<T_Component> codec;
        public final FieldAccessor<T_Owner, T_Component> accessor;

        public Entry(DataHelper this$0, EntryBuilder<T_Component> builder) {
            this.name = Objects.requireNonNull(builder.name, "name");
            this.codec = Objects.requireNonNull(builder.codec, "codec");
            this.accessor = Objects.requireNonNull(builder.accessor, "accessor");
        }

        public void read(T_Owner owner, class_2487 nbt) {
            class_2520 input = nbt.method_10580(this.name);
            if (input == null) {
                input = class_2491.field_21033;
            }
            this.accessor.set(owner, this.codec.parse((DynamicOps)class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)BigGlobeMod.getCurrentServer().method_30611()), (Object)input).resultOrPartial(arg_0 -> ((Logger)BigGlobeMod.LOGGER).error(arg_0)).orElse(null));
        }

        public void write(T_Owner owner, class_2487 nbt) {
            T_Component component = this.accessor.get(owner);
            if (component != null) {
                nbt.method_10566(this.name, (class_2520)this.codec.encodeStart((DynamicOps)class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)BigGlobeMod.getCurrentServer().method_30611()), component).resultOrPartial(arg_0 -> ((Logger)BigGlobeMod.LOGGER).error(arg_0)).orElse(null));
            }
        }
    }

    public static interface FieldAccessor<T_Owner, T_Component> {
        public T_Component get(T_Owner var1);

        public void set(T_Owner var1, T_Component var2);

        public ReifiedType<T_Component> componentType();

        public static <T_Owner, T_Component> FieldAccessor<T_Owner, T_Component> of(final ReifiedType<T_Component> componentType, final Function<T_Owner, T_Component> getter, final BiConsumer<T_Owner, T_Component> setter) {
            return new FieldAccessor<T_Owner, T_Component>(){

                @Override
                public T_Component get(T_Owner owner) {
                    return owner == null ? null : (Object)getter.apply(owner);
                }

                @Override
                public void set(T_Owner owner, T_Component value) {
                    setter.accept(owner, value);
                }

                @Override
                public ReifiedType<T_Component> componentType() {
                    return componentType;
                }
            };
        }

        public static <T_Owner, T_Component> FieldAccessor<T_Owner, T_Component> of(final ReifiedType<T_Component> componentType, final VarHandle handle) {
            return new FieldAccessor<T_Owner, T_Component>(){

                @Override
                public T_Component get(T_Owner owner) {
                    return owner == null ? null : handle.get(owner);
                }

                @Override
                public void set(T_Owner owner, T_Component value) {
                    handle.set(owner, value);
                }

                @Override
                public ReifiedType<T_Component> componentType() {
                    return componentType;
                }
            };
        }

        public static <T_Owner> FieldAccessor<T_Owner, ?> field(Class<T_Owner> ownerClass, String fieldName) {
            try {
                Field field = ownerClass.getField(fieldName);
                return FieldAccessor.of(ReifiedType.from((AnnotatedType)field.getAnnotatedType()), MethodHandles.lookup().unreflectVarHandle(field));
            }
            catch (ReflectiveOperationException exception) {
                throw AutoCodecUtil.rethrow((Throwable)exception);
            }
        }

        public static <T_Owner> FieldAccessor<T_Owner, ?> path(Class<T_Owner> ownerClass, String path) {
            String[] parts = path.split("\\.");
            final VarHandle[] handles = new VarHandle[parts.length];
            Class<Object> intermediate = ownerClass;
            Field field = null;
            for (int index = 0; index < parts.length; ++index) {
                try {
                    field = intermediate.getField(parts[index]);
                    handles[index] = MethodHandles.lookup().unreflectVarHandle(field);
                    intermediate = field.getType();
                    continue;
                }
                catch (ReflectiveOperationException exception) {
                    throw AutoCodecUtil.rethrow((Throwable)exception);
                }
            }
            final ReifiedType componentType = ReifiedType.from((AnnotatedType)field.getAnnotatedType());
            return new FieldAccessor(){

                public Object get(Object owner) {
                    Object current = owner;
                    for (VarHandle handle : handles) {
                        if (current == null) {
                            return null;
                        }
                        current = handle.get(current);
                    }
                    return current;
                }

                public void set(Object owner, Object value) {
                    Object current = owner;
                    int limit = handles.length - 1;
                    for (int index = 0; index < limit; ++index) {
                        VarHandle handle = handles[index];
                        current = handle.get(current);
                    }
                    handles[limit].set(current, value);
                }

                public ReifiedType componentType() {
                    return componentType;
                }
            };
        }
    }
}

