/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.versions;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

public class TracyWrapper {
    public static final boolean ENABLED;
    public static final DecimalFormat FORMAT;
    public static ZoneWrapper current;

    @Nullable
    public static ZoneWrapper beginZone(String name) {
        return TracyWrapper.beginZone(() -> name);
    }

    @Nullable
    public static ZoneWrapper beginZone(Supplier<String> name) {
        return ENABLED ? (current = new ZoneWrapper(current, name)) : null;
    }

    public static void endZone(@Nullable ZoneWrapper zone) {
        if (zone != null) {
            zone.endTime = System.nanoTime();
            zone.completed = true;
            current = zone.parent;
            if (current == null) {
                long time = zone.endTime - zone.startTime;
                TracyWrapper.dumpZone(zone, 0, time, time);
            }
        }
    }

    public static void dumpZone(ZoneWrapper zone, int indentation, long parentTime, long totalTime) {
        String name = zone.nameSupplier.get();
        String indentString = "\t".repeat(indentation++);
        System.out.println(indentString + "BEGIN " + name + ": " + zone.startTime);
        long selfTime = zone.endTime - zone.startTime;
        if (zone.children != null) {
            for (ZoneWrapper child : zone.children) {
                TracyWrapper.dumpZone(child, indentation, selfTime, totalTime);
            }
        }
        if (zone.completed) {
            System.out.println(indentString + "END " + name + ": " + selfTime + " / " + totalTime + " (" + FORMAT.format((double)selfTime / (double)parentTime * 100.0) + "% parent, " + FORMAT.format((double)selfTime / (double)totalTime * 100.0) + "% total)");
        } else {
            System.out.println(indentString + "END " + name);
        }
    }

    static {
        boolean tracy;
        ENABLED = tracy = Boolean.getBoolean("bigglobe.tracy");
        if (tracy) {
            FORMAT = new DecimalFormat();
            FORMAT.setMinimumIntegerDigits(2);
            FORMAT.setMinimumFractionDigits(2);
        } else {
            FORMAT = null;
        }
    }

    public static class ZoneWrapper
    implements AutoCloseable {
        public ZoneWrapper parent;
        @Nullable
        public List<ZoneWrapper> children;
        public Supplier<String> nameSupplier;
        public long startTime = System.nanoTime();
        public long endTime;
        public boolean completed;

        public ZoneWrapper(ZoneWrapper parent, Supplier<String> nameSupplier) {
            this.parent = parent;
            this.nameSupplier = nameSupplier;
            if (parent != null) {
                if (parent.children == null) {
                    parent.children = new ArrayList<ZoneWrapper>();
                }
                parent.children.add(this);
            }
        }

        @Override
        public void close() {
            TracyWrapper.endZone(this);
        }
    }
}

