/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.scripting.bytecode;

import builderb0y.autocodec.util.ObjectArrayFactory;
import builderb0y.scripting.bytecode.ClassType;
import builderb0y.scripting.bytecode.FieldCompileContext;
import builderb0y.scripting.bytecode.FieldInfo;
import builderb0y.scripting.bytecode.InsnTrees;
import builderb0y.scripting.bytecode.LazyVarInfo;
import builderb0y.scripting.bytecode.MethodCompileContext;
import builderb0y.scripting.bytecode.MethodInfo;
import builderb0y.scripting.bytecode.TypeInfo;
import builderb0y.scripting.bytecode.tree.ConstantValue;
import builderb0y.scripting.bytecode.tree.InsnTree;
import builderb0y.scripting.parsing.ScriptClassLoader;
import builderb0y.scripting.util.CollectionTransformer;
import builderb0y.scripting.util.TypeInfos;
import builderb0y.scripting.util.TypeMerger;
import builderb0y.scripting.util.VariableNameTextifier;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.util.Printer;
import org.objectweb.asm.util.TraceClassVisitor;

public class ClassCompileContext {
    public static final ObjectArrayFactory<String> STRING_ARRAY_FACTORY = new ObjectArrayFactory(String.class);
    public ClassNode node;
    public TypeInfo info;
    public Map<String, TypeInfo> definedClasses;
    public List<ClassCompileContext> innerClasses;
    public List<MethodCompileContext> innerMethods;
    public int memberUniquifier;
    public List<Object> constants = new ArrayList<Object>();

    public ClassCompileContext(int access, TypeInfo info) {
        String name = info.getInternalName();
        int has = 0;
        int length = name.length();
        block6: for (int index = 0; index < length; ++index) {
            switch (name.charAt(index)) {
                case '/': {
                    has |= 1;
                    continue block6;
                }
                case '_': {
                    has |= 2;
                    continue block6;
                }
                case '$': {
                    has |= 4;
                    continue block6;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    has |= 8;
                }
            }
        }
        if (has != 15) {
            throw new IllegalStateException("For security reasons, your class name must contain a slash, an underscore, a dollar sign, and a number. (was '" + name + "')");
        }
        this.node = new ClassNode();
        this.info = info;
        this.definedClasses = new HashMap<String, TypeInfo>(2);
        this.definedClasses.put(info.getInternalName(), info);
        this.node.visit(61, access, info.getInternalName(), null, info.superClass.getInternalName(), CollectionTransformer.convertArray(info.superInterfaces, STRING_ARRAY_FACTORY, TypeInfo::getInternalName));
        this.node.visitSource("Script", null);
        this.innerClasses = new ArrayList<ClassCompileContext>(2);
        this.innerMethods = new ArrayList<MethodCompileContext>(8);
    }

    public ClassCompileContext(ClassCompileContext parent, int access, TypeInfo info) {
        this.node = new ClassNode();
        this.info = info;
        this.definedClasses = parent.definedClasses;
        this.definedClasses.put(info.getInternalName(), info);
        this.node.visit(61, access, info.getInternalName(), null, info.superClass.getInternalName(), CollectionTransformer.convertArray(info.superInterfaces, STRING_ARRAY_FACTORY, TypeInfo::getInternalName));
        this.node.visitSource(info.getSimpleName(), null);
        this.innerClasses = new ArrayList<ClassCompileContext>(0);
        this.innerMethods = new ArrayList<MethodCompileContext>(8);
    }

    public ClassCompileContext(int access, ClassType type, Type name, TypeInfo superClass, TypeInfo[] superInterfaces) {
        this(access, new TypeInfo(type, name, superClass, superInterfaces, null, false, (access & 0x10) != 0));
    }

    public ClassCompileContext(int access, ClassType type, String name, TypeInfo superClass, TypeInfo[] superInterfaces) {
        this(access, new TypeInfo(type, Type.getObjectType((String)name), superClass, superInterfaces, null, false, (access & 0x10) != 0));
    }

    public ConstantValue newConstant(Object value, TypeInfo type) {
        int which = this.constants.indexOf(value);
        if (which < 0) {
            which = this.constants.size();
            this.constants.add(value);
        }
        return ConstantValue.dynamic(type, ScriptClassLoader.GET_CONSTANT, ConstantValue.of(which));
    }

    public byte[] toByteArray() {
        for (MethodCompileContext method : this.innerMethods) {
            if (method.scopes.stack.isEmpty()) continue;
            throw new IllegalStateException(this.node.name + "." + method.node.name + "() has not had its scope fully popped yet!");
        }
        ClassWriter writer = new ClassWriter(3){

            public String getCommonSuperClass(String type1, String type2) {
                TypeInfo info1 = ClassCompileContext.this.definedClasses.get(type1);
                TypeInfo info2 = ClassCompileContext.this.definedClasses.get(type2);
                if (info1 == null) {
                    info1 = TypeInfo.parseInternalName(type1, 0, type1.length());
                }
                if (info2 == null) {
                    info2 = TypeInfo.parseInternalName(type2, 0, type2.length());
                }
                return TypeMerger.computeMostSpecificType(info1, info2).getInternalName();
            }
        };
        this.node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    public String dump() {
        StringWriter writer = new StringWriter(8192);
        this.node.accept((ClassVisitor)new TraceClassVisitor(null, (Printer)new VariableNameTextifier(), new PrintWriter(writer)));
        return writer.toString();
    }

    public void addNoArgConstructor(int access) {
        MethodCompileContext constructor = this.newMethod(access, "<init>", TypeInfos.VOID, new LazyVarInfo[0]);
        LazyVarInfo self = new LazyVarInfo("this", constructor.clazz.info);
        InsnTrees.return_(InsnTrees.invokeInstance(InsnTrees.load(self), new MethodInfo(1, this.info.superClass, "<init>", TypeInfos.VOID, new TypeInfo[0]), new InsnTree[0])).emitBytecode(constructor);
        constructor.endCode();
    }

    public void addToString(String string) {
        MethodCompileContext toString = this.newMethod(1, "toString", TypeInfos.STRING, new LazyVarInfo[0]);
        InsnTrees.return_(InsnTrees.ldc(string)).emitBytecode(toString);
        toString.endCode();
    }

    public MethodCompileContext newMethod(int access, String name, TypeInfo returnType, LazyVarInfo ... parameters) {
        MethodInfo info = new MethodInfo(access |= this.node.access & 0x200, this.info, name, returnType, CollectionTransformer.convertArray(parameters, TypeInfo[]::new, LazyVarInfo::type));
        MethodNode methodNode = new MethodNode(info.access(), info.name, info.getDescriptor(), null, null);
        this.node.methods.add(methodNode);
        MethodCompileContext methodCompileContext = new MethodCompileContext(this, methodNode, info, CollectionTransformer.convertArray(parameters, String[]::new, LazyVarInfo::name));
        this.innerMethods.add(methodCompileContext);
        return methodCompileContext;
    }

    public FieldCompileContext newField(FieldInfo info) {
        return this.newField(info.access, info.name, info.type);
    }

    public FieldCompileContext newField(int access, String name, TypeInfo type) {
        FieldCompileContext field = new FieldCompileContext(this, access, name, type);
        this.node.fields.add(field.node);
        return field;
    }

    public String innerClassName(String simpleName) {
        return this.info.getInternalName() + "$" + simpleName + "_" + this.innerClasses.size();
    }

    public ClassCompileContext newInnerClass(int access, String name, TypeInfo superClass, TypeInfo[] superInterfaces) {
        return this.newInnerClass(access, TypeInfo.makeClass(Type.getObjectType((String)name), superClass, superInterfaces, (access & 0x10) != 0));
    }

    public ClassCompileContext newInnerClass(int access, TypeInfo type) {
        ClassCompileContext inner = new ClassCompileContext(this, access, type);
        this.innerClasses.add(inner);
        this.node.visitInnerClass(type.getInternalName(), this.info.getInternalName(), type.getSimpleName(), access);
        inner.node.visitOuterClass(this.info.getInternalName(), null, null);
        return inner;
    }
}

