/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.scripting.bytecode;

import builderb0y.scripting.bytecode.ExtendedOpcodes;
import builderb0y.scripting.bytecode.FieldInfo;
import builderb0y.scripting.bytecode.LazyVarInfo;
import builderb0y.scripting.bytecode.MethodInfo;
import builderb0y.scripting.bytecode.ScopeContext;
import builderb0y.scripting.bytecode.TypeInfo;
import builderb0y.scripting.bytecode.tree.ConstantValue;
import builderb0y.scripting.bytecode.tree.InsnTree;
import builderb0y.scripting.bytecode.tree.conditions.AndConditionTree;
import builderb0y.scripting.bytecode.tree.conditions.BooleanToConditionTree;
import builderb0y.scripting.bytecode.tree.conditions.CompareConditionTree;
import builderb0y.scripting.bytecode.tree.conditions.ConditionTree;
import builderb0y.scripting.bytecode.tree.conditions.NotConditionTree;
import builderb0y.scripting.bytecode.tree.conditions.OrConditionTree;
import builderb0y.scripting.bytecode.tree.flow.IfElseInsnTree;
import builderb0y.scripting.bytecode.tree.flow.IfInsnTree;
import builderb0y.scripting.bytecode.tree.flow.SequenceInsnTree;
import builderb0y.scripting.bytecode.tree.flow.SwitchInsnTree;
import builderb0y.scripting.bytecode.tree.flow.loop.DoWhileInsnTree;
import builderb0y.scripting.bytecode.tree.flow.loop.ForInsnTree;
import builderb0y.scripting.bytecode.tree.flow.loop.WhileInsnTree;
import builderb0y.scripting.bytecode.tree.instructions.ArrayLoadInsnTree;
import builderb0y.scripting.bytecode.tree.instructions.ArrayStoreInsnTree;
import builderb0y.scripting.bytecode.tree.instructions.BlockInsnTree;
import builderb0y.scripting.bytecode.tree.instructions.ConditionToBooleanInsnTree;
import builderb0y.scripting.bytecode.tree.instructions.ConstantInsnTree;
import builderb0y.scripting.bytecode.tree.instructions.GetFromStackInsnTree;
import builderb0y.scripting.bytecode.tree.instructions.IncrementInsnTree;
import builderb0y.scripting.bytecode.tree.instructions.LoadInsnTree;
import builderb0y.scripting.bytecode.tree.instructions.NewArrayWithContentsInsnTree;
import builderb0y.scripting.bytecode.tree.instructions.NewArrayWithLengthInsnTree;
import builderb0y.scripting.bytecode.tree.instructions.NoopInsnTree;
import builderb0y.scripting.bytecode.tree.instructions.ReturnInsnTree;
import builderb0y.scripting.bytecode.tree.instructions.ScopedInsnTree;
import builderb0y.scripting.bytecode.tree.instructions.StoreInsnTree;
import builderb0y.scripting.bytecode.tree.instructions.ThrowInsnTree;
import builderb0y.scripting.bytecode.tree.instructions.binary.AddInsnTree;
import builderb0y.scripting.bytecode.tree.instructions.binary.BitwiseAndInsnTree;
import builderb0y.scripting.bytecode.tree.instructions.binary.BitwiseOrInsnTree;
import builderb0y.scripting.bytecode.tree.instructions.binary.BitwiseXorInsnTree;
import builderb0y.scripting.bytecode.tree.instructions.binary.DivideInsnTree;
import builderb0y.scripting.bytecode.tree.instructions.binary.ModuloInsnTree;
import builderb0y.scripting.bytecode.tree.instructions.binary.MultiplyInsnTree;
import builderb0y.scripting.bytecode.tree.instructions.binary.PowerInsnTree;
import builderb0y.scripting.bytecode.tree.instructions.binary.SignedLeftShiftInsnTree;
import builderb0y.scripting.bytecode.tree.instructions.binary.SignedRightShiftInsnTree;
import builderb0y.scripting.bytecode.tree.instructions.binary.SubtractInsnTree;
import builderb0y.scripting.bytecode.tree.instructions.binary.UnsignedLeftShiftInsnTree;
import builderb0y.scripting.bytecode.tree.instructions.binary.UnsignedRightShiftInsnTree;
import builderb0y.scripting.bytecode.tree.instructions.casting.IdentityCastInsnTree;
import builderb0y.scripting.bytecode.tree.instructions.casting.WrappedCastInsnTree;
import builderb0y.scripting.bytecode.tree.instructions.fields.GetStaticInsnTree;
import builderb0y.scripting.bytecode.tree.instructions.fields.NormalInstanceGetFieldInsnTree;
import builderb0y.scripting.bytecode.tree.instructions.fields.PutFieldInsnTree;
import builderb0y.scripting.bytecode.tree.instructions.fields.PutStaticInsnTree;
import builderb0y.scripting.bytecode.tree.instructions.invokers.InvokeDynamicInsnTree;
import builderb0y.scripting.bytecode.tree.instructions.invokers.NewInsnTree;
import builderb0y.scripting.bytecode.tree.instructions.invokers.NormalInvokeInsnTree;
import builderb0y.scripting.bytecode.tree.instructions.invokers.StaticInvokeInsnTree;
import builderb0y.scripting.bytecode.tree.instructions.unary.InstanceOfInsnTree;
import builderb0y.scripting.bytecode.tree.instructions.unary.NegateInsnTree;
import builderb0y.scripting.bytecode.tree.instructions.unary.SquareInsnTree;
import builderb0y.scripting.parsing.ExpressionParser;
import builderb0y.scripting.parsing.ScriptParsingException;
import builderb0y.scripting.util.CollectionTransformer;
import builderb0y.scripting.util.TypeInfos;
import com.google.common.collect.ObjectArrays;
import it.unimi.dsi.fastutil.ints.Int2ObjectSortedMap;
import java.lang.invoke.StringConcatFactory;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.function.BinaryOperator;
import java.util.function.IntFunction;
import org.objectweb.asm.Label;
import org.objectweb.asm.tree.LabelNode;

public class InsnTrees
implements ExtendedOpcodes {
    public static final NoopInsnTree noop = NoopInsnTree.INSTANCE;
    public static final MethodInfo MAKE_CONCAT_WITH_CONSTANTS = MethodInfo.getMethod(StringConcatFactory.class, "makeConcatWithConstants");

    public static TypeInfo type(Class<?> clazz) {
        return TypeInfo.of(clazz);
    }

    public static TypeInfo[] types(Class<?> ... classes) {
        return CollectionTransformer.convertArray(classes, TypeInfo.ARRAY_FACTORY, TypeInfo::of);
    }

    public static TypeInfo type(String desc) {
        return TypeInfo.parse(desc);
    }

    public static TypeInfo[] types(String descs) {
        return TypeInfo.parseAll(descs);
    }

    public static TypeInfo[] types(Object ... objects) {
        return TypeInfo.parseObjects(objects);
    }

    public static ConstantValue constant(boolean value) {
        return ConstantValue.of(value);
    }

    public static ConstantValue constant(byte value) {
        return ConstantValue.of(value);
    }

    public static ConstantValue constant(char value) {
        return ConstantValue.of(value);
    }

    public static ConstantValue constant(short value) {
        return ConstantValue.of(value);
    }

    public static ConstantValue constant(int value) {
        return ConstantValue.of(value);
    }

    public static ConstantValue constant(long value) {
        return ConstantValue.of(value);
    }

    public static ConstantValue constant(float value) {
        return ConstantValue.of(value);
    }

    public static ConstantValue constant(double value) {
        return ConstantValue.of(value);
    }

    public static ConstantValue constant(String value) {
        return ConstantValue.of(value);
    }

    public static ConstantValue constant(TypeInfo value) {
        return ConstantValue.of(value);
    }

    public static ConstantValue constant(Object value, TypeInfo type) {
        return ConstantValue.of(value, type);
    }

    public static ConstantValue constant(MethodInfo bootstrapMethod, ConstantValue ... bootstrapArgs) {
        return ConstantValue.dynamic(bootstrapMethod, bootstrapArgs);
    }

    public static ConstantValue constantAbsent(TypeInfo type) {
        return switch (type.getSort()) {
            default -> throw new IncompatibleClassChangeError();
            case TypeInfo.Sort.BYTE -> InsnTrees.constant((byte)0);
            case TypeInfo.Sort.CHAR -> InsnTrees.constant('\u0000');
            case TypeInfo.Sort.SHORT -> InsnTrees.constant((short)0);
            case TypeInfo.Sort.INT -> InsnTrees.constant(0);
            case TypeInfo.Sort.LONG -> InsnTrees.constant(0L);
            case TypeInfo.Sort.FLOAT -> InsnTrees.constant(Float.NaN);
            case TypeInfo.Sort.DOUBLE -> InsnTrees.constant(Double.NaN);
            case TypeInfo.Sort.BOOLEAN -> InsnTrees.constant(false);
            case TypeInfo.Sort.OBJECT, TypeInfo.Sort.ARRAY -> InsnTrees.constant(null, type);
            case TypeInfo.Sort.VOID -> throw new IllegalArgumentException("Void-typed field");
        };
    }

    public static InsnTree ldc(boolean value) {
        return new ConstantInsnTree(InsnTrees.constant(value));
    }

    public static InsnTree ldc(byte value) {
        return new ConstantInsnTree(InsnTrees.constant(value));
    }

    public static InsnTree ldc(char value) {
        return new ConstantInsnTree(InsnTrees.constant(value));
    }

    public static InsnTree ldc(short value) {
        return new ConstantInsnTree(InsnTrees.constant(value));
    }

    public static InsnTree ldc(int value) {
        return new ConstantInsnTree(InsnTrees.constant(value));
    }

    public static InsnTree ldc(long value) {
        return new ConstantInsnTree(InsnTrees.constant(value));
    }

    public static InsnTree ldc(float value) {
        return new ConstantInsnTree(InsnTrees.constant(value));
    }

    public static InsnTree ldc(double value) {
        return new ConstantInsnTree(InsnTrees.constant(value));
    }

    public static InsnTree ldc(String value) {
        return new ConstantInsnTree(InsnTrees.constant(value));
    }

    public static InsnTree ldc(TypeInfo value) {
        return new ConstantInsnTree(InsnTrees.constant(value));
    }

    public static InsnTree ldc(Object value, TypeInfo type) {
        return new ConstantInsnTree(InsnTrees.constant(value, type));
    }

    public static InsnTree ldc(MethodInfo bootstrapMethod, ConstantValue ... bootstrapArgs) {
        return new ConstantInsnTree(InsnTrees.constant(bootstrapMethod, bootstrapArgs));
    }

    public static InsnTree ldc(ConstantValue value) {
        return new ConstantInsnTree(value);
    }

    public static InsnTree ldcAbsent(TypeInfo type) {
        return InsnTrees.ldc(InsnTrees.constantAbsent(type));
    }

    public static LoadInsnTree load(LazyVarInfo variable) {
        return new LoadInsnTree(variable);
    }

    public static LoadInsnTree load(String name, TypeInfo type) {
        return new LoadInsnTree(new LazyVarInfo(name, type));
    }

    public static InsnTree store(LazyVarInfo variable, InsnTree value) {
        return new StoreInsnTree(variable, value);
    }

    public static InsnTree arrayLoad(InsnTree array, InsnTree index) {
        return ArrayLoadInsnTree.create(array, index);
    }

    public static InsnTree arrayStore(InsnTree array, InsnTree index, InsnTree value) {
        return ArrayStoreInsnTree.create(array, index, value);
    }

    public static InsnTree return_(InsnTree value) {
        return ReturnInsnTree.create(value);
    }

    public static InsnTree throw_(InsnTree value) {
        return ThrowInsnTree.create(value);
    }

    public static InsnTree add(ExpressionParser parser, InsnTree left, InsnTree right) {
        return AddInsnTree.create(parser, left, right);
    }

    public static InsnTree add(ExpressionParser parser, InsnTree ... operands) {
        return InsnTrees.reduceWithParser(parser, AddInsnTree::create, operands);
    }

    public static InsnTree sub(ExpressionParser parser, InsnTree left, InsnTree right) {
        return SubtractInsnTree.create(parser, left, right);
    }

    public static InsnTree mul(ExpressionParser parser, InsnTree left, InsnTree right) {
        return MultiplyInsnTree.create(parser, left, right);
    }

    public static InsnTree mul(ExpressionParser parser, InsnTree ... operands) {
        return InsnTrees.reduceWithParser(parser, MultiplyInsnTree::create, operands);
    }

    public static InsnTree div(ExpressionParser parser, InsnTree left, InsnTree right) throws ScriptParsingException {
        return DivideInsnTree.create(parser, left, right);
    }

    public static InsnTree mod(ExpressionParser parser, InsnTree left, InsnTree right) {
        return ModuloInsnTree.create(parser, left, right);
    }

    public static InsnTree pow(ExpressionParser parser, InsnTree left, InsnTree right) {
        return PowerInsnTree.create(parser, left, right);
    }

    public static InsnTree band(ExpressionParser parser, InsnTree left, InsnTree right) {
        return BitwiseAndInsnTree.create(parser, left, right);
    }

    public static InsnTree band(ExpressionParser parser, InsnTree ... operands) {
        return InsnTrees.reduceWithParser(parser, BitwiseAndInsnTree::create, operands);
    }

    public static InsnTree bor(ExpressionParser parser, InsnTree left, InsnTree right) {
        return BitwiseOrInsnTree.create(parser, left, right);
    }

    public static InsnTree bor(ExpressionParser parser, InsnTree ... operands) {
        return InsnTrees.reduceWithParser(parser, BitwiseOrInsnTree::create, operands);
    }

    public static InsnTree bxor(ExpressionParser parser, InsnTree left, InsnTree right) {
        return BitwiseXorInsnTree.create(parser, left, right);
    }

    public static InsnTree bxor(ExpressionParser parser, InsnTree ... operands) {
        return InsnTrees.reduceWithParser(parser, BitwiseXorInsnTree::create, operands);
    }

    public static InsnTree shl(ExpressionParser parser, InsnTree left, InsnTree right) {
        return SignedLeftShiftInsnTree.create(parser, left, right);
    }

    public static InsnTree ushl(ExpressionParser parser, InsnTree left, InsnTree right) {
        return UnsignedLeftShiftInsnTree.create(parser, left, right);
    }

    public static InsnTree shr(ExpressionParser parser, InsnTree left, InsnTree right) {
        return SignedRightShiftInsnTree.create(parser, left, right);
    }

    public static InsnTree ushr(ExpressionParser parser, InsnTree left, InsnTree right) {
        return UnsignedRightShiftInsnTree.create(parser, left, right);
    }

    public static InsnTree instanceOf(InsnTree operand, TypeInfo type) {
        return InstanceOfInsnTree.create(operand, type);
    }

    public static InsnTree neg(InsnTree value) {
        return NegateInsnTree.create(value);
    }

    public static InsnTree square(InsnTree value) {
        return SquareInsnTree.create(value);
    }

    public static InsnTree inc(LazyVarInfo variable, int amount) {
        return IncrementInsnTree.create(variable, amount);
    }

    public static InsnTree invokeStatic(MethodInfo method, InsnTree ... args) {
        return StaticInvokeInsnTree.create(method, args);
    }

    public static InsnTree invokeInstance(InsnTree receiver, MethodInfo method, InsnTree ... args) {
        return new NormalInvokeInsnTree(receiver, method, args);
    }

    public static InsnTree invokeDynamic(MethodInfo bootstrapMethod, MethodInfo runtimeMethod, ConstantValue[] bootstrapArgs, InsnTree[] runtimeArgs) {
        return new InvokeDynamicInsnTree(bootstrapMethod, runtimeMethod, bootstrapArgs, runtimeArgs);
    }

    public static InsnTree invokeWrapped(InsnTree receiver, MethodInfo method, InsnTree ... args) {
        return InsnTrees.invokeStatic(method, (InsnTree[])ObjectArrays.concat((Object)receiver, (Object[])args));
    }

    public static InsnTree newInstance(MethodInfo constructor, InsnTree ... args) {
        return new NewInsnTree(constructor, args);
    }

    public static InsnTree newArrayWithLength(TypeInfo arrayType, InsnTree length) {
        return NewArrayWithLengthInsnTree.create(arrayType, length);
    }

    public static InsnTree newArrayWithContents(ExpressionParser parser, TypeInfo arrayType, InsnTree ... elements) {
        return NewArrayWithContentsInsnTree.create(parser, arrayType, elements);
    }

    public static InsnTree getStatic(FieldInfo field) {
        return new GetStaticInsnTree(field);
    }

    public static InsnTree getStatic(int access, TypeInfo owner, String name, TypeInfo desc) {
        return new GetStaticInsnTree(new FieldInfo(access, owner, name, desc));
    }

    public static InsnTree putStatic(FieldInfo field, InsnTree value) {
        return new PutStaticInsnTree(field, value);
    }

    public static InsnTree getField(InsnTree receiver, FieldInfo field) {
        return new NormalInstanceGetFieldInsnTree(receiver, field);
    }

    public static InsnTree putField(InsnTree receiver, FieldInfo field, InsnTree value) {
        return new PutFieldInsnTree(receiver, field, value);
    }

    public static ConditionTree condition(ExpressionParser parser, InsnTree bool) {
        return BooleanToConditionTree.create(parser, bool);
    }

    public static InsnTree bool(ConditionTree condition) {
        return ConditionToBooleanInsnTree.create(condition);
    }

    public static ConditionTree and(ConditionTree left, ConditionTree right) {
        return AndConditionTree.create(left, right);
    }

    public static ConditionTree and(ConditionTree ... conditions) {
        return InsnTrees.reduce(AndConditionTree::create, conditions);
    }

    public static InsnTree and(ExpressionParser parser, InsnTree left, InsnTree right) {
        return InsnTrees.bool(InsnTrees.and(InsnTrees.condition(parser, left), InsnTrees.condition(parser, right)));
    }

    public static InsnTree and(ExpressionParser parser, InsnTree ... bools) {
        return InsnTrees.reduceWithParser(parser, InsnTrees::and, bools);
    }

    public static ConditionTree or(ConditionTree left, ConditionTree right) {
        return OrConditionTree.create(left, right);
    }

    public static ConditionTree or(ConditionTree ... conditions) {
        return InsnTrees.reduce(OrConditionTree::create, conditions);
    }

    public static InsnTree or(ExpressionParser parser, InsnTree left, InsnTree right) {
        return InsnTrees.bool(InsnTrees.or(InsnTrees.condition(parser, left), InsnTrees.condition(parser, right)));
    }

    public static InsnTree or(ExpressionParser parser, InsnTree ... bools) {
        return InsnTrees.reduceWithParser(parser, InsnTrees::or, bools);
    }

    public static InsnTree xor(ExpressionParser parser, InsnTree left, InsnTree right) {
        left = left.cast(parser, TypeInfos.BOOLEAN, InsnTree.CastMode.IMPLICIT_THROW, false);
        right = right.cast(parser, TypeInfos.BOOLEAN, InsnTree.CastMode.IMPLICIT_THROW, false);
        return InsnTrees.bxor(parser, left, right);
    }

    public static ConditionTree xor(ExpressionParser parser, ConditionTree left, ConditionTree right) {
        return InsnTrees.condition(parser, InsnTrees.xor(parser, InsnTrees.bool(left), InsnTrees.bool(right)));
    }

    public static ConditionTree eq(ExpressionParser parser, InsnTree left, InsnTree right) {
        return CompareConditionTree.equal(parser, left, right);
    }

    public static ConditionTree ne(ExpressionParser parser, InsnTree left, InsnTree right) {
        return CompareConditionTree.notEqual(parser, left, right);
    }

    public static ConditionTree identityEq(ExpressionParser parser, InsnTree left, InsnTree right) {
        return CompareConditionTree.identityEqual(parser, left, right);
    }

    public static ConditionTree identityNe(ExpressionParser parser, InsnTree left, InsnTree right) {
        return CompareConditionTree.identityNotEqual(parser, left, right);
    }

    public static ConditionTree gt(ExpressionParser parser, InsnTree left, InsnTree right) {
        return CompareConditionTree.greaterThan(parser, left, right);
    }

    public static ConditionTree lt(ExpressionParser parser, InsnTree left, InsnTree right) {
        return CompareConditionTree.lessThan(parser, left, right);
    }

    public static ConditionTree ge(ExpressionParser parser, InsnTree left, InsnTree right) {
        return CompareConditionTree.greaterThanOrEqual(parser, left, right);
    }

    public static ConditionTree le(ExpressionParser parser, InsnTree left, InsnTree right) {
        return CompareConditionTree.lessThanOrEqual(parser, left, right);
    }

    public static ConditionTree not(ConditionTree condition) {
        return NotConditionTree.create(condition);
    }

    public static InsnTree not(ExpressionParser parser, InsnTree bool) {
        return InsnTrees.bool(InsnTrees.not(InsnTrees.condition(parser, bool)));
    }

    public static InsnTree ifThen(ConditionTree condition, InsnTree body) {
        return IfInsnTree.create(condition, body);
    }

    public static InsnTree ifElse(ExpressionParser parser, ConditionTree conditionTree, InsnTree trueBody, InsnTree falseBody) throws ScriptParsingException {
        return IfElseInsnTree.create(parser, conditionTree, trueBody, falseBody);
    }

    public static InsnTree while_(ScopeContext.LoopName loopName, ConditionTree condition, InsnTree body) {
        return new WhileInsnTree(loopName, condition, body);
    }

    public static InsnTree doWhile(ScopeContext.LoopName loopName, ConditionTree condition, InsnTree body) {
        return new DoWhileInsnTree(loopName, condition, body);
    }

    public static InsnTree for_(ScopeContext.LoopName loopName, InsnTree initializer, ConditionTree condition, InsnTree step, InsnTree body) {
        return new ForInsnTree(loopName, initializer, condition, step, body);
    }

    @Deprecated
    public static InsnTree seq() {
        return noop;
    }

    @Deprecated
    public static InsnTree seq(InsnTree tree) {
        return tree;
    }

    public static InsnTree seq(InsnTree first, InsnTree second) {
        return new SequenceInsnTree(first, second);
    }

    public static InsnTree seq(InsnTree ... statements) {
        return switch (statements.length) {
            case 0 -> noop;
            case 1 -> statements[0];
            default -> new SequenceInsnTree(statements);
        };
    }

    public static InsnTree switch_(ExpressionParser parser, InsnTree value, Int2ObjectSortedMap<InsnTree> cases) {
        return SwitchInsnTree.create(parser, value, cases);
    }

    public static InsnTree scoped(InsnTree body) {
        return ScopedInsnTree.create(body);
    }

    public static InsnTree block(ScopeContext.LoopName loopName, InsnTree body) {
        return new BlockInsnTree(loopName, body);
    }

    public static InsnTree getFromStack(TypeInfo type) {
        return new GetFromStackInsnTree(type);
    }

    public static InsnTree wrapIdentityCast(InsnTree value, TypeInfo type) {
        return new WrappedCastInsnTree(value, new IdentityCastInsnTree(value, type));
    }

    public static Label label() {
        Label label = new Label();
        label.info = new LabelNode(label);
        return label;
    }

    public static LabelNode labelNode() {
        LabelNode node = new LabelNode();
        node.getLabel().info = node;
        return node;
    }

    public static <T> T[] repeat(T element, int times) {
        Object[] array = (Object[])Array.newInstance(element.getClass(), times);
        Arrays.fill(array, element);
        return array;
    }

    public static InsnTree concat(String template, InsnTree ... arguments) {
        return InsnTrees.invokeDynamic(MAKE_CONCAT_WITH_CONSTANTS, new MethodInfo(9, TypeInfos.OBJECT, "concat", TypeInfos.STRING, (TypeInfo[])Arrays.stream(arguments).map(InsnTree::getTypeInfo).toArray((IntFunction<A[]>)TypeInfo.ARRAY_FACTORY)), new ConstantValue[]{InsnTrees.constant(template)}, arguments);
    }

    @SafeVarargs
    public static <T> T reduce(BinaryOperator<T> reducer, T ... operands) {
        Object result = operands[0];
        int length = operands.length;
        for (int index = 1; index < length; ++index) {
            result = reducer.apply(result, operands[index]);
        }
        return result;
    }

    @SafeVarargs
    public static <T> T reduceWithParser(ExpressionParser parser, ParserReducer<T> reducer, T ... operands) {
        T result = operands[0];
        int length = operands.length;
        for (int index = 1; index < length; ++index) {
            result = reducer.apply(parser, result, operands[index]);
        }
        return result;
    }

    @FunctionalInterface
    public static interface ParserReducer<T> {
        public T apply(ExpressionParser var1, T var2, T var3);
    }
}

