/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.scripting.bytecode;

import builderb0y.autocodec.util.ObjectArrayFactory;
import builderb0y.scripting.bytecode.MethodCompileContext;
import builderb0y.scripting.bytecode.TypeInfo;
import builderb0y.scripting.bytecode.Typeable;

public class LazyVarInfo
implements Typeable {
    public static final ObjectArrayFactory<LazyVarInfo> ARRAY_FACTORY = new ObjectArrayFactory(LazyVarInfo.class);
    public final String name;
    public final TypeInfo type;

    public LazyVarInfo(String name, TypeInfo type) {
        this.name = name;
        this.type = type;
        if (type.isVoid()) {
            throw new IllegalArgumentException("Void-typed variable: " + String.valueOf(this));
        }
    }

    public String name() {
        return this.name;
    }

    public TypeInfo type() {
        return this.type;
    }

    @Override
    public TypeInfo getTypeInfo() {
        return this.type;
    }

    public void emitLoad(MethodCompileContext context) {
        int index = context.scopes.getVariableIndex(this);
        context.node.visitVarInsn(this.type.getOpcode(21), index);
    }

    public void emitStore(MethodCompileContext context) {
        int index = context.scopes.getVariableIndex(this);
        context.node.visitVarInsn(this.type.getOpcode(54), index);
    }

    public String toString() {
        return this.name + " : " + String.valueOf(this.type);
    }

    public int hashCode() {
        return this.name.hashCode() * 31 + this.type.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (this == object) return true;
        if (!(object instanceof LazyVarInfo)) return false;
        LazyVarInfo that = (LazyVarInfo)object;
        if (!this.name.equals(that.name)) return false;
        if (!this.type.equals(that.type)) return false;
        return true;
    }
}

