/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.scripting.bytecode.loops;

import builderb0y.scripting.bytecode.InsnTrees;
import builderb0y.scripting.bytecode.LazyVarInfo;
import builderb0y.scripting.bytecode.ScopeContext;
import builderb0y.scripting.bytecode.loops.LoopFactory;
import builderb0y.scripting.bytecode.tree.InsnTree;
import builderb0y.scripting.bytecode.tree.VariableDeclarationInsnTree;
import builderb0y.scripting.bytecode.tree.VariableDeclareAssignInsnTree;
import builderb0y.scripting.bytecode.tree.flow.loop.AbstractForIteratorInsnTree;
import builderb0y.scripting.bytecode.tree.flow.loop.ForIndexedSequentialListInsnTree;
import builderb0y.scripting.bytecode.tree.flow.loop.ForIteratorInsnTree;
import builderb0y.scripting.parsing.ExpressionParser;
import builderb0y.scripting.parsing.ScriptParsingException;
import builderb0y.scripting.util.TypeInfos;
import java.util.List;

public class SequentialListLoopFactory
implements LoopFactory {
    public InsnTree list;

    public SequentialListLoopFactory(InsnTree list) {
        this.list = list;
    }

    @Override
    public InsnTree createLoop(ExpressionParser parser, ScopeContext.LoopName loopName, List<VariableDeclarationInsnTree> variables, InsnTree body) throws ScriptParsingException {
        return switch (variables.size()) {
            case 1 -> new ForIteratorInsnTree(loopName, variables.get(0), new VariableDeclareAssignInsnTree(new LazyVarInfo(parser.method.mangleName("iterator"), TypeInfos.ITERATOR), InsnTrees.invokeInstance(this.list, AbstractForIteratorInsnTree.LIST_ITERATOR, new InsnTree[0])), body);
            case 2 -> {
                if (!variables.get((int)0).variable.type.equals(TypeInfos.INT)) {
                    throw new ScriptParsingException("index-value iteration over List requires first variable to be of type int.", parser.input);
                }
                yield new ForIndexedSequentialListInsnTree(loopName, variables.get(0), variables.get(1), new VariableDeclareAssignInsnTree(new LazyVarInfo(parser.method.mangleName("iterator"), TypeInfos.ITERATOR), InsnTrees.invokeInstance(this.list, AbstractForIteratorInsnTree.LIST_ITERATOR, new InsnTree[0])), body);
            }
            default -> throw new ScriptParsingException("Iteration over List requires 1 or 2 variables", parser.input);
        };
    }
}

