/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.scripting.bytecode.tree.conditions;

import builderb0y.scripting.bytecode.MethodCompileContext;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Label;
import org.objectweb.asm.Opcodes;

public interface ConditionTree
extends Opcodes {
    public void emitBytecode(MethodCompileContext var1, @Nullable Label var2, @Nullable Label var3);

    public static void checkLabels(@Nullable Label ifTrue, @Nullable Label ifFalse) {
        if (ifTrue == ifFalse) {
            throw new IllegalArgumentException("ifTrue and ifFalse cannot both point to the same location.");
        }
    }

    public static int negateOpcode(int opcode) {
        return switch (opcode) {
            case 153 -> 154;
            case 154 -> 153;
            case 155 -> 156;
            case 156 -> 155;
            case 157 -> 158;
            case 158 -> 157;
            case 159 -> 160;
            case 160 -> 159;
            case 161 -> 162;
            case 162 -> 161;
            case 163 -> 164;
            case 164 -> 163;
            case 165 -> 166;
            case 166 -> 165;
            case 198 -> 199;
            case 199 -> 198;
            default -> throw new IllegalArgumentException("Invalid jump opcode");
        };
    }

    public static int flipOpcode(int opcode) {
        return switch (opcode) {
            case 153 -> 153;
            case 154 -> 154;
            case 155 -> 157;
            case 156 -> 158;
            case 157 -> 155;
            case 158 -> 156;
            case 159 -> 159;
            case 160 -> 160;
            case 161 -> 163;
            case 162 -> 164;
            case 163 -> 161;
            case 164 -> 162;
            case 165 -> 165;
            case 166 -> 166;
            case 198 -> 198;
            case 199 -> 199;
            default -> throw new IllegalArgumentException("Invalid jump opcode");
        };
    }
}

