/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.scripting.bytecode.tree.conditions;

import builderb0y.scripting.bytecode.MethodCompileContext;
import builderb0y.scripting.bytecode.tree.ConstantValue;
import builderb0y.scripting.bytecode.tree.InsnTree;
import builderb0y.scripting.bytecode.tree.conditions.ConditionTree;
import builderb0y.scripting.bytecode.tree.conditions.ConstantConditionTree;
import builderb0y.scripting.bytecode.tree.conditions.IntCompareConditionTree;

public class LongCompareConditionTree
extends IntCompareConditionTree {
    public LongCompareConditionTree(InsnTree left, InsnTree right, int opcode) {
        super(left, right, opcode);
    }

    public static ConditionTree create(InsnTree left, InsnTree right, int opcode, LongBiPredicate ifConstant) {
        ConstantValue leftConstant = left.getConstantValue();
        ConstantValue rightConstant = right.getConstantValue();
        if (leftConstant.isConstant() && rightConstant.isConstant()) {
            return ConstantConditionTree.of(ifConstant.test(leftConstant.asLong(), rightConstant.asLong()));
        }
        return new LongCompareConditionTree(left, right, opcode);
    }

    public static ConditionTree equal(InsnTree left, InsnTree right) {
        return LongCompareConditionTree.create(left, right, 153, (l, r) -> l == r);
    }

    public static ConditionTree notEqual(InsnTree left, InsnTree right) {
        return LongCompareConditionTree.create(left, right, 154, (l, r) -> l != r);
    }

    public static ConditionTree lessThan(InsnTree left, InsnTree right) {
        return LongCompareConditionTree.create(left, right, 155, (l, r) -> l < r);
    }

    public static ConditionTree greaterThan(InsnTree left, InsnTree right) {
        return LongCompareConditionTree.create(left, right, 157, (l, r) -> l > r);
    }

    public static ConditionTree lessThanOrEqual(InsnTree left, InsnTree right) {
        return LongCompareConditionTree.create(left, right, 158, (l, r) -> l <= r);
    }

    public static ConditionTree greaterThanOrEqual(InsnTree left, InsnTree right) {
        return LongCompareConditionTree.create(left, right, 156, (l, r) -> l >= r);
    }

    @Override
    public void toInt(MethodCompileContext method) {
        method.node.visitInsn(148);
    }

    @FunctionalInterface
    public static interface LongBiPredicate {
        public boolean test(long var1, long var3);
    }
}

