/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.scripting.bytecode.tree.flow.loop;

import builderb0y.scripting.bytecode.InsnTrees;
import builderb0y.scripting.bytecode.LazyVarInfo;
import builderb0y.scripting.bytecode.MethodCompileContext;
import builderb0y.scripting.bytecode.ScopeContext;
import builderb0y.scripting.bytecode.tree.ConstantValue;
import builderb0y.scripting.bytecode.tree.InsnTree;
import builderb0y.scripting.bytecode.tree.VariableDeclarationInsnTree;
import builderb0y.scripting.bytecode.tree.conditions.IntCompareConditionTree;
import builderb0y.scripting.bytecode.tree.flow.loop.AbstractForRangeInsnTree;
import builderb0y.scripting.bytecode.tree.instructions.binary.AddInsnTree;
import builderb0y.scripting.bytecode.tree.instructions.binary.SubtractInsnTree;
import org.objectweb.asm.Label;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.LabelNode;

public class ForIntRangeInsnTree
extends AbstractForRangeInsnTree {
    public ForIntRangeInsnTree(ScopeContext.LoopName loopName, VariableDeclarationInsnTree variable, boolean ascending, InsnTree lowerBound, boolean lowerBoundInclusive, LazyVarInfo lowerBoundVariable, InsnTree upperBound, boolean upperBoundInclusive, LazyVarInfo upperBoundVariable, InsnTree step, LazyVarInfo stepVariable, InsnTree body) {
        super(loopName, variable, ascending, lowerBound, lowerBoundInclusive, lowerBoundVariable, upperBound, upperBoundInclusive, upperBoundVariable, step, stepVariable, body);
    }

    @Override
    public void emitBytecode(MethodCompileContext method) {
        LabelNode continuePoint = InsnTrees.labelNode();
        ScopeContext.Scope mainLoop = method.scopes.pushLoop(this.loopName, continuePoint);
        this.variable.emitBytecode(method);
        InsnTree lowerBound = this.lowerBound;
        InsnTree upperBound = this.upperBound;
        if (this.lowerBoundVariable != null || this.upperBoundVariable != null) {
            if (this.lowerBoundVariable != null) {
                method.scopes.addVariable(this.lowerBoundVariable);
            }
            if (this.upperBoundVariable != null) {
                method.scopes.addVariable(this.upperBoundVariable);
            }
            method.scopes.pushScope();
            if (this.lowerBoundVariable != null) {
                InsnTrees.store(this.lowerBoundVariable, lowerBound).emitBytecode(method);
                lowerBound = InsnTrees.load(this.lowerBoundVariable);
            }
            if (this.upperBoundVariable != null) {
                InsnTrees.store(this.upperBoundVariable, upperBound).emitBytecode(method);
                upperBound = InsnTrees.load(this.upperBoundVariable);
            }
            method.scopes.popScope();
        }
        InsnTree step = this.step;
        if (this.stepVariable != null) {
            method.scopes.addVariable(this.stepVariable);
            InsnTrees.store(this.stepVariable, step).emitBytecode(method);
            step = InsnTrees.load(this.stepVariable);
        }
        if (this.ascending) {
            InsnTrees.store(this.variable.variable, lowerBound).emitBytecode(method);
            if (this.lowerBoundInclusive) {
                int stepSize;
                Label start = InsnTrees.label();
                method.node.visitLabel(start);
                if (this.upperBoundInclusive) {
                    IntCompareConditionTree.lessThanOrEqual(InsnTrees.load(this.variable.variable), upperBound).emitBytecode(method, null, mainLoop.end.getLabel());
                } else {
                    IntCompareConditionTree.lessThan(InsnTrees.load(this.variable.variable), upperBound).emitBytecode(method, null, mainLoop.end.getLabel());
                }
                this.body.emitBytecode(method);
                method.node.instructions.add((AbstractInsnNode)continuePoint);
                ConstantValue constantStep = step.getConstantValue();
                if (constantStep.isConstant() && (stepSize = constantStep.asInt()) >= Short.MIN_VALUE && stepSize <= Short.MAX_VALUE) {
                    method.node.visitIincInsn(method.scopes.getVariableIndex(this.variable.variable), stepSize);
                } else {
                    InsnTrees.store(this.variable.variable, new AddInsnTree(InsnTrees.load(this.variable.variable), step, 96)).emitBytecode(method);
                }
                method.node.visitJumpInsn(167, start);
            } else {
                int stepSize;
                method.node.instructions.add((AbstractInsnNode)continuePoint);
                ConstantValue constantStep = step.getConstantValue();
                if (constantStep.isConstant() && (stepSize = constantStep.asInt()) >= Short.MIN_VALUE && stepSize <= Short.MAX_VALUE) {
                    method.node.visitIincInsn(method.scopes.getVariableIndex(this.variable.variable), stepSize);
                } else {
                    InsnTrees.store(this.variable.variable, new AddInsnTree(InsnTrees.load(this.variable.variable), step, 96)).emitBytecode(method);
                }
                if (this.upperBoundInclusive) {
                    IntCompareConditionTree.lessThanOrEqual(InsnTrees.load(this.variable.variable), upperBound).emitBytecode(method, null, mainLoop.end.getLabel());
                } else {
                    IntCompareConditionTree.lessThan(InsnTrees.load(this.variable.variable), upperBound).emitBytecode(method, null, mainLoop.end.getLabel());
                }
                this.body.emitBytecode(method);
                method.node.visitJumpInsn(167, continuePoint.getLabel());
            }
        } else {
            InsnTrees.store(this.variable.variable, upperBound).emitBytecode(method);
            if (this.upperBoundInclusive) {
                int stepSize;
                Label start = InsnTrees.label();
                method.node.visitLabel(start);
                if (this.lowerBoundInclusive) {
                    IntCompareConditionTree.greaterThanOrEqual(InsnTrees.load(this.variable.variable), lowerBound).emitBytecode(method, null, mainLoop.end.getLabel());
                } else {
                    IntCompareConditionTree.greaterThan(InsnTrees.load(this.variable.variable), lowerBound).emitBytecode(method, null, mainLoop.end.getLabel());
                }
                this.body.emitBytecode(method);
                method.node.instructions.add((AbstractInsnNode)continuePoint);
                ConstantValue constantStep = step.getConstantValue();
                if (constantStep.isConstant() && (stepSize = -constantStep.asInt()) >= Short.MIN_VALUE && stepSize <= Short.MAX_VALUE) {
                    method.node.visitIincInsn(method.scopes.getVariableIndex(this.variable.variable), stepSize);
                } else {
                    InsnTrees.store(this.variable.variable, new SubtractInsnTree(InsnTrees.load(this.variable.variable), step, 100)).emitBytecode(method);
                }
                method.node.visitJumpInsn(167, start);
            } else {
                int stepSize;
                method.node.instructions.add((AbstractInsnNode)continuePoint);
                ConstantValue constantStep = step.getConstantValue();
                if (constantStep.isConstant() && (stepSize = -constantStep.asInt()) >= Short.MIN_VALUE && stepSize <= Short.MAX_VALUE) {
                    method.node.visitIincInsn(method.scopes.getVariableIndex(this.variable.variable), stepSize);
                } else {
                    InsnTrees.store(this.variable.variable, new SubtractInsnTree(InsnTrees.load(this.variable.variable), step, 100)).emitBytecode(method);
                }
                if (this.lowerBoundInclusive) {
                    IntCompareConditionTree.greaterThanOrEqual(InsnTrees.load(this.variable.variable), lowerBound).emitBytecode(method, null, mainLoop.end.getLabel());
                } else {
                    IntCompareConditionTree.greaterThan(InsnTrees.load(this.variable.variable), lowerBound).emitBytecode(method, null, mainLoop.end.getLabel());
                }
                this.body.emitBytecode(method);
                method.node.visitJumpInsn(167, continuePoint.getLabel());
            }
        }
        method.scopes.popScope();
    }
}

