/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.scripting.bytecode.tree.instructions;

import builderb0y.scripting.bytecode.InsnTrees;
import builderb0y.scripting.bytecode.MethodCompileContext;
import builderb0y.scripting.bytecode.TypeInfo;
import builderb0y.scripting.bytecode.tree.InsnTree;
import builderb0y.scripting.bytecode.tree.InvalidOperandException;
import builderb0y.scripting.parsing.ExpressionParser;

public class NewArrayWithContentsInsnTree
implements InsnTree {
    public TypeInfo arrayType;
    public InsnTree[] elements;

    public NewArrayWithContentsInsnTree(TypeInfo arrayType, InsnTree ... elements) {
        this.arrayType = arrayType;
        this.elements = elements;
    }

    public static InsnTree create(ExpressionParser parser, TypeInfo arrayType, InsnTree ... elements) {
        if (!arrayType.isArray()) {
            throw new IllegalArgumentException("Not an array: " + String.valueOf(arrayType));
        }
        if (arrayType.componentType.isVoid()) {
            throw new InvalidOperandException("Can't allocate an array of voids");
        }
        InsnTree[] castElements = elements;
        TypeInfo componentType = arrayType.componentType;
        int length = elements.length;
        for (int index = 0; index < length; ++index) {
            InsnTree old = elements[index];
            InsnTree cast = old.cast(parser, componentType, InsnTree.CastMode.IMPLICIT_THROW, false);
            if (old == cast) continue;
            if (castElements == elements) {
                castElements = (InsnTree[])castElements.clone();
            }
            castElements[index] = cast;
        }
        return new NewArrayWithContentsInsnTree(arrayType, castElements);
    }

    @Override
    public void emitBytecode(MethodCompileContext method) {
        InsnTree[] elements = this.elements;
        int length = elements.length;
        InsnTrees.constant(length).emitBytecode(method);
        TypeInfo type = this.arrayType.componentType;
        switch (type.getSort()) {
            case BYTE: {
                method.node.visitIntInsn(188, 8);
                break;
            }
            case SHORT: {
                method.node.visitIntInsn(188, 9);
                break;
            }
            case INT: {
                method.node.visitIntInsn(188, 10);
                break;
            }
            case LONG: {
                method.node.visitIntInsn(188, 11);
                break;
            }
            case FLOAT: {
                method.node.visitIntInsn(188, 6);
                break;
            }
            case DOUBLE: {
                method.node.visitIntInsn(188, 7);
                break;
            }
            case CHAR: {
                method.node.visitIntInsn(188, 5);
                break;
            }
            case BOOLEAN: {
                method.node.visitIntInsn(188, 4);
                break;
            }
            case OBJECT: 
            case ARRAY: {
                method.node.visitTypeInsn(189, type.getInternalName());
                break;
            }
            case VOID: {
                throw new IllegalStateException("Can't allocate an array of voids");
            }
        }
        for (int index = 0; index < length; ++index) {
            method.node.visitInsn(89);
            InsnTrees.constant(index).emitBytecode(method);
            elements[index].emitBytecode(method);
            method.node.visitInsn(type.getOpcode(79));
        }
    }

    @Override
    public TypeInfo getTypeInfo() {
        return this.arrayType;
    }
}

