/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.scripting.bytecode.tree.instructions;

import builderb0y.scripting.bytecode.MethodCompileContext;
import builderb0y.scripting.bytecode.TypeInfo;
import builderb0y.scripting.bytecode.tree.InsnTree;
import builderb0y.scripting.bytecode.tree.InvalidOperandException;

public class NewArrayWithLengthInsnTree
implements InsnTree {
    public TypeInfo arrayType;
    public InsnTree length;

    public NewArrayWithLengthInsnTree(TypeInfo arrayType, InsnTree length) {
        this.arrayType = arrayType;
        this.length = length;
    }

    public static InsnTree create(TypeInfo arrayType, InsnTree length) {
        if (!length.getTypeInfo().isSingleWidthInt()) {
            throw new InvalidOperandException("Length must be single-width int");
        }
        if (!arrayType.isArray()) {
            throw new InvalidOperandException("Not an array: " + String.valueOf(arrayType));
        }
        if (arrayType.componentType.isVoid()) {
            throw new InvalidOperandException("Can't allocate an array of voids");
        }
        return new NewArrayWithLengthInsnTree(arrayType, length);
    }

    @Override
    public void emitBytecode(MethodCompileContext method) {
        this.length.emitBytecode(method);
        switch (this.arrayType.componentType.getSort()) {
            case BYTE: {
                method.node.visitIntInsn(188, 8);
                break;
            }
            case SHORT: {
                method.node.visitIntInsn(188, 9);
                break;
            }
            case INT: {
                method.node.visitIntInsn(188, 10);
                break;
            }
            case LONG: {
                method.node.visitIntInsn(188, 11);
                break;
            }
            case FLOAT: {
                method.node.visitIntInsn(188, 6);
                break;
            }
            case DOUBLE: {
                method.node.visitIntInsn(188, 7);
                break;
            }
            case CHAR: {
                method.node.visitIntInsn(188, 5);
                break;
            }
            case BOOLEAN: {
                method.node.visitIntInsn(188, 4);
                break;
            }
            case OBJECT: 
            case ARRAY: {
                method.node.visitTypeInsn(189, this.arrayType.componentType.getInternalName());
                break;
            }
            case VOID: {
                throw new IllegalStateException("Can't allocate an array of voids");
            }
        }
    }

    @Override
    public TypeInfo getTypeInfo() {
        return this.arrayType;
    }
}

