/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.scripting.bytecode.tree.instructions.binary;

import builderb0y.scripting.bytecode.InsnTrees;
import builderb0y.scripting.bytecode.TypeInfo;
import builderb0y.scripting.bytecode.tree.ConstantValue;
import builderb0y.scripting.bytecode.tree.InsnTree;
import builderb0y.scripting.bytecode.tree.InvalidOperandException;
import builderb0y.scripting.bytecode.tree.instructions.binary.BinaryInsnTree;
import builderb0y.scripting.parsing.ExpressionParser;
import builderb0y.scripting.util.TypeInfos;

public class BitwiseOrInsnTree
extends BinaryInsnTree {
    public BitwiseOrInsnTree(InsnTree left, InsnTree right, int opcode) {
        super(left, right, opcode);
    }

    public static TypeInfo validate(TypeInfo left, TypeInfo right) {
        if (left.getSort() == TypeInfo.Sort.BOOLEAN && right.getSort() == TypeInfo.Sort.BOOLEAN) {
            return TypeInfos.BOOLEAN;
        }
        if (left.isInteger() && right.isInteger()) {
            return TypeInfos.widenUntilSame(left, right);
        }
        throw new InvalidOperandException("Cannot bitwise or " + String.valueOf(left) + " and " + String.valueOf(right));
    }

    public static InsnTree create(ExpressionParser parser, InsnTree left, InsnTree right) {
        TypeInfo type = BitwiseOrInsnTree.validate(left.getTypeInfo(), right.getTypeInfo());
        ConstantValue leftConstant = left.getConstantValue();
        ConstantValue rightConstant = right.getConstantValue();
        if (leftConstant.isConstant() && rightConstant.isConstant()) {
            return switch (type.getSort()) {
                case TypeInfo.Sort.BOOLEAN -> InsnTrees.ldc(leftConstant.asBoolean() | rightConstant.asBoolean());
                case TypeInfo.Sort.BYTE -> InsnTrees.ldc((byte)(leftConstant.asByte() | rightConstant.asByte()));
                case TypeInfo.Sort.SHORT -> InsnTrees.ldc((short)(leftConstant.asShort() | rightConstant.asShort()));
                case TypeInfo.Sort.INT -> InsnTrees.ldc(leftConstant.asInt() | rightConstant.asInt());
                case TypeInfo.Sort.LONG -> InsnTrees.ldc(leftConstant.asLong() | rightConstant.asLong());
                default -> throw new AssertionError(type);
            };
        }
        left = left.cast(parser, type, InsnTree.CastMode.EXPLICIT_THROW, false);
        right = right.cast(parser, type, InsnTree.CastMode.EXPLICIT_THROW, false);
        return new BitwiseOrInsnTree(left, right, type.getOpcode(128));
    }
}

