/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.scripting.bytecode.tree.instructions.binary;

import builderb0y.bigglobe.math.BigGlobeMath;
import builderb0y.scripting.bytecode.InsnTrees;
import builderb0y.scripting.bytecode.MethodCompileContext;
import builderb0y.scripting.bytecode.TypeInfo;
import builderb0y.scripting.bytecode.tree.ConstantValue;
import builderb0y.scripting.bytecode.tree.InsnTree;
import builderb0y.scripting.bytecode.tree.InvalidOperandException;
import builderb0y.scripting.bytecode.tree.instructions.binary.BinaryInsnTree;
import builderb0y.scripting.parsing.ExpressionParser;
import builderb0y.scripting.util.TypeInfos;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.MethodNode;

public class ModuloInsnTree
extends BinaryInsnTree {
    public ModuloInsnTree(InsnTree left, InsnTree right, int opcode) {
        super(left, right, opcode);
    }

    public static TypeInfo validate(TypeInfo left, TypeInfo right) {
        if (left.isNumber() && right.isNumber()) {
            return TypeInfos.widenUntilSameInt(left, right);
        }
        throw new InvalidOperandException("Can't modulo " + String.valueOf(left) + " and " + String.valueOf(right));
    }

    public static InsnTree create(ExpressionParser parser, InsnTree left, InsnTree right) {
        TypeInfo type = ModuloInsnTree.validate(left.getTypeInfo(), right.getTypeInfo());
        ConstantValue leftConstant = left.getConstantValue();
        ConstantValue rightConstant = right.getConstantValue();
        if (leftConstant.isConstant() && rightConstant.isConstant()) {
            return switch (type.getSort()) {
                case TypeInfo.Sort.INT -> InsnTrees.ldc(BigGlobeMath.modulus(leftConstant.asInt(), rightConstant.asInt()));
                case TypeInfo.Sort.LONG -> InsnTrees.ldc(BigGlobeMath.modulus(leftConstant.asLong(), rightConstant.asLong()));
                case TypeInfo.Sort.FLOAT -> InsnTrees.ldc(BigGlobeMath.modulus(leftConstant.asFloat(), rightConstant.asFloat()));
                case TypeInfo.Sort.DOUBLE -> InsnTrees.ldc(BigGlobeMath.modulus(leftConstant.asDouble(), rightConstant.asDouble()));
                default -> throw new AssertionError(type);
            };
        }
        left = left.cast(parser, type, InsnTree.CastMode.EXPLICIT_THROW, false);
        right = right.cast(parser, type, InsnTree.CastMode.EXPLICIT_THROW, false);
        return new ModuloInsnTree(left, right, type.getOpcode(112));
    }

    @Override
    public void emitBytecode(MethodCompileContext method) {
        String methodName = "modulus";
        ConstantValue rightConstant = this.right.getConstantValue();
        if (rightConstant.isConstant()) {
            double value = rightConstant.asDouble();
            if (value > 0.0) {
                methodName = "modulus_BP";
            } else if (value < 0.0) {
                methodName = "modulus_BN";
            } else {
                this.left.emitBytecode(method);
                MethodNode methodNode = method.node;
                methodNode.visitInsn(switch (this.opcode) {
                    case 112, 114 -> 87;
                    case 113, 115 -> 88;
                    default -> throw new AssertionError(this.opcode);
                });
                this.right.emitBytecode(method);
                return;
            }
        }
        this.left.emitBytecode(method);
        this.right.emitBytecode(method);
        MethodNode methodNode = method.node;
        String string = Type.getInternalName(BigGlobeMath.class);
        methodNode.visitMethodInsn(184, string, methodName, switch (this.opcode) {
            case 112 -> "(II)I";
            case 113 -> "(JJ)J";
            case 114 -> "(FF)F";
            case 115 -> "(DD)D";
            default -> throw new AssertionError(this.opcode);
        }, false);
    }
}

