/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.scripting.bytecode.tree.instructions.binary;

import builderb0y.bigglobe.math.FastPow;
import builderb0y.scripting.bytecode.InsnTrees;
import builderb0y.scripting.bytecode.MethodCompileContext;
import builderb0y.scripting.bytecode.MethodInfo;
import builderb0y.scripting.bytecode.TypeInfo;
import builderb0y.scripting.bytecode.tree.ConstantValue;
import builderb0y.scripting.bytecode.tree.InsnTree;
import builderb0y.scripting.bytecode.tree.InvalidOperandException;
import builderb0y.scripting.bytecode.tree.instructions.binary.BinaryInsnTree;
import builderb0y.scripting.parsing.ExpressionParser;
import builderb0y.scripting.util.TypeInfos;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.MethodNode;

public abstract class PowerInsnTree
extends BinaryInsnTree {
    public final PowMode mode;

    public PowerInsnTree(InsnTree left, InsnTree right, PowMode mode) {
        super(left, right, mode.opcode);
        this.mode = mode;
    }

    public static PowMode validate(TypeInfo left, TypeInfo right) {
        PowMode mode;
        block0 : switch (TypeInfos.widenToInt(right).getSort()) {
            case INT: {
                PowMode powMode;
                switch (TypeInfos.widenToInt(left).getSort()) {
                    case INT: {
                        powMode = PowMode.IIPOW;
                        break block0;
                    }
                    case LONG: {
                        powMode = PowMode.LIPOW;
                        break block0;
                    }
                    case FLOAT: {
                        powMode = PowMode.FIPOW;
                        break block0;
                    }
                    case DOUBLE: {
                        powMode = PowMode.DIPOW;
                        break block0;
                    }
                }
                powMode = null;
                break;
            }
            case FLOAT: {
                PowMode powMode;
                if (left.isNumber()) {
                    if (left.getSort() == TypeInfo.Sort.DOUBLE) {
                        powMode = PowMode.DDPOW;
                        break;
                    }
                    powMode = PowMode.FFPOW;
                    break;
                }
                powMode = null;
                break;
            }
            case DOUBLE: {
                PowMode powMode;
                if (left.isNumber()) {
                    powMode = PowMode.DDPOW;
                    break;
                }
                powMode = null;
                break;
            }
            default: {
                PowMode powMode = mode = null;
            }
        }
        if (mode != null) {
            return mode;
        }
        throw new InvalidOperandException("Can't pow " + String.valueOf(left) + " and " + String.valueOf(right));
    }

    public static InsnTree create(ExpressionParser parser, InsnTree left, InsnTree right) {
        PowMode mode = PowerInsnTree.validate(left.getTypeInfo(), right.getTypeInfo());
        ConstantValue leftConstant = left.getConstantValue();
        ConstantValue rightConstant = right.getConstantValue();
        if (leftConstant.isConstant() && rightConstant.isConstant()) {
            return switch (mode.ordinal()) {
                default -> throw new IncompatibleClassChangeError();
                case 0 -> InsnTrees.ldc(FastPow.pow(leftConstant.asInt(), rightConstant.asInt()));
                case 1 -> InsnTrees.ldc(FastPow.pow(leftConstant.asLong(), rightConstant.asInt()));
                case 2 -> InsnTrees.ldc(FastPow.pow(leftConstant.asFloat(), rightConstant.asInt()));
                case 3 -> InsnTrees.ldc(FastPow.pow(leftConstant.asDouble(), rightConstant.asInt()));
                case 4 -> InsnTrees.ldc(FastPow.pow(leftConstant.asFloat(), rightConstant.asFloat()));
                case 5 -> InsnTrees.ldc(Math.pow(leftConstant.asDouble(), rightConstant.asDouble()));
            };
        }
        left = left.cast(parser, mode.leftType, InsnTree.CastMode.EXPLICIT_THROW, false);
        right = right.cast(parser, mode.rightType, InsnTree.CastMode.EXPLICIT_THROW, false);
        if (rightConstant.isConstant()) {
            return new VariableConstantPowerInsnTree(left, right, mode);
        }
        if (leftConstant.isConstant()) {
            return new ConstantVariablePowerInsnTree(left, right, mode);
        }
        return new VariableVariablePowerInsnTree(left, right, mode);
    }

    public void emitFallbackBytecode(MethodCompileContext method) {
        this.left.emitBytecode(method);
        this.right.emitBytecode(method);
        MethodNode methodNode = method.node;
        String string = Type.getInternalName(this.mode == PowMode.DDPOW ? Math.class : FastPow.class);
        methodNode.visitMethodInsn(184, string, "pow", switch (this.mode.ordinal()) {
            case 0 -> "(II)I";
            case 1 -> "(JI)J";
            case 2 -> "(FI)F";
            case 3 -> "(DI)D";
            case 4 -> "(FF)F";
            case 5 -> "(DD)D";
            default -> throw new AssertionError((Object)this.mode);
        }, false);
    }

    public static enum PowMode {
        IIPOW(256, TypeInfos.INT, TypeInfos.INT),
        LIPOW(257, TypeInfos.LONG, TypeInfos.INT),
        FIPOW(258, TypeInfos.FLOAT, TypeInfos.INT),
        DIPOW(259, TypeInfos.DOUBLE, TypeInfos.INT),
        FFPOW(260, TypeInfos.FLOAT, TypeInfos.FLOAT),
        DDPOW(261, TypeInfos.DOUBLE, TypeInfos.DOUBLE);

        public final int opcode;
        public final TypeInfo leftType;
        public final TypeInfo rightType;

        private PowMode(int opcode, TypeInfo leftType, TypeInfo rightType) {
            this.opcode = opcode;
            this.leftType = leftType;
            this.rightType = rightType;
        }
    }

    public static class VariableConstantPowerInsnTree
    extends PowerInsnTree {
        public VariableConstantPowerInsnTree(InsnTree left, InsnTree right, PowMode mode) {
            super(left, right, mode);
        }

        @Override
        public void emitBytecode(MethodCompileContext method) {
            double power = this.right.getConstantValue().asDouble();
            int intPower = (int)power;
            if ((double)intPower == power) {
                if (intPower == 2) {
                    this.left.emitBytecode(method);
                    method.node.visitInsn(this.left.getTypeInfo().isDoubleWidth() ? 92 : 89);
                    method.node.visitInsn(this.left.getTypeInfo().getOpcode(104));
                } else {
                    this.left.emitBytecode(method);
                    MethodNode methodNode = method.node;
                    methodNode.visitInvokeDynamicInsn("pow", switch (this.mode.ordinal()) {
                        default -> throw new IncompatibleClassChangeError();
                        case 0 -> "(I)I";
                        case 1 -> "(J)J";
                        case 2, 4 -> "(F)F";
                        case 3, 5 -> "(D)D";
                    }, new Handle(6, Type.getInternalName(FastPow.class), "getCallSite", "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;I)Ljava/lang/invoke/CallSite;", false), new Object[]{intPower});
                }
            } else {
                this.emitFallbackBytecode(method);
            }
        }
    }

    public static class ConstantVariablePowerInsnTree
    extends PowerInsnTree {
        public static final MethodInfo EXPD = MethodInfo.getMethod(Math.class, "exp");
        public static final MethodInfo EXPF = MethodInfo.getMethod(FastPow.class, "exp");

        public ConstantVariablePowerInsnTree(InsnTree left, InsnTree right, PowMode mode) {
            super(left, right, mode);
        }

        @Override
        public void emitBytecode(MethodCompileContext method) {
            double base = this.left.getConstantValue().asDouble();
            if (base > 0.0 && base < Double.POSITIVE_INFINITY) {
                double logBase = Math.log(base);
                switch (this.mode.ordinal()) {
                    case 4: {
                        this.right.emitBytecode(method);
                        InsnTrees.constant((float)logBase).emitBytecode(method);
                        method.node.visitInsn(106);
                        EXPF.emitBytecode(method);
                        break;
                    }
                    case 5: {
                        this.right.emitBytecode(method);
                        InsnTrees.constant(logBase).emitBytecode(method);
                        method.node.visitInsn(107);
                        EXPD.emitBytecode(method);
                        break;
                    }
                    default: {
                        this.emitFallbackBytecode(method);
                        break;
                    }
                }
            } else {
                this.emitFallbackBytecode(method);
            }
        }
    }

    public static class VariableVariablePowerInsnTree
    extends PowerInsnTree {
        public VariableVariablePowerInsnTree(InsnTree left, InsnTree right, PowMode mode) {
            super(left, right, mode);
        }

        @Override
        public void emitBytecode(MethodCompileContext method) {
            this.emitFallbackBytecode(method);
        }
    }
}

