/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.scripting.bytecode.tree.instructions.binary;

import builderb0y.scripting.bytecode.InsnTrees;
import builderb0y.scripting.bytecode.MethodCompileContext;
import builderb0y.scripting.bytecode.MethodInfo;
import builderb0y.scripting.bytecode.TypeInfo;
import builderb0y.scripting.bytecode.tree.ConstantValue;
import builderb0y.scripting.bytecode.tree.InsnTree;
import builderb0y.scripting.bytecode.tree.InvalidOperandException;
import builderb0y.scripting.bytecode.tree.instructions.binary.BinaryInsnTree;
import builderb0y.scripting.bytecode.tree.instructions.binary.MultiplyInsnTree;
import builderb0y.scripting.parsing.ExpressionParser;
import builderb0y.scripting.util.TypeInfos;

public class SignedRightShiftInsnTree
extends BinaryInsnTree {
    public static final MethodInfo INT_SHIFT = MethodInfo.findMethod(SignedRightShiftInsnTree.class, "shift", Integer.TYPE, Integer.TYPE, Integer.TYPE).pure();
    public static final MethodInfo LONG_SHIFT = MethodInfo.findMethod(SignedRightShiftInsnTree.class, "shift", Long.TYPE, Long.TYPE, Integer.TYPE).pure();
    public static final MethodInfo FLOAT_SHIFT = MethodInfo.findMethod(Math.class, "scalb", Float.TYPE, Float.TYPE, Integer.TYPE).pure();
    public static final MethodInfo DOUBLE_SHIFT = MethodInfo.findMethod(Math.class, "scalb", Double.TYPE, Double.TYPE, Integer.TYPE).pure();
    public static final MethodInfo NEGATE = MethodInfo.getMethod(SignedRightShiftInsnTree.class, "negate");

    public SignedRightShiftInsnTree(InsnTree left, InsnTree right, int opcode) {
        super(left, right, opcode);
    }

    public static TypeInfo validate(TypeInfo left, TypeInfo right) {
        if (left.isNumber() && right.isSingleWidthInt()) {
            return TypeInfos.widenToInt(left);
        }
        throw new InvalidOperandException("Can't signed right shift " + String.valueOf(left) + " and " + String.valueOf(right));
    }

    public static InsnTree create(ExpressionParser parser, InsnTree left, InsnTree right) {
        TypeInfo type = SignedRightShiftInsnTree.validate(left.getTypeInfo(), right.getTypeInfo());
        ConstantValue leftConstant = left.getConstantValue();
        ConstantValue rightConstant = right.getConstantValue();
        if (leftConstant.isConstant() && rightConstant.isConstant()) {
            return switch (type.getSort()) {
                case TypeInfo.Sort.INT -> InsnTrees.ldc(SignedRightShiftInsnTree.shift(leftConstant.asInt(), rightConstant.asInt()));
                case TypeInfo.Sort.LONG -> InsnTrees.ldc(SignedRightShiftInsnTree.shift(leftConstant.asLong(), rightConstant.asInt()));
                case TypeInfo.Sort.FLOAT -> InsnTrees.ldc(Math.scalb(leftConstant.asFloat(), SignedRightShiftInsnTree.negate(rightConstant.asInt())));
                case TypeInfo.Sort.DOUBLE -> InsnTrees.ldc(Math.scalb(leftConstant.asDouble(), SignedRightShiftInsnTree.negate(rightConstant.asInt())));
                default -> throw new AssertionError(type);
            };
        }
        left = left.cast(parser, type, InsnTree.CastMode.IMPLICIT_THROW, false);
        right = right.cast(parser, TypeInfos.INT, InsnTree.CastMode.IMPLICIT_THROW, false);
        return new SignedRightShiftInsnTree(left, right, switch (type.getSort()) {
            case TypeInfo.Sort.INT -> 122;
            case TypeInfo.Sort.LONG -> 123;
            case TypeInfo.Sort.FLOAT -> 266;
            case TypeInfo.Sort.DOUBLE -> 267;
            default -> throw new AssertionError(type);
        });
    }

    @Override
    public void emitBytecode(MethodCompileContext method) {
        TypeInfo leftType = this.left.getTypeInfo();
        ConstantValue rightConstant = this.right.getConstantValue();
        if (leftType.isInteger()) {
            int maxShift;
            int n = maxShift = leftType.isDoubleWidth() ? 64 : 32;
            if (rightConstant.isConstant()) {
                long shift = rightConstant.asLong();
                if (shift > 0L) {
                    if (shift >= (long)maxShift) {
                        shift = maxShift - 1;
                    }
                    this.left.emitBytecode(method);
                    InsnTrees.ldc(shift, TypeInfos.INT).emitBytecode(method);
                    method.node.visitInsn(leftType.getOpcode(122));
                } else if (shift < 0L) {
                    if (shift <= (long)(-maxShift)) {
                        this.left.emitBytecode(method);
                        method.node.visitInsn(leftType.isDoubleWidth() ? 88 : 87);
                        InsnTrees.constant(0, leftType).emitBytecode(method);
                    } else {
                        this.left.emitBytecode(method);
                        InsnTrees.ldc(-shift, TypeInfos.INT).emitBytecode(method);
                        method.node.visitInsn(leftType.getOpcode(120));
                    }
                } else {
                    this.left.emitBytecode(method);
                }
            } else {
                InsnTrees.invokeStatic(leftType.isDoubleWidth() ? LONG_SHIFT : INT_SHIFT, this.left, this.right).emitBytecode(method);
            }
        } else {
            if (rightConstant.isConstant()) {
                if (rightConstant.asInt() == 0) {
                    this.left.emitBytecode(method);
                    return;
                }
                if (leftType.isSingleWidth()) {
                    float multiplier = Math.scalb(1.0f, SignedRightShiftInsnTree.negate(rightConstant.asInt()));
                    if (multiplier != 0.0f && Float.isFinite(multiplier)) {
                        new MultiplyInsnTree(this.left, InsnTrees.ldc(multiplier), 106).emitBytecode(method);
                        return;
                    }
                } else {
                    double multiplier = Math.scalb(1.0, SignedRightShiftInsnTree.negate(rightConstant.asInt()));
                    if (multiplier != 0.0 && Double.isFinite(multiplier)) {
                        new MultiplyInsnTree(this.left, InsnTrees.ldc(multiplier), 107).emitBytecode(method);
                        return;
                    }
                }
            }
            InsnTrees.invokeStatic(leftType.isDoubleWidth() ? DOUBLE_SHIFT : FLOAT_SHIFT, this.left, InsnTrees.invokeStatic(NEGATE, this.right)).emitBytecode(method);
        }
    }

    public static int shift(int a, int b) {
        if (b >= 0) {
            return b >= 32 ? a >> 31 : a >> b;
        }
        return b <= -31 ? 0 : a << -b;
    }

    public static long shift(long a, int b) {
        if (b >= 0) {
            return b >= 64 ? a >> 63 : a >> b;
        }
        return b <= -63 ? 0L : a << -b;
    }

    public static int negate(int value) {
        if (value == Integer.MIN_VALUE) {
            return Integer.MAX_VALUE;
        }
        return -value;
    }
}

