/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.scripting.bytecode.tree.instructions.elvis;

import builderb0y.scripting.bytecode.InsnTrees;
import builderb0y.scripting.bytecode.MethodCompileContext;
import builderb0y.scripting.bytecode.TypeInfo;
import builderb0y.scripting.bytecode.tree.InsnTree;
import builderb0y.scripting.bytecode.tree.InvalidOperandException;
import builderb0y.scripting.bytecode.tree.flow.IfElseInsnTree;
import builderb0y.scripting.parsing.ExpressionParser;
import org.objectweb.asm.Label;

public class ElvisInsnTree
implements InsnTree {
    public InsnTree value;
    public InsnTree alternative;
    public TypeInfo type;

    public ElvisInsnTree(InsnTree value, InsnTree alternative, TypeInfo type) {
        this.value = value;
        this.alternative = alternative;
        this.type = type;
    }

    public static InsnTree create(ExpressionParser parser, InsnTree value, InsnTree alternative) {
        IfElseInsnTree.Operands operands = IfElseInsnTree.Operands.of(parser, value, alternative);
        return new ElvisInsnTree(operands.trueBody(), operands.falseBody(), operands.type());
    }

    @Override
    public void emitBytecode(MethodCompileContext method) {
        Label end = InsnTrees.label();
        this.value.emitBytecode(method);
        ElvisInsnTree.dupAndJumpIfNonNull(this.value.getTypeInfo(), end, method);
        method.node.visitInsn(this.value.getTypeInfo().isDoubleWidth() ? 88 : 87);
        this.alternative.emitBytecode(method);
        method.node.visitLabel(end);
    }

    public static void dupAndJumpIfNonNull(TypeInfo type, Label ifNonNull, MethodCompileContext method) {
        switch (type.getSort()) {
            case BOOLEAN: 
            case BYTE: 
            case CHAR: 
            case SHORT: 
            case INT: 
            case LONG: {
                method.node.visitJumpInsn(167, ifNonNull);
                break;
            }
            case FLOAT: {
                method.node.visitInsn(89);
                method.node.visitInsn(89);
                method.node.visitInsn(149);
                method.node.visitJumpInsn(153, ifNonNull);
                break;
            }
            case DOUBLE: {
                method.node.visitInsn(92);
                method.node.visitInsn(92);
                method.node.visitInsn(151);
                method.node.visitJumpInsn(153, ifNonNull);
                break;
            }
            case OBJECT: 
            case ARRAY: {
                method.node.visitInsn(89);
                method.node.visitJumpInsn(199, ifNonNull);
                break;
            }
            case VOID: {
                throw new InvalidOperandException("Attempt to check if void is non-null");
            }
        }
    }

    @Override
    public TypeInfo getTypeInfo() {
        return this.type;
    }

    @Override
    public InsnTree doCast(ExpressionParser parser, TypeInfo type, InsnTree.CastMode mode, boolean nullable) {
        InsnTree value = this.value.cast(parser, type, mode, nullable);
        if (value == null) {
            return null;
        }
        InsnTree alternative = this.alternative.cast(parser, type, mode, nullable);
        if (alternative == null) {
            return null;
        }
        return new ElvisInsnTree(value, alternative, type);
    }
}

