/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.scripting.bytecode.tree.instructions.invokers;

import builderb0y.autocodec.util.ArrayFactories;
import builderb0y.scripting.bytecode.InsnTrees;
import builderb0y.scripting.bytecode.MethodInfo;
import builderb0y.scripting.bytecode.TypeInfo;
import builderb0y.scripting.bytecode.tree.ConstantValue;
import builderb0y.scripting.bytecode.tree.InsnTree;
import builderb0y.scripting.bytecode.tree.instructions.invokers.BaseInvokeInsnTree;
import builderb0y.scripting.util.TypeInfos;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Arrays;
import java.util.function.IntFunction;
import org.jetbrains.annotations.Nullable;

public class StaticInvokeInsnTree
extends BaseInvokeInsnTree {
    public StaticInvokeInsnTree(MethodInfo method, InsnTree ... args) {
        super(method, args);
        StaticInvokeInsnTree.checkArguments(method.paramTypes, this.args);
    }

    public StaticInvokeInsnTree(MethodInfo method, InsnTree[] args, boolean ignored) {
        super(method, args);
    }

    public static InsnTree create(MethodInfo method, InsnTree ... args) {
        Object[] constantArgs;
        if (!method.isStatic()) {
            throw new IllegalArgumentException("Non-static method: " + String.valueOf(method));
        }
        StaticInvokeInsnTree.checkArguments(method.paramTypes, args);
        if (method.isPure() && StaticInvokeInsnTree.isPrimitive(method.returnType) && (constantArgs = StaticInvokeInsnTree.getConstantArgs(args)) != null) {
            try {
                MethodHandle handle = StaticInvokeInsnTree.getMethodHandle(method);
                return InsnTrees.ldc(handle.invokeWithArguments(constantArgs), method.returnType);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        return new StaticInvokeInsnTree(method, args, true);
    }

    public static boolean isPrimitive(TypeInfo type) {
        return type.isPrimitiveValue() || type.equals(TypeInfos.STRING);
    }

    public static Object @Nullable [] getConstantArgs(InsnTree ... args) {
        int argCount = args.length;
        Object[] constantArgs = new Object[argCount];
        for (int index = 0; index < argCount; ++index) {
            ConstantValue constant = args[index].getConstantValue();
            if (!constant.isConstant()) {
                return null;
            }
            constantArgs[index] = constant.asJavaObject();
        }
        return constantArgs;
    }

    public static MethodHandle getMethodHandle(MethodInfo method) throws NoSuchMethodException, IllegalAccessException {
        Class<?> owner = method.owner.toClass();
        MethodType methodType = StaticInvokeInsnTree.getMethodType(method);
        return MethodHandles.lookup().findStatic(owner, method.name, methodType);
    }

    public static MethodType getMethodType(MethodInfo method) {
        return MethodType.methodType(method.returnType.toClass(), (Class[])Arrays.stream(method.paramTypes).map(TypeInfo::toClass).toArray((IntFunction<A[]>)ArrayFactories.CLASS));
    }
}

