/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.scripting.bytecode.tree.instructions.update;

import builderb0y.scripting.bytecode.TypeInfo;
import builderb0y.scripting.bytecode.tree.InsnTree;
import builderb0y.scripting.bytecode.tree.instructions.update.UpdateInsnTree;
import builderb0y.scripting.util.TypeInfos;

public abstract class AbstractUpdaterInsnTree
implements UpdateInsnTree {
    public CombinedMode mode;

    public AbstractUpdaterInsnTree(CombinedMode mode) {
        this.mode = mode;
    }

    public AbstractUpdaterInsnTree(InsnTree.UpdateOrder order, boolean isAssignment) {
        this.mode = CombinedMode.of(order, isAssignment);
    }

    @Override
    public TypeInfo getTypeInfo() {
        return switch (this.mode.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0, 3 -> TypeInfos.VOID;
            case 1, 4 -> this.getPreType();
            case 2, 5 -> this.getPostType();
        };
    }

    @Override
    public abstract InsnTree asStatement();

    public static enum CombinedMode {
        VOID(InsnTree.UpdateOrder.VOID, false),
        PRE(InsnTree.UpdateOrder.PRE, false),
        POST(InsnTree.UpdateOrder.POST, false),
        VOID_ASSIGN(InsnTree.UpdateOrder.VOID, true),
        PRE_ASSIGN(InsnTree.UpdateOrder.PRE, true),
        POST_ASSIGN(InsnTree.UpdateOrder.POST, true);

        public final InsnTree.UpdateOrder order;
        public final boolean isAssignment;

        private CombinedMode(InsnTree.UpdateOrder order, boolean isAssignment) {
            this.order = order;
            this.isAssignment = isAssignment;
        }

        public static CombinedMode of(InsnTree.UpdateOrder order, boolean isAssignment) {
            return switch (order) {
                default -> throw new IncompatibleClassChangeError();
                case InsnTree.UpdateOrder.VOID -> {
                    if (isAssignment) {
                        yield VOID_ASSIGN;
                    }
                    yield VOID;
                }
                case InsnTree.UpdateOrder.PRE -> {
                    if (isAssignment) {
                        yield PRE_ASSIGN;
                    }
                    yield PRE;
                }
                case InsnTree.UpdateOrder.POST -> isAssignment ? POST_ASSIGN : POST;
            };
        }

        public boolean isVoid() {
            return this.order == InsnTree.UpdateOrder.VOID;
        }

        public CombinedMode asVoid() {
            return this.isAssignment ? VOID_ASSIGN : VOID;
        }
    }
}

