/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.scripting.bytecode.tree.instructions.update;

import builderb0y.scripting.bytecode.MethodCompileContext;
import builderb0y.scripting.bytecode.TypeInfo;
import builderb0y.scripting.bytecode.tree.InsnTree;
import builderb0y.scripting.bytecode.tree.instructions.update.AbstractObjectUpdaterInsnTree;
import builderb0y.scripting.bytecode.tree.instructions.update.AbstractUpdaterInsnTree;
import builderb0y.scripting.bytecode.tree.instructions.update.NormalObjectUpdaterInsnTree;

public class ReceiverObjectUpdaterInsnTree
extends AbstractObjectUpdaterInsnTree {
    public ReceiverObjectUpdaterInsnTree(AbstractUpdaterInsnTree.CombinedMode mode, AbstractObjectUpdaterInsnTree.ObjectUpdaterEmitters emitters) {
        super(mode, emitters);
        ReceiverObjectUpdaterInsnTree.checkUsage(mode);
    }

    public ReceiverObjectUpdaterInsnTree(InsnTree.UpdateOrder order, boolean isAssignment, AbstractObjectUpdaterInsnTree.ObjectUpdaterEmitters emitters) {
        super(order, isAssignment, emitters);
        ReceiverObjectUpdaterInsnTree.checkUsage(this.mode);
    }

    public static void checkUsage(AbstractUpdaterInsnTree.CombinedMode mode) {
        switch (mode.order) {
            case VOID: {
                break;
            }
            case PRE: {
                throw new IllegalArgumentException("Can't return receiver and pre at the same time.");
            }
            case POST: {
                throw new IllegalArgumentException("Can't return receiver and post at the same time.");
            }
        }
    }

    @Override
    public void emitBytecode(MethodCompileContext method) {
        this.emitObject(method);
        method.node.visitInsn(89);
        if (!this.mode.isAssignment) {
            method.node.visitInsn(89);
            this.emitGet(method);
        }
        this.emitUpdate(method);
        this.emitSet(method);
    }

    @Override
    public TypeInfo getTypeInfo() {
        return this.emitters.objectType();
    }

    @Override
    public InsnTree asStatement() {
        return new NormalObjectUpdaterInsnTree(this.mode.asVoid(), this.emitters);
    }
}

