/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.scripting.environments;

import builderb0y.bigglobe.math.FastMath;
import builderb0y.bigglobe.math.Interpolator;
import builderb0y.scripting.bytecode.InsnTrees;
import builderb0y.scripting.bytecode.MethodCompileContext;
import builderb0y.scripting.bytecode.MethodInfo;
import builderb0y.scripting.bytecode.TypeInfo;
import builderb0y.scripting.bytecode.tree.InsnTree;
import builderb0y.scripting.bytecode.tree.conditions.ConditionTree;
import builderb0y.scripting.bytecode.tree.instructions.ReduceInsnTree;
import builderb0y.scripting.environments.MutableScriptEnvironment;
import builderb0y.scripting.environments.ScriptEnvironment;
import builderb0y.scripting.parsing.ScriptParsingException;
import builderb0y.scripting.util.TypeInfos;
import java.util.Arrays;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Label;

public class MathScriptEnvironment
extends MutableScriptEnvironment {
    public static final MathScriptEnvironment INSTANCE = new MathScriptEnvironment();
    public static final double LN2 = Math.log(2.0);

    public MathScriptEnvironment() {
        this.addVariableConstant("pi", Math.PI).addVariableConstant("tau", Math.PI * 2).addVariableConstant("e", Math.E).addVariableConstant("goldenRatio", 1.618033988749895).addVariableConstant("goldenAngle", 2.3999632297286535).addVariableConstant("nan", Float.NaN).addVariableConstant("inf", Float.POSITIVE_INFINITY).addFunctionInvokeStatics(Math.class, "sin", "cos", "tan", "asin", "acos", "atan", "sinh", "cosh", "tanh", "toRadians", "toDegrees", "exp", "log", "sqrt", "cbrt", "floor", "ceil", "pow").addFunctionInvokeStatics(MathScriptEnvironment.class, "exp2", "log2", "asinh", "acosh", "atanh", "atan2").addFunctionRenamedInvokeStatic("ln", Math.class, "log").addFunctionInvokeStatics(FastMath.Trig.class, "fastSin", "fastCos", "fastTan", "fastAsin", "fastAcos", "fastAtan", "fastAtan2", "fastSinh", "fastCosh", "fastTanh", "fastAsinh", "fastAcosh", "fastAtanh").addFunctionInvokeStatics(FastMath.Exp.class, "fastExp", "fastExp2").addFunctionInvokeStatics(FastMath.Log.class, "fastLog", "fastLog2").addFunctionRenamedInvokeStatic("fastLn", FastMath.Log.class, "fastLog").addFunctionMultiInvokeStatics(Math.class, "abs", "copySign").addFunctionRenamedInvokeStatic("sign", Integer.class, "signum").addFunctionRenamedInvokeStatic("sign", Long.class, "signum").addFunctionRenamedMultiInvokeStatic("sign", Math.class, "signum").addFunction("mod", new MutableScriptEnvironment.FunctionHandler.Named("mod(a, b)", (parser, name, arguments) -> {
            if (arguments.length != 2) {
                return null;
            }
            return new MutableScriptEnvironment.CastResult(InsnTrees.mod(parser, arguments[0], arguments[1]), false);
        })).addFunction("isNaN", MathScriptEnvironment.createNaN(true)).addFunction("isNotNaN", MathScriptEnvironment.createNaN(false)).addFunctionInvokeStatics(Float.class, "isInfinite", "isFinite").addFunctionInvokeStatics(Double.class, "isInfinite", "isFinite").addFunction("min", MathScriptEnvironment.createReducer()).addFunction("max", MathScriptEnvironment.createReducer()).addFunctionMultiInvokeStatics(Interpolator.class, "mixLinear", "mixClamp", "mixSmooth", "mixSmoother", "unmixLinear", "unmixClamp", "unmixSmooth", "unmixSmoother", "clamp").addFunctionRenamedMultiInvokeStatic("smooth", Interpolator.class, "smoothClamp").addFunctionRenamedMultiInvokeStatic("smoother", Interpolator.class, "smootherClamp").addFunctionInvokeStatics(Float.class, "intBitsToFloat", "floatToIntBits").addFunctionInvokeStatics(Double.class, "longBitsToDouble", "doubleToLongBits").addFunctionInvokeStatics(Integer.class, "bitCount", "highestOneBit", "lowestOneBit", "numberOfLeadingZeros", "numberOfTrailingZeros", "rotateLeft", "rotateRight", "reverseBytes").addFunctionInvokeStatics(Long.class, "bitCount", "highestOneBit", "lowestOneBit", "numberOfLeadingZeros", "numberOfTrailingZeros", "rotateLeft", "rotateRight", "reverseBytes").addFunctionRenamedInvokeStatic("reverseBits", Integer.class, "reverse").addFunctionRenamedInvokeStatic("reverseBits", Long.class, "reverse");
    }

    @Override
    public MutableScriptEnvironment addFunctionInvokeStatic(String name, MethodInfo method) {
        return super.addFunctionInvokeStatic(name, method.pure());
    }

    public static MutableScriptEnvironment.FunctionHandler.Named createNaN(boolean nan) {
        return new MutableScriptEnvironment.FunctionHandler.Named(nan ? "isNaN(value)" : "isNotNan(value)", (parser, name, arguments) -> {
            if (arguments.length != 1) {
                return null;
            }
            if (arguments[0].getTypeInfo().isFloat()) {
                return new MutableScriptEnvironment.CastResult(InsnTrees.bool(new NaNConditionTree(arguments[0], nan)), false);
            }
            return null;
        });
    }

    public static MutableScriptEnvironment.FunctionHandler.Named createReducer() {
        return new MutableScriptEnvironment.FunctionHandler.Named("min/max(value1, value2, ...)", (parser, name, arguments) -> {
            if (arguments.length < 2) {
                throw new ScriptParsingException(name + "() requires at least 2 arguments", parser.input);
            }
            TypeInfo type = TypeInfos.widenUntilSameInt(Arrays.stream(arguments).map(InsnTree::getTypeInfo));
            return new MutableScriptEnvironment.CastResult(new ReduceInsnTree(new MethodInfo(-2147483639, InsnTrees.type(type.isFloat() ? MathScriptEnvironment.class : Math.class), name, type, type, type), ScriptEnvironment.castArgumentsSameType(parser, name, type, InsnTree.CastMode.IMPLICIT_THROW, arguments)), false);
        });
    }

    public static double exp2(double d) {
        return Math.exp(d * LN2);
    }

    public static double log2(double d) {
        return Math.log(d) / LN2;
    }

    public static double asinh(double x) {
        return Math.log(Math.sqrt(x * x + 1.0) + x);
    }

    public static double acosh(double x) {
        return Math.log(Math.sqrt(x * x - 1.0) + x);
    }

    public static double atanh(double x) {
        return Math.log((1.0 + x) / (1.0 - x)) * 0.5;
    }

    public static double atan2(double x, double y) {
        return Math.atan2(y, x);
    }

    public static float max(float a, float b) {
        if (a > b) {
            return a;
        }
        if (b > a) {
            return b;
        }
        if (Float.isNaN(a)) {
            return b;
        }
        if (Float.isNaN(b)) {
            return a;
        }
        return Float.floatToRawIntBits(a) > Float.floatToRawIntBits(b) ? a : b;
    }

    public static double max(double a, double b) {
        if (a > b) {
            return a;
        }
        if (b > a) {
            return b;
        }
        if (Double.isNaN(a)) {
            return b;
        }
        if (Double.isNaN(b)) {
            return a;
        }
        return Double.doubleToRawLongBits(a) > Double.doubleToRawLongBits(b) ? a : b;
    }

    public static float min(float a, float b) {
        if (a < b) {
            return a;
        }
        if (b < a) {
            return b;
        }
        if (Float.isNaN(a)) {
            return b;
        }
        if (Float.isNaN(b)) {
            return a;
        }
        return Float.floatToRawIntBits(a) < Float.floatToRawIntBits(b) ? a : b;
    }

    public static double min(double a, double b) {
        if (a < b) {
            return a;
        }
        if (b < a) {
            return b;
        }
        if (Double.isNaN(a)) {
            return b;
        }
        if (Double.isNaN(b)) {
            return a;
        }
        return Double.doubleToRawLongBits(a) < Double.doubleToRawLongBits(b) ? a : b;
    }

    public static class NaNConditionTree
    implements ConditionTree {
        public InsnTree value;
        public boolean nan;

        public NaNConditionTree(InsnTree value, boolean nan) {
            this.value = value;
            this.nan = nan;
        }

        @Override
        public void emitBytecode(MethodCompileContext method, @Nullable Label ifTrue, @Nullable Label ifFalse) {
            ConditionTree.checkLabels(ifTrue, ifFalse);
            this.value.emitBytecode(method);
            boolean doubleWidth = this.value.getTypeInfo().isDoubleWidth();
            method.node.visitInsn(doubleWidth ? 92 : 89);
            method.node.visitInsn(doubleWidth ? 151 : 149);
            if (ifTrue != null) {
                method.node.visitJumpInsn(this.nan ? 154 : 153, ifTrue);
                if (ifFalse != null) {
                    method.node.visitJumpInsn(167, ifFalse);
                }
            } else {
                method.node.visitJumpInsn(this.nan ? 153 : 154, ifFalse);
            }
        }
    }
}

