/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.scripting.environments;

import builderb0y.scripting.bytecode.DelayedMethod;
import builderb0y.scripting.bytecode.FieldInfo;
import builderb0y.scripting.bytecode.InsnTrees;
import builderb0y.scripting.bytecode.LazyVarInfo;
import builderb0y.scripting.bytecode.MethodInfo;
import builderb0y.scripting.bytecode.TypeInfo;
import builderb0y.scripting.bytecode.tree.ConstantValue;
import builderb0y.scripting.bytecode.tree.InsnTree;
import builderb0y.scripting.bytecode.tree.instructions.LoadInsnTree;
import builderb0y.scripting.environments.MutableScriptEnvironment;
import builderb0y.scripting.environments.ScriptEnvironment;
import builderb0y.scripting.parsing.ExpressionParser;
import builderb0y.scripting.parsing.ScriptParsingException;
import builderb0y.scripting.util.StackMap;
import builderb0y.scripting.util.TypeInfos;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;

public class UserScriptEnvironment
implements ScriptEnvironment {
    public ExpressionParser parser;
    public StackMap<String, PendingLocal> variables;
    public StackMap<MutableScriptEnvironment.NamedType, FieldInfo> fields;
    public StackMap<String, List<MutableScriptEnvironment.FunctionHandler>> functions;
    public StackMap<MutableScriptEnvironment.NamedType, List<MutableScriptEnvironment.MethodHandler>> methods;
    public StackMap<String, TypeInfo> types;
    public Set<DelayedMethod> delayedMethods;

    public UserScriptEnvironment() {
        this.variables = new StackMap(8);
        this.fields = new StackMap(8);
        this.functions = new StackMap(4);
        this.methods = new StackMap(4);
        this.types = new StackMap(4);
        this.delayedMethods = Collections.emptySet();
    }

    public UserScriptEnvironment(UserScriptEnvironment from) {
        this.variables = new StackMap<String, PendingLocal>(from.variables);
        this.fields = new StackMap<MutableScriptEnvironment.NamedType, FieldInfo>(from.fields);
        this.functions = new StackMap<String, List<MutableScriptEnvironment.FunctionHandler>>(from.functions);
        this.methods = new StackMap<MutableScriptEnvironment.NamedType, List<MutableScriptEnvironment.MethodHandler>>(from.methods);
        this.types = new StackMap<String, TypeInfo>(from.types);
        this.delayedMethods = new HashSet<DelayedMethod>(from.delayedMethods);
    }

    @Override
    public Stream<ScriptEnvironment.IdentifierDescriptor> listIdentifiers() {
        return Stream.of(this.variables.entrySet().stream().map(entry -> MutableScriptEnvironment.prefix("Variable", (String)entry.getKey(), (String)entry.getKey(), entry.getValue())), this.fields.entrySet().stream().map(entry -> MutableScriptEnvironment.prefix("Field", ((MutableScriptEnvironment.NamedType)entry.getKey()).name, ((MutableScriptEnvironment.NamedType)entry.getKey()).toString(), entry.getValue())), this.functions.entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream().map(handler -> MutableScriptEnvironment.prefix("Function", (String)entry.getKey(), (String)entry.getKey(), handler))), this.methods.entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream().map(handler -> MutableScriptEnvironment.prefix("Method", ((MutableScriptEnvironment.NamedType)entry.getKey()).name, ((MutableScriptEnvironment.NamedType)entry.getKey()).toString(), handler))), this.types.entrySet().stream().map(entry -> MutableScriptEnvironment.prefix("Type", (String)entry.getKey(), (String)entry.getKey(), entry.getValue()))).flatMap(Function.identity());
    }

    public void reserveVariable(String name) {
        PendingLocal old = (PendingLocal)this.variables.putIfAbsent(name, new PendingLocal(name));
        if (old != null) {
            throw new IllegalArgumentException("Variable '" + name + "' has already been declared in this scope.");
        }
    }

    public void setVariableType(String name, TypeInfo type) {
        PendingLocal variable = (PendingLocal)this.variables.get(name);
        if (variable == null) {
            throw new IllegalArgumentException("Variable '" + name + "' has not yet been declared in this scope.");
        }
        if (variable.type != null) {
            throw new IllegalStateException("Variable '" + String.valueOf(type) + "' is already of type " + String.valueOf(variable.type) + " when trying to set the type to " + String.valueOf(type));
        }
        variable.type = type;
    }

    public void reserveVariable(String name, TypeInfo type) {
        PendingLocal old = (PendingLocal)this.variables.putIfAbsent(name, new PendingLocal(name, type));
        if (old != null) {
            throw new IllegalArgumentException("Variable '" + name + "' has already been declared in this scope.");
        }
    }

    public void assignVariable(String name) {
        PendingLocal local = (PendingLocal)this.variables.get(name);
        if (local == null) {
            throw new IllegalArgumentException("Variable '" + name + "' has not yet been declared in this scope.");
        }
        if (local.assigned) {
            throw new IllegalStateException("Variable '" + name + "' has already been assigned.");
        }
        local.assigned = true;
    }

    public void reserveAndAssignVariable(String name, TypeInfo type) {
        PendingLocal newLocal = new PendingLocal(name, type);
        newLocal.assigned = true;
        PendingLocal old = (PendingLocal)this.variables.putIfAbsent(name, newLocal);
        if (old != null) {
            throw new IllegalArgumentException("Variable '" + name + "' has already been declared in this scope.");
        }
    }

    public void addFunction(String name, MutableScriptEnvironment.FunctionHandler functionHandler) {
        ((List)this.functions.computeIfAbsent(name, ignored -> new ArrayList(4))).add(functionHandler);
    }

    public void addFieldGetterAndSetter(FieldInfo field) {
        MutableScriptEnvironment.NamedType namedType = new MutableScriptEnvironment.NamedType(field.owner, field.name);
        this.fields.put(namedType, field);
        List handlers = (List)this.methods.computeIfAbsent(namedType, ignored -> new ArrayList(2));
        MethodInfo getter = new MethodInfo(1, field.owner, field.name, field.type, new TypeInfo[0]);
        MethodInfo setter = new MethodInfo(1, field.owner, field.name, TypeInfos.VOID, field.type);
        handlers.add((parser, receiver, name, mode, arguments) -> switch (arguments.length) {
            case 0 -> new MutableScriptEnvironment.CastResult(mode.makeInvoker(parser, receiver, getter, new InsnTree[0]), false);
            case 1 -> {
                InsnTree argument = arguments[0].cast(parser, field.type, InsnTree.CastMode.IMPLICIT_NULL, false);
                if (argument == null) {
                    yield null;
                }
                yield new MutableScriptEnvironment.CastResult(mode.makeInvoker(parser, receiver, setter, argument), argument != arguments[0]);
            }
            default -> null;
        });
    }

    public void addMethod(TypeInfo owner, String name, MutableScriptEnvironment.MethodHandler handler) {
        ((List)this.methods.computeIfAbsent(new MutableScriptEnvironment.NamedType(owner, name), ignored -> new ArrayList(4))).add(handler);
    }

    public void addClassFunction(String name, MutableScriptEnvironment.MethodHandler methodHandler) {
        ((List)this.methods.computeIfAbsent(new MutableScriptEnvironment.NamedType(TypeInfos.CLASS, name), ignored -> new ArrayList(4))).add(methodHandler);
    }

    public void addClassFunction(TypeInfo type, String name, MethodInfo method) {
        this.addClassFunction(name, (parser, receiver, name_, mode, arguments) -> {
            InsnTree[] castArguments;
            ConstantValue constant = receiver.getConstantValue();
            if (constant.isConstant() && constant.asJavaObject().equals(type) && (castArguments = ScriptEnvironment.castArguments(parser, method, InsnTree.CastMode.IMPLICIT_NULL, arguments)) != null) {
                return new MutableScriptEnvironment.CastResult(mode.makeInvoker(parser, method, castArguments), castArguments != arguments);
            }
            return null;
        });
    }

    public void addConstructor(TypeInfo type, MethodInfo method) {
        this.addClassFunction("new", (parser, receiver, name, mode, arguments) -> {
            InsnTree[] castArguments;
            ConstantValue constant = receiver.getConstantValue();
            if (constant.isConstant() && constant.asJavaObject().equals(type) && (castArguments = ScriptEnvironment.castArguments(parser, method, InsnTree.CastMode.IMPLICIT_NULL, arguments)) != null) {
                return new MutableScriptEnvironment.CastResult(InsnTrees.newInstance(method, castArguments), castArguments != arguments);
            }
            return null;
        });
    }

    @Override
    @Nullable
    public InsnTree getVariable(ExpressionParser parser, String name) throws ScriptParsingException {
        PendingLocal local = (PendingLocal)this.variables.get(name);
        if (local != null) {
            LazyVarInfo variable = local.variable();
            this.markVariableUsed(variable);
            return InsnTrees.load(variable);
        }
        return null;
    }

    public void markVariableUsed(LazyVarInfo variable) {
        if (!this.delayedMethods.isEmpty()) {
            for (DelayedMethod method : this.delayedMethods) {
                method.onVariableUsed(variable);
            }
        }
    }

    @Override
    @Nullable
    public InsnTree getField(ExpressionParser parser, InsnTree receiver, String name, ScriptEnvironment.GetFieldMode mode) throws ScriptParsingException {
        MutableScriptEnvironment.NamedType query = new MutableScriptEnvironment.NamedType();
        query.name = name;
        Iterator<TypeInfo> iterator = receiver.getTypeInfo().getAllAssignableTypes().iterator();
        while (iterator.hasNext()) {
            TypeInfo owner;
            query.owner = owner = iterator.next();
            FieldInfo field = (FieldInfo)this.fields.get(query);
            if (field == null) continue;
            return mode.makeField(parser, receiver, field);
        }
        return null;
    }

    @Override
    @Nullable
    public InsnTree getFunction(ExpressionParser parser, String name, InsnTree ... arguments) throws ScriptParsingException {
        List handlers = (List)this.functions.get(name);
        if (handlers != null) {
            InsnTree result = null;
            int size = handlers.size();
            for (int index = 0; index < size; ++index) {
                MutableScriptEnvironment.CastResult casted = ((MutableScriptEnvironment.FunctionHandler)handlers.get(index)).create(parser, name, arguments);
                if (casted == null) continue;
                if (!casted.requiredCasting()) {
                    return casted.tree();
                }
                if (result != null) continue;
                result = casted.tree();
            }
            return result;
        }
        return null;
    }

    @Override
    @Nullable
    public InsnTree getMethod(ExpressionParser parser, InsnTree receiver, String name, ScriptEnvironment.GetMethodMode mode, InsnTree ... arguments) throws ScriptParsingException {
        MutableScriptEnvironment.NamedType query = new MutableScriptEnvironment.NamedType();
        query.name = name;
        Iterator<TypeInfo> iterator = receiver.getTypeInfo().getAllAssignableTypes().iterator();
        while (iterator.hasNext()) {
            TypeInfo owner;
            query.owner = owner = iterator.next();
            List handlers = (List)this.methods.get(query);
            if (handlers == null) continue;
            InsnTree result = null;
            int size = handlers.size();
            for (int index = 0; index < size; ++index) {
                MutableScriptEnvironment.CastResult casted = ((MutableScriptEnvironment.MethodHandler)handlers.get(index)).create(parser, receiver, name, mode, arguments);
                if (casted == null) continue;
                if (!casted.requiredCasting()) {
                    return casted.tree();
                }
                if (result != null) continue;
                result = casted.tree();
            }
            return result;
        }
        return null;
    }

    @Override
    @Nullable
    public TypeInfo getType(ExpressionParser parser, String name) throws ScriptParsingException {
        return (TypeInfo)this.types.get(name);
    }

    public boolean hasNewVariables() {
        return this.variables.hasNewElements();
    }

    public void push() {
        this.variables.push();
        this.fields.push();
        this.functions.push();
        this.methods.push();
        this.types.push();
    }

    public void pop() {
        this.variables.pop();
        this.fields.pop();
        this.functions.pop();
        this.methods.pop();
        this.types.pop();
    }

    public boolean isFullyPopped() {
        return this.variables.sizes.isEmpty();
    }

    public int getStackSize() {
        return this.variables.sizes.size();
    }

    public static class PendingLocal {
        public String name;
        public TypeInfo type;
        public boolean assigned;

        public PendingLocal(String name) {
            this.name = name;
        }

        public PendingLocal(String name, TypeInfo type) {
            this.name = name;
            this.type = type;
        }

        public LazyVarInfo variable() {
            if (this.type == null) {
                throw new IllegalArgumentException("Variable '" + this.name + "' has not had its type inferred yet.");
            }
            if (!this.assigned) {
                throw new IllegalArgumentException("Variable '" + this.name + "' has not been assigned to yet.");
            }
            return new LazyVarInfo(this.name, this.type);
        }

        public LoadInsnTree loader() {
            return InsnTrees.load(this.variable());
        }

        public String toString() {
            return this.name + " : " + (this.type != null ? this.type.toString() : "(type not yet inferred)") + (this.assigned ? " (available)" : " (not yet assigned to)");
        }
    }
}

