/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.scripting.optimization;

import builderb0y.scripting.optimization.ConstantJumpOptimizer;
import builderb0y.scripting.optimization.DoubleJumpOptimizer;
import builderb0y.scripting.optimization.JumpToNextInstructionOptimizer;
import builderb0y.scripting.optimization.JumpToReturnOptimizer;
import builderb0y.scripting.optimization.LineNumberOptimizer;
import builderb0y.scripting.optimization.PopOptimizer;
import builderb0y.scripting.optimization.UnreachableCodeOptimizer;
import builderb0y.scripting.optimization.UnusedLocalVariableRemover;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public interface ClassOptimizer {
    public static final ClassOptimizer DEFAULT = new RepeatingOptimizer(new MultiOptimizer(LineNumberOptimizer.INSTANCE, UnreachableCodeOptimizer.INSTANCE, DoubleJumpOptimizer.INSTANCE, JumpToReturnOptimizer.INSTANCE, JumpToNextInstructionOptimizer.INSTANCE, ConstantJumpOptimizer.INSTANCE, PopOptimizer.INSTANCE, UnusedLocalVariableRemover.INSTANCE));

    public boolean optimize(ClassNode var1);

    public static class RepeatingOptimizer
    implements ClassOptimizer {
        public final ClassOptimizer optimizer;

        public RepeatingOptimizer(ClassOptimizer optimizer) {
            this.optimizer = optimizer;
        }

        @Override
        public boolean optimize(ClassNode clazz) {
            boolean changed = false;
            while (this.optimizer.optimize(clazz)) {
                changed = true;
            }
            return changed;
        }
    }

    public static class MultiOptimizer
    implements ClassOptimizer {
        public final ClassOptimizer[] optimizers;

        public MultiOptimizer(ClassOptimizer ... optimizers) {
            this.optimizers = optimizers;
        }

        @Override
        public boolean optimize(ClassNode clazz) {
            boolean changedAny = false;
            for (ClassOptimizer optimizer : this.optimizers) {
                changedAny |= optimizer.optimize(clazz);
            }
            return changedAny;
        }
    }

    public static interface MethodOptimizer
    extends ClassOptimizer {
        public boolean optimize(MethodNode var1);

        @Override
        default public boolean optimize(ClassNode clazz) {
            boolean changedAny = false;
            for (MethodNode method : clazz.methods) {
                changedAny |= this.optimize(method);
            }
            return changedAny;
        }
    }
}

