/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.scripting.parsing;

import builderb0y.scripting.parsing.ScriptParsingException;
import net.minecraft.class_5462;
import org.jetbrains.annotations.Nullable;

public class ExpressionReader {
    public final String input;
    public int cursor;
    public int line;
    public int column;

    public ExpressionReader(String input) {
        this.input = ExpressionReader.canonicalizeLineEndings(input);
        this.line = 1;
        this.column = 1;
    }

    public static String canonicalizeLineEndings(String input) {
        int length = input.length();
        StringBuilder builder = new StringBuilder(length);
        int index = 0;
        while (index < length) {
            char c = input.charAt(index);
            if (c == '\r') {
                if (++index < length && input.charAt(index) == '\n') {
                    ++index;
                }
                builder.append('\n');
                continue;
            }
            builder.append(c);
            ++index;
        }
        return builder.toString();
    }

    @Deprecated
    public char getChar(int index) {
        return index < this.input.length() ? this.input.charAt(index) : (char)'\u0000';
    }

    @Deprecated
    public boolean canRead() {
        return this.cursor < this.input.length();
    }

    public boolean canReadAfterWhitespace() throws ScriptParsingException {
        this.skipWhitespace();
        return this.canRead();
    }

    public void onCharRead(char c) {
        ++this.cursor;
        if (c == '\n') {
            ++this.line;
            this.column = 1;
        } else {
            ++this.column;
        }
    }

    public void onCharsRead(String s) {
        int length = s.length();
        for (int index = 0; index < length; ++index) {
            this.onCharRead(s.charAt(index));
        }
    }

    @Deprecated
    public char read() throws ScriptParsingException {
        if (this.canRead()) {
            char c = this.input.charAt(this.cursor);
            this.onCharRead(c);
            if (c == '\u0000') {
                throw new ScriptParsingException("Encountered NUL character in input", this);
            }
            return c;
        }
        return '\u0000';
    }

    public char readAfterWhitespace() throws ScriptParsingException {
        this.skipWhitespace();
        return this.read();
    }

    @Deprecated
    public char peek() {
        return this.canRead() ? this.input.charAt(this.cursor) : (char)'\u0000';
    }

    public char peekAfterWhitespace() throws ScriptParsingException {
        this.skipWhitespace();
        return this.peek();
    }

    @Deprecated
    public boolean skip() throws ScriptParsingException {
        return this.read() != '\u0000';
    }

    @Deprecated
    public int skip(int count) {
        count = Math.min(count, this.input.length() - this.cursor);
        for (int i = 0; i < count; ++i) {
            this.onCharRead(this.input.charAt(this.cursor));
        }
        return count;
    }

    @Deprecated
    public String read(int count) {
        int startIndex = this.cursor;
        int endIndex = Math.min(startIndex + count, this.input.length());
        String read = this.input.substring(startIndex, endIndex);
        this.onCharsRead(read);
        return read;
    }

    @Deprecated
    public boolean has(char expected) {
        if (!this.canRead()) {
            return false;
        }
        char got = this.input.charAt(this.cursor);
        if (got != expected) {
            return false;
        }
        this.onCharRead(got);
        return true;
    }

    public boolean hasAfterWhitespace(char expected) throws ScriptParsingException {
        this.skipWhitespace();
        return this.has(expected);
    }

    @Deprecated
    public boolean has(String expected) {
        if (this.input.regionMatches(this.cursor, expected, 0, expected.length())) {
            this.onCharsRead(expected);
            return true;
        }
        return false;
    }

    public boolean hasAfterWhitespace(String expected) throws ScriptParsingException {
        this.skipWhitespace();
        return this.has(expected);
    }

    @Deprecated
    public boolean has(class_5462 predicate) {
        if (!this.canRead()) {
            return false;
        }
        char got = this.input.charAt(this.cursor);
        if (!predicate.test(got)) {
            return false;
        }
        this.onCharRead(got);
        return true;
    }

    public boolean hasAfterWhitespace(class_5462 predicate) throws ScriptParsingException {
        this.skipWhitespace();
        return this.has(predicate);
    }

    @Deprecated
    public void skipWhile(class_5462 predicate) {
        char c;
        while (this.canRead() && predicate.test(c = this.input.charAt(this.cursor))) {
            this.onCharRead(c);
        }
    }

    @Deprecated
    public String readWhile(class_5462 predicate) {
        int start = this.cursor;
        this.skipWhile(predicate);
        return this.input.substring(start, this.cursor);
    }

    public void skipWhitespace() throws ScriptParsingException {
        block0: while (true) {
            int end;
            this.skipWhile(Character::isWhitespace);
            if (!this.has(';')) break;
            if (this.has('(')) {
                int depth = 1;
                while (true) {
                    if (depth <= 0) continue block0;
                    char read = this.read();
                    if (read == '(') {
                        ++depth;
                        continue;
                    }
                    if (read == ')') {
                        --depth;
                        continue;
                    }
                    if (read == '\u0000') break;
                }
                throw new ScriptParsingException("Mismatched parentheses in comment", this);
            }
            if (this.has(';')) {
                end = this.input.indexOf(";;", this.cursor);
                if (end < 0) {
                    throw new ScriptParsingException("Un-terminated multi-line comment", this);
                }
                this.skip(end + 2 - this.cursor);
                continue;
            }
            end = this.input.indexOf(10, this.cursor);
            if (end < 0) {
                end = this.input.length();
            }
            this.skip(end + 1 - this.cursor);
        }
    }

    @Deprecated
    public void expect(char expected) throws ScriptParsingException {
        if (!this.has(expected)) {
            throw new ScriptParsingException("Expected '" + expected + "'", this);
        }
    }

    public void expectAfterWhitespace(char expected) throws ScriptParsingException {
        this.skipWhitespace();
        this.expect(expected);
    }

    @Deprecated
    public void expect(String expected) throws ScriptParsingException {
        if (!this.has(expected)) {
            throw new ScriptParsingException("Expected '" + expected + "'", this);
        }
    }

    public void expectAfterWhitespace(String expected) throws ScriptParsingException {
        this.skipWhitespace();
        this.expect(expected);
    }

    @Deprecated
    public String peekOperator() {
        CursorPos old = this.getCursor();
        String operator = this.readOperator();
        this.setCursor(old);
        return operator;
    }

    public String peekOperatorAfterWhitespace() throws ScriptParsingException {
        this.skipWhitespace();
        return this.peekOperator();
    }

    @Deprecated
    public String readOperator() {
        return this.readWhile(ExpressionReader::isOperatorSymbol);
    }

    public String readOperatorAfterWhitespace() throws ScriptParsingException {
        this.skipWhitespace();
        return this.readOperator();
    }

    public static boolean isOperatorSymbol(char c) {
        return switch (c) {
            case '!', '#', '$', '%', '&', '*', '+', ',', '-', '.', '/', ':', '<', '=', '>', '?', '@', '\\', '^', '|', '~' -> true;
            default -> false;
        };
    }

    @Deprecated
    public boolean hasOperator(String operator) {
        CursorPos revert = this.getCursor();
        if (this.has(operator) && !ExpressionReader.isOperatorSymbol(this.peek())) {
            return true;
        }
        this.setCursor(revert);
        return false;
    }

    public boolean hasOperatorAfterWhitespace(String operator) throws ScriptParsingException {
        this.skipWhitespace();
        return this.hasOperator(operator);
    }

    @Deprecated
    public void expectOperator(String operator) throws ScriptParsingException {
        if (!this.hasOperator(operator)) {
            throw new ScriptParsingException("Expected '" + operator + "'", this);
        }
    }

    public void expectOperatorAfterWhitespace(String operator) throws ScriptParsingException {
        this.skipWhitespace();
        this.expectOperator(operator);
    }

    public static boolean isLetterOrUnderscore(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_';
    }

    public static boolean isLetterNumberOrUnderscore(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_';
    }

    @Deprecated
    @Nullable
    public String readIdentifierOrNull() throws ScriptParsingException {
        char c = this.peek();
        if (ExpressionReader.isLetterOrUnderscore(c)) {
            int startIndex = this.cursor;
            do {
                this.onCharRead(c);
            } while (ExpressionReader.isLetterNumberOrUnderscore(c = this.peek()));
            return this.input.substring(startIndex, this.cursor);
        }
        if (c == '`') {
            this.onCharRead('`');
            CursorPos start = this.getCursor();
            while (true) {
                if ((c = this.peek()) == '\u0000' || c == '\n') {
                    this.setCursor(start);
                    throw new ScriptParsingException("Un-terminated escaped identifier", this);
                }
                if (c == '`') break;
                this.onCharRead(c);
            }
            this.onCharRead('`');
            return this.input.substring(start.cursor, this.cursor - 1);
        }
        return null;
    }

    @Nullable
    public String readIdentifierOrNullAfterWhitespace() throws ScriptParsingException {
        this.skipWhitespace();
        return this.readIdentifierOrNull();
    }

    @Deprecated
    public String readIdentifier() throws ScriptParsingException {
        String identifier = this.readIdentifierOrNull();
        return identifier != null ? identifier : "";
    }

    public String readIdentifierAfterWhitespace() throws ScriptParsingException {
        this.skipWhitespace();
        return this.readIdentifier();
    }

    @Deprecated
    public String peekIdentifier() throws ScriptParsingException {
        CursorPos revert = this.getCursor();
        String identifier = this.readIdentifier();
        this.setCursor(revert);
        return identifier;
    }

    public String peekIdentifierAfterWhitespace() throws ScriptParsingException {
        this.skipWhitespace();
        return this.peekIdentifier();
    }

    @Deprecated
    public boolean hasIdentifier(String identifier) throws ScriptParsingException {
        char c = this.peek();
        if (ExpressionReader.isLetterOrUnderscore(c)) {
            if (this.input.regionMatches(this.cursor, identifier, 0, identifier.length()) && !ExpressionReader.isLetterNumberOrUnderscore(this.getChar(this.cursor + identifier.length()))) {
                this.onCharsRead(identifier);
                return true;
            }
        } else if (c == '`' && this.input.regionMatches(this.cursor + 1, identifier, 0, identifier.length()) && this.getChar(this.cursor + identifier.length() + 2) == '`') {
            this.onCharRead('`');
            this.onCharsRead(identifier);
            this.onCharRead('`');
            return true;
        }
        return false;
    }

    public boolean hasIdentifierAfterWhitespace(String identifier) throws ScriptParsingException {
        this.skipWhitespace();
        return this.hasIdentifier(identifier);
    }

    @Deprecated
    public String expectIdentifier() throws ScriptParsingException {
        String identifier = this.readIdentifier();
        if (!identifier.isEmpty()) {
            return identifier;
        }
        throw new ScriptParsingException("Expected identifier", this);
    }

    public String expectIdentifierAfterWhitespace() throws ScriptParsingException {
        this.skipWhitespace();
        return this.expectIdentifier();
    }

    @Deprecated
    public void expectIdentifier(String identifier) throws ScriptParsingException {
        if (!this.hasIdentifier(identifier)) {
            throw new ScriptParsingException("Expected '" + identifier + "'", this);
        }
    }

    public void expectIdentifierAfterWhitespace(String identifier) throws ScriptParsingException {
        this.skipWhitespace();
        this.expectIdentifier(identifier);
    }

    public String getSource() {
        return this.input;
    }

    public String getSourceForError() {
        int start = this.cursor;
        for (int loop = 0; loop < 10; ++loop) {
            if ((start = this.input.lastIndexOf(10, start - 1)) >= 0) continue;
            return this.input.substring(0, this.cursor);
        }
        return this.input.substring(start + 1, this.cursor);
    }

    public void unread() {
        int newCursor = this.cursor - 1;
        char c = this.input.charAt(newCursor);
        if (c == '\n') {
            throw new IllegalStateException("Cannot unread newline");
        }
        this.cursor = newCursor;
        --this.column;
    }

    public CursorPos getCursor() {
        return new CursorPos(this.cursor, this.line, this.column);
    }

    public void setCursor(CursorPos position) {
        this.cursor = position.cursor;
        this.line = position.line;
        this.column = position.column;
    }

    public record CursorPos(int cursor, int line, int column) {
    }
}

