/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.scripting.parsing;

import builderb0y.bigglobe.scripting.ScriptLogger;
import builderb0y.scripting.bytecode.ClassCompileContext;
import builderb0y.scripting.bytecode.MethodInfo;
import builderb0y.scripting.optimization.ClassOptimizer;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.fabricmc.loader.api.FabricLoader;
import org.apache.commons.io.file.PathUtils;
import org.jetbrains.annotations.Nullable;

public class ScriptClassLoader
extends ClassLoader {
    public static final MethodInfo GET_CONSTANT = MethodInfo.getMethod(ScriptClassLoader.class, "getConstant");
    public static final AtomicInteger CLASS_UNIQUIFIER = new AtomicInteger();
    public final Map<String, ClassCompileContext> loadable = new ConcurrentHashMap<String, ClassCompileContext>(8);

    public ScriptClassLoader() {
        super(ScriptClassLoader.class.getClassLoader());
    }

    public ScriptClassLoader(ClassLoader parent) {
        super(parent);
    }

    @Nullable
    public static Path initDumpDirectory(String enabledProperty, String directoryName) {
        if (Boolean.getBoolean(enabledProperty)) {
            Path classDumpDirectory = FabricLoader.getInstance().getGameDir().resolve(directoryName);
            if (Files.isDirectory(classDumpDirectory, new LinkOption[0])) {
                try {
                    PathUtils.cleanDirectory((Path)classDumpDirectory);
                }
                catch (IOException exception) {
                    ScriptLogger.LOGGER.error("An error occurred while trying to clean the previous session's script dump output.\nDumping of generated classes has been disabled to prevent ambiguity over which file is from which session.\nPlease empty the class dump directory manually when you get a chance.\n", (Throwable)exception);
                    return null;
                }
            }
            try {
                Files.createDirectory(classDumpDirectory, new FileAttribute[0]);
            }
            catch (IOException exception) {
                ScriptLogger.LOGGER.error("An error occurred while trying to create the script dump directory.\nDumping of generated classes has been disabled as there is nowhere to put them.\n", (Throwable)exception);
                return null;
            }
            return classDumpDirectory;
        }
        return null;
    }

    public Class<?> defineClass(ClassCompileContext clazz, Path dumpDirectory, String source) throws ClassNotFoundException {
        this.recursiveAddClasses(clazz, dumpDirectory, source);
        return this.loadClass(clazz.info.getClassName());
    }

    public void recursiveAddClasses(ClassCompileContext clazz, Path dumpDirectory, String source) {
        ClassOptimizer.DEFAULT.optimize(clazz.node);
        if (dumpDirectory != null) {
            try {
                String baseName = clazz.info.getSimpleClassName();
                if (source != null) {
                    Files.writeString(dumpDirectory.resolve(baseName + "-src.txt"), (CharSequence)source, StandardCharsets.UTF_8, StandardOpenOption.CREATE_NEW);
                }
                Files.writeString(dumpDirectory.resolve(baseName + "-asm.txt"), (CharSequence)clazz.dump(), StandardCharsets.UTF_8, StandardOpenOption.CREATE_NEW);
                Files.write(dumpDirectory.resolve(baseName + ".class"), clazz.toByteArray(), StandardOpenOption.CREATE_NEW);
            }
            catch (IOException exception) {
                ScriptLogger.LOGGER.error("", (Throwable)exception);
            }
        }
        this.loadable.put(clazz.info.getClassName(), clazz);
        for (ClassCompileContext innerClass : clazz.innerClasses) {
            this.recursiveAddClasses(innerClass, dumpDirectory, null);
        }
    }

    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        ClassCompileContext clazz = this.loadable.get(name.replace('/', '.'));
        if (clazz != null) {
            byte[] bytes = clazz.toByteArray();
            return this.defineClass(clazz.info.getClassName(), bytes, 0, bytes.length);
        }
        throw new ClassNotFoundException(name);
    }

    public static Object getConstant(MethodHandles.Lookup lookup, String name, Class<?> type, int which) {
        ClassLoader classLoader = lookup.lookupClass().getClassLoader();
        if (classLoader instanceof ScriptClassLoader) {
            ScriptClassLoader loader = (ScriptClassLoader)classLoader;
            ClassCompileContext context = loader.loadable.get(lookup.lookupClass().getName());
            if (context != null) {
                if (which >= 0 && which < context.constants.size()) {
                    return type.cast(context.constants.get(which));
                }
                throw new IndexOutOfBoundsException("Invalid constant with index " + which);
            }
            throw new IllegalStateException("No context found for " + String.valueOf(lookup.lookupClass()));
        }
        throw new IllegalCallerException("getConstant() can only be called by script classes");
    }
}

