/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.scripting.parsing;

import builderb0y.bigglobe.chunkgen.scripted.SurfaceScript;
import builderb0y.bigglobe.columns.scripted.ScriptedColumn;
import builderb0y.scripting.bytecode.DelayedMethod;
import builderb0y.scripting.bytecode.InsnTrees;
import builderb0y.scripting.bytecode.LazyVarInfo;
import builderb0y.scripting.bytecode.TypeInfo;
import builderb0y.scripting.bytecode.tree.InsnTree;
import builderb0y.scripting.bytecode.tree.instructions.ReturnInsnTree;
import builderb0y.scripting.bytecode.tree.instructions.binary.DivideInsnTree;
import builderb0y.scripting.bytecode.tree.instructions.invokers.AfterNullableInvokeInsnTree;
import builderb0y.scripting.bytecode.tree.instructions.invokers.AfterNullableReceiverInvokeInsnTree;
import builderb0y.scripting.bytecode.tree.instructions.invokers.AfterReceiverInvokeInsnTree;
import builderb0y.scripting.bytecode.tree.instructions.invokers.NormalInvokeInsnTree;
import builderb0y.scripting.environments.MutableScriptEnvironment;
import builderb0y.scripting.environments.ScriptEnvironment;
import builderb0y.scripting.parsing.ExpressionParser;
import builderb0y.scripting.parsing.InnerMethodExpressionParser;
import builderb0y.scripting.parsing.ScriptParsingException;
import builderb0y.scripting.parsing.VariableCapturer;
import builderb0y.scripting.parsing.special.UserParameterList;
import com.google.common.collect.ObjectArrays;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class UserMethodDefiner
extends VariableCapturer {
    public final String methodName;
    public final TypeInfo returnType;
    public UserParameterList userParameters;
    public DelayedMethod newMethod;

    public UserMethodDefiner(ExpressionParser parser, String methodName, TypeInfo returnType) {
        super(parser);
        this.methodName = methodName;
        this.returnType = returnType;
    }

    public void parse() throws ScriptParsingException {
        this.parseUserParameters();
        this.addBuiltinParameters();
        this.addCapturedParameters();
        this.newMethod = new DelayedMethod(this);
        this.parser.delayedMethods.add(this.newMethod);
        this.makeMethodCallable();
        this.parseMethodBody();
    }

    public void parseUserParameters() throws ScriptParsingException {
        this.userParameters = UserParameterList.parse(this.parser);
    }

    public Stream<LazyVarInfo> streamUserParameters() {
        return Arrays.stream(this.userParameters.parameters()).map(parameter -> new LazyVarInfo(parameter.name(), parameter.type()));
    }

    public abstract void makeMethodCallable();

    public ExpressionParser createChildParser() {
        return new InnerMethodExpressionParser(this.parser, this.returnType);
    }

    public void parseMethodBody() throws ScriptParsingException {
        this.parser.environment.user().push();
        ExpressionParser newParser = this.createChildParser();
        this.newMethod.configureEnvironment(newParser);
        InsnTree body = newParser.nextScript();
        if (!newParser.input.hasAfterWhitespace(')')) {
            throw new ScriptParsingException("Unexpected trailing character: " + newParser.input.peekAfterWhitespace(), newParser.input);
        }
        if (!body.jumpsUnconditionally()) {
            body = newParser.createReturn(body);
        }
        this.parser.environment.user().pop();
        this.newMethod.body = body;
    }

    public static class DerivativeMethodDefiner
    extends UserMethodDefiner {
        public DerivativeMethodDefiner(ExpressionParser parser, String methodName) {
            super(parser, methodName, null);
        }

        public InsnTree createDerivative(TypeInfo columnType, boolean z) throws ScriptParsingException {
            InsnTree adjacentInvoker;
            InsnTree normalInvoker;
            boolean wasEmpty = this.parser.delayedMethods.isEmpty();
            this.parse();
            if (wasEmpty) {
                this.parser.finishDelayedMethods();
            }
            LazyVarInfo mainColumn = new LazyVarInfo("mainColumn", columnType);
            LazyVarInfo adjacentColumnX = new LazyVarInfo("adjacentColumnX", columnType);
            LazyVarInfo adjacentColumnZ = new LazyVarInfo("adjacentColumnZ", columnType);
            LazyVarInfo adjacentColumnXZ = new LazyVarInfo("adjacentColumnXZ", columnType);
            InsnTree[] normalArgs = (InsnTree[])this.newMethod.streamCapturedArgs().map(InsnTrees::load).toArray((IntFunction<A[]>)InsnTree.ARRAY_FACTORY);
            InsnTree[] adjacentArgs = (InsnTree[])this.newMethod.streamCapturedArgs().map(variable -> switch (variable.name) {
                case "mainColumn" -> {
                    if (z) {
                        yield adjacentColumnZ;
                    }
                    yield adjacentColumnX;
                }
                case "adjacentColumnX" -> {
                    if (z) {
                        yield adjacentColumnXZ;
                    }
                    yield mainColumn;
                }
                case "adjacentColumnZ" -> {
                    if (z) {
                        yield mainColumn;
                    }
                    yield adjacentColumnXZ;
                }
                case "adjacentColumnXZ" -> {
                    if (z) {
                        yield adjacentColumnX;
                    }
                    yield adjacentColumnZ;
                }
                default -> variable;
            }).map(InsnTrees::load).toArray((IntFunction<A[]>)InsnTree.ARRAY_FACTORY);
            if (this.newMethod.methodInfo.isStatic()) {
                normalInvoker = InsnTrees.invokeStatic(this.newMethod.methodInfo, normalArgs);
                adjacentInvoker = InsnTrees.invokeStatic(this.newMethod.methodInfo, adjacentArgs);
            } else {
                normalInvoker = InsnTrees.invokeInstance(InsnTrees.load("this", this.parser.clazz.info), this.newMethod.methodInfo, normalArgs);
                adjacentInvoker = InsnTrees.invokeInstance(InsnTrees.load("this", this.parser.clazz.info), this.newMethod.methodInfo, adjacentArgs);
            }
            return DivideInsnTree.create(this.parser, InsnTrees.sub(this.parser, adjacentInvoker, normalInvoker), InsnTrees.sub(this.parser, z ? ScriptedColumn.INFO.z(InsnTrees.load(adjacentColumnZ)) : ScriptedColumn.INFO.x(InsnTrees.load(adjacentColumnX)), z ? ScriptedColumn.INFO.z(InsnTrees.load(mainColumn)) : ScriptedColumn.INFO.x(InsnTrees.load(mainColumn))).cast(this.parser, this.newMethod.returnType, InsnTree.CastMode.IMPLICIT_THROW, false));
        }

        @Override
        public void parseUserParameters() throws ScriptParsingException {
            this.userParameters = new UserParameterList(new UserParameterList.UserParameter[0]);
        }

        @Override
        public void makeMethodCallable() {
        }

        @Override
        public ExpressionParser createChildParser() {
            SurfaceScript.AnyNumericTypeExpressionParser newParser = new SurfaceScript.AnyNumericTypeExpressionParser(this.parser);
            newParser.environment.mutable().functions.put("return", Collections.singletonList(new MutableScriptEnvironment.FunctionHandler.Named("invalid (return not supported inside derivative block)", (parser1, name1, arguments) -> {
                throw new ScriptParsingException("For technical reasons, you cannot return from inside a derivative block", parser1.input);
            })));
            List<MutableScriptEnvironment.FunctionHandler.Named> higherOrderDerivatives = Collections.singletonList(new MutableScriptEnvironment.FunctionHandler.Named("invalid (higher order derivatives not supported)", (parser1, name1, arguments) -> {
                throw new ScriptParsingException("Higher order derivatives are not supported.", parser1.input);
            }));
            newParser.environment.mutable().functions.put("dx", higherOrderDerivatives);
            newParser.environment.mutable().functions.put("dz", higherOrderDerivatives);
            return newParser;
        }

        @Override
        public void parseMethodBody() throws ScriptParsingException {
            super.parseMethodBody();
            this.newMethod.returnType = ((ReturnInsnTree)this.newMethod.body).value.getTypeInfo();
        }
    }

    public static class UserExtensionMethodDefiner
    extends UserMethodDefiner {
        public final TypeInfo typeBeingExtended;

        public UserExtensionMethodDefiner(ExpressionParser parser, String methodName, TypeInfo returnType, TypeInfo typeBeingExtended) {
            super(parser, methodName, returnType);
            this.typeBeingExtended = typeBeingExtended;
        }

        @Override
        public Stream<LazyVarInfo> streamUserParameters() {
            return Stream.concat(Stream.of(new LazyVarInfo("this", this.typeBeingExtended)), super.streamUserParameters());
        }

        @Override
        public void makeMethodCallable() {
            DelayedMethod method = this.newMethod;
            TypeInfo callerInfo = this.parser.clazz.info;
            TypeInfo typeBeingExtended = this.typeBeingExtended;
            this.parser.environment.user().addMethod(typeBeingExtended, this.methodName, new MutableScriptEnvironment.MethodHandler.Named("User extension method: " + this.returnType.getClassName() + " " + this.typeBeingExtended.getClassName() + "." + this.methodName + Arrays.stream(this.userParameters.parameters()).map(UserParameterList.UserParameter::toString).collect(Collectors.joining(", ", "(", ")")), this.parser.method.info.isStatic() ? (parser, receiver, name, mode, arguments) -> {
                InsnTree[] castArguments = ScriptEnvironment.castArguments(parser, name, (TypeInfo[])Arrays.stream(this.userParameters.parameters()).map(UserParameterList.UserParameter::type).toArray((IntFunction<A[]>)TypeInfo.ARRAY_FACTORY), InsnTree.CastMode.IMPLICIT_NULL, arguments);
                if (castArguments == null) {
                    return null;
                }
                if (method.body != null) {
                    method.streamCapturedArgs().forEach(parser.environment.user()::markVariableUsed);
                }
                Supplier<InsnTree> supplier = () -> {
                    InsnTree[] concatArguments = UserExtensionMethodDefiner.concat(receiver, castArguments, (InsnTree[])method.streamCapturedArgs().map(InsnTrees::load).toArray((IntFunction<A[]>)InsnTree.ARRAY_FACTORY));
                    return mode.makeInvoker(parser, method.methodInfo, concatArguments);
                };
                return new MutableScriptEnvironment.CastResult(new DelayedMethod.LazyInvokeInsnTree(supplier, switch (mode) {
                    default -> throw new IncompatibleClassChangeError();
                    case ScriptEnvironment.GetMethodMode.NORMAL, ScriptEnvironment.GetMethodMode.NULLABLE -> method.returnType;
                    case ScriptEnvironment.GetMethodMode.RECEIVER, ScriptEnvironment.GetMethodMode.NULLABLE_RECEIVER -> typeBeingExtended;
                }), castArguments != arguments);
            } : (parser, receiver, name, mode, arguments) -> {
                InsnTree[] castArguments = ScriptEnvironment.castArguments(parser, name, (TypeInfo[])Arrays.stream(this.userParameters.parameters()).map(UserParameterList.UserParameter::type).toArray((IntFunction<A[]>)TypeInfo.ARRAY_FACTORY), InsnTree.CastMode.IMPLICIT_NULL, arguments);
                if (castArguments == null) {
                    return null;
                }
                if (method.body != null) {
                    method.streamCapturedArgs().forEach(parser.environment.user()::markVariableUsed);
                }
                Supplier<InsnTree> supplier = () -> {
                    InsnTree[] concatArguments = UserExtensionMethodDefiner.concat(receiver, castArguments, (InsnTree[])method.streamCapturedArgs().map(InsnTrees::load).toArray((IntFunction<A[]>)InsnTree.ARRAY_FACTORY));
                    return switch (mode) {
                        default -> throw new IncompatibleClassChangeError();
                        case ScriptEnvironment.GetMethodMode.NORMAL -> new NormalInvokeInsnTree(InsnTrees.load("this", callerInfo), method.methodInfo, concatArguments);
                        case ScriptEnvironment.GetMethodMode.NULLABLE -> new AfterNullableInvokeInsnTree(method.methodInfo, new LazyVarInfo("this", callerInfo), concatArguments);
                        case ScriptEnvironment.GetMethodMode.RECEIVER -> new AfterReceiverInvokeInsnTree(InsnTrees.load("this", callerInfo), method.methodInfo, concatArguments);
                        case ScriptEnvironment.GetMethodMode.NULLABLE_RECEIVER -> new AfterNullableReceiverInvokeInsnTree(method.methodInfo, new LazyVarInfo("this", callerInfo), concatArguments);
                    };
                };
                return new MutableScriptEnvironment.CastResult(new DelayedMethod.LazyInvokeInsnTree(supplier, switch (mode) {
                    default -> throw new IncompatibleClassChangeError();
                    case ScriptEnvironment.GetMethodMode.NORMAL, ScriptEnvironment.GetMethodMode.NULLABLE -> method.returnType;
                    case ScriptEnvironment.GetMethodMode.RECEIVER, ScriptEnvironment.GetMethodMode.NULLABLE_RECEIVER -> typeBeingExtended;
                }), castArguments != arguments);
            }));
        }

        public static InsnTree[] concat(InsnTree receiver, InsnTree[] userParameters, InsnTree[] implicitParameters) {
            InsnTree[] result = new InsnTree[1 + userParameters.length + implicitParameters.length];
            result[0] = receiver;
            System.arraycopy(userParameters, 0, result, 1, userParameters.length);
            System.arraycopy(implicitParameters, 0, result, userParameters.length + 1, implicitParameters.length);
            return result;
        }
    }

    public static class UserFunctionDefiner
    extends UserMethodDefiner {
        public UserFunctionDefiner(ExpressionParser parser, String methodName, TypeInfo returnType) {
            super(parser, methodName, returnType);
        }

        @Override
        public void makeMethodCallable() {
            DelayedMethod method = this.newMethod;
            TypeInfo callerInfo = this.parser.clazz.info;
            this.parser.environment.user().addFunction(this.methodName, new MutableScriptEnvironment.FunctionHandler.Named("User function: " + this.returnType.getClassName() + " " + this.methodName + Arrays.stream(this.userParameters.parameters()).map(UserParameterList.UserParameter::toString).collect(Collectors.joining(", ", "(", ")")), this.parser.method.info.isStatic() ? (parser, name, arguments) -> {
                InsnTree[] castArguments = ScriptEnvironment.castArguments(parser, name, (TypeInfo[])Arrays.stream(this.userParameters.parameters()).map(UserParameterList.UserParameter::type).toArray((IntFunction<A[]>)TypeInfo.ARRAY_FACTORY), InsnTree.CastMode.IMPLICIT_NULL, arguments);
                if (castArguments == null) {
                    return null;
                }
                if (method.body != null) {
                    method.streamCapturedArgs().forEach(parser.environment.user()::markVariableUsed);
                }
                return new MutableScriptEnvironment.CastResult(new DelayedMethod.LazyInvokeInsnTree(() -> {
                    InsnTree[] concatArguments = (InsnTree[])ObjectArrays.concat((Object[])castArguments, (Object[])((InsnTree[])method.streamCapturedArgs().map(InsnTrees::load).toArray((IntFunction<A[]>)InsnTree.ARRAY_FACTORY)), InsnTree.class);
                    return InsnTrees.invokeStatic(method.methodInfo, concatArguments);
                }, method.returnType), castArguments != arguments);
            } : (parser, name, arguments) -> {
                InsnTree[] castArguments = ScriptEnvironment.castArguments(parser, name, (TypeInfo[])Arrays.stream(this.userParameters.parameters()).map(UserParameterList.UserParameter::type).toArray((IntFunction<A[]>)TypeInfo.ARRAY_FACTORY), InsnTree.CastMode.IMPLICIT_NULL, arguments);
                if (castArguments == null) {
                    return null;
                }
                if (method.body != null) {
                    method.streamCapturedArgs().forEach(parser.environment.user()::markVariableUsed);
                }
                return new MutableScriptEnvironment.CastResult(new DelayedMethod.LazyInvokeInsnTree(() -> {
                    InsnTree[] concatArguments = (InsnTree[])ObjectArrays.concat((Object[])castArguments, (Object[])((InsnTree[])method.streamCapturedArgs().map(InsnTrees::load).toArray((IntFunction<A[]>)InsnTree.ARRAY_FACTORY)), InsnTree.class);
                    return InsnTrees.invokeInstance(InsnTrees.load("this", callerInfo), method.methodInfo, concatArguments);
                }, method.returnType), castArguments != arguments);
            }));
        }
    }
}

