/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.scripting.parsing.special;

import builderb0y.scripting.bytecode.TypeInfo;
import builderb0y.scripting.parsing.ExpressionParser;
import builderb0y.scripting.parsing.ScriptParsingException;
import builderb0y.scripting.parsing.special.MultiParameterSyntax;
import java.util.ArrayList;

public record UserParameterList(UserParameter[] parameters) {
    public static UserParameterList parse(ExpressionParser parser) throws ScriptParsingException {
        if (parser.input.hasOperatorAfterWhitespace(":")) {
            return new UserParameterList(new UserParameter[0]);
        }
        ArrayList<UserParameter> parameters = new ArrayList<UserParameter>(4);
        do {
            String typeName;
            TypeInfo type;
            if ((type = parser.environment.getType(parser, typeName = parser.input.expectIdentifierAfterWhitespace())) == null) {
                throw new ScriptParsingException("Unknown type: " + typeName, parser.input);
            }
            if (type.getSort() == TypeInfo.Sort.VOID) {
                throw new ScriptParsingException("void-typed parameters are not allowed.", parser.input);
            }
            if (parser.input.hasOperatorAfterWhitespace("*")) {
                for (String name : MultiParameterSyntax.parse(parser).names()) {
                    parameters.add(new UserParameter(type, name));
                }
            } else {
                String name = parser.verifyName(parser.input.expectIdentifierAfterWhitespace(), "parameter");
                parameters.add(new UserParameter(type, name));
            }
        } while (parser.input.hasOperatorAfterWhitespace(","));
        if (!parser.input.hasOperatorAfterWhitespace(":")) {
            throw new ScriptParsingException("Expected ',' or ':'", parser.input);
        }
        return new UserParameterList(parameters.toArray(new UserParameter[parameters.size()]));
    }

    public record UserParameter(TypeInfo type, String name) {
        @Override
        public String toString() {
            return this.type.getClassName() + " " + this.name;
        }
    }
}

