/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.scripting.util;

import builderb0y.scripting.bytecode.InsnTrees;
import builderb0y.scripting.bytecode.MethodInfo;
import builderb0y.scripting.bytecode.TypeInfo;
import builderb0y.scripting.bytecode.tree.InsnTree;
import builderb0y.scripting.bytecode.tree.conditions.DoubleCompareConditionTree;
import builderb0y.scripting.bytecode.tree.conditions.FloatCompareConditionTree;
import builderb0y.scripting.bytecode.tree.conditions.IntCompareConditionTree;
import builderb0y.scripting.bytecode.tree.conditions.LongCompareConditionTree;
import builderb0y.scripting.parsing.ExpressionParser;
import builderb0y.scripting.util.TypeInfos;
import builderb0y.scripting.util.TypeMerger;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;

public class ArrayExtensions {
    public static final Set<TypeInfo> ARRAY_CLASSES = Set.of(TypeInfos.OBJECT, TypeInfo.of(Cloneable.class), TypeInfo.of(Serializable.class));
    public static final MethodInfo BYTE_ARRAY_EQUALS = MethodInfo.findMethod(Arrays.class, "equals", Boolean.TYPE, byte[].class, byte[].class).pure();
    public static final MethodInfo SHORT_ARRAY_EQUALS = MethodInfo.findMethod(Arrays.class, "equals", Boolean.TYPE, short[].class, short[].class).pure();
    public static final MethodInfo INT_ARRAY_EQUALS = MethodInfo.findMethod(Arrays.class, "equals", Boolean.TYPE, int[].class, int[].class).pure();
    public static final MethodInfo LONG_ARRAY_EQUALS = MethodInfo.findMethod(Arrays.class, "equals", Boolean.TYPE, long[].class, long[].class).pure();
    public static final MethodInfo FLOAT_ARRAY_EQUALS = MethodInfo.findMethod(Arrays.class, "equals", Boolean.TYPE, float[].class, float[].class).pure();
    public static final MethodInfo DOUBLE_ARRAY_EQUALS = MethodInfo.findMethod(Arrays.class, "equals", Boolean.TYPE, double[].class, double[].class).pure();
    public static final MethodInfo CHAR_ARRAY_EQUALS = MethodInfo.findMethod(Arrays.class, "equals", Boolean.TYPE, char[].class, char[].class).pure();
    public static final MethodInfo BOOLEAN_ARRAY_EQUALS = MethodInfo.findMethod(Arrays.class, "equals", Boolean.TYPE, boolean[].class, boolean[].class).pure();
    public static final MethodInfo OBJECT_EQUALS = MethodInfo.findMethod(ArrayExtensions.class, "equals", Boolean.TYPE, Object.class, Object.class).pure();
    public static final MethodInfo OBJECTS_EQUALS = MethodInfo.findMethod(Objects.class, "equals", Boolean.TYPE, Object.class, Object.class).pure();
    public static final MethodInfo OBJECT_ARRAY_EQUALS = MethodInfo.findMethod(ArrayExtensions.class, "objectArrayEquals", Boolean.TYPE, Object[].class, Object[].class).pure();
    public static final MethodInfo OBJECT_ARRAYS_EQUALS = MethodInfo.findMethod(Arrays.class, "equals", Boolean.TYPE, Object[].class, Object[].class).pure();
    public static final MethodInfo BYTE_HASH_CODE = MethodInfo.findMethod(Byte.class, "hashCode", Integer.TYPE, Byte.TYPE).pure();
    public static final MethodInfo SHORT_HASH_CODE = MethodInfo.findMethod(Short.class, "hashCode", Integer.TYPE, Short.TYPE).pure();
    public static final MethodInfo INT_HASH_CODE = MethodInfo.findMethod(Integer.class, "hashCode", Integer.TYPE, Integer.TYPE).pure();
    public static final MethodInfo LONG_HASH_CODE = MethodInfo.findMethod(Long.class, "hashCode", Integer.TYPE, Long.TYPE).pure();
    public static final MethodInfo FLOAT_HASH_CODE = MethodInfo.findMethod(Float.class, "hashCode", Integer.TYPE, Float.TYPE).pure();
    public static final MethodInfo DOUBLE_HASH_CODE = MethodInfo.findMethod(Double.class, "hashCode", Integer.TYPE, Double.TYPE).pure();
    public static final MethodInfo CHAR_HASH_CODE = MethodInfo.findMethod(Character.class, "hashCode", Integer.TYPE, Character.TYPE).pure();
    public static final MethodInfo BOOLEAN_HASH_CODE = MethodInfo.findMethod(Boolean.class, "hashCode", Integer.TYPE, Boolean.TYPE).pure();
    public static final MethodInfo OBJECT_HASH_CODE = MethodInfo.findMethod(ArrayExtensions.class, "hashCode", Integer.TYPE, Object.class).pure();
    public static final MethodInfo OBJECTS_HASH_CODE = MethodInfo.findMethod(Objects.class, "hashCode", Integer.TYPE, Object.class).pure();
    public static final MethodInfo BYTE_ARRAY_HASH_CODE = MethodInfo.findMethod(Arrays.class, "hashCode", Integer.TYPE, byte[].class).pure();
    public static final MethodInfo SHORT_ARRAY_HASH_CODE = MethodInfo.findMethod(Arrays.class, "hashCode", Integer.TYPE, short[].class).pure();
    public static final MethodInfo INT_ARRAY_HASH_CODE = MethodInfo.findMethod(Arrays.class, "hashCode", Integer.TYPE, int[].class).pure();
    public static final MethodInfo LONG_ARRAY_HASH_CODE = MethodInfo.findMethod(Arrays.class, "hashCode", Integer.TYPE, long[].class).pure();
    public static final MethodInfo FLOAT_ARRAY_HASH_CODE = MethodInfo.findMethod(Arrays.class, "hashCode", Integer.TYPE, float[].class).pure();
    public static final MethodInfo DOUBLE_ARRAY_HASH_CODE = MethodInfo.findMethod(Arrays.class, "hashCode", Integer.TYPE, double[].class).pure();
    public static final MethodInfo CHAR_ARRAY_HASH_CODE = MethodInfo.findMethod(Arrays.class, "hashCode", Integer.TYPE, char[].class).pure();
    public static final MethodInfo BOOLEAN_ARRAY_HASH_CODE = MethodInfo.findMethod(Arrays.class, "hashCode", Integer.TYPE, boolean[].class).pure();
    public static final MethodInfo OBJECT_ARRAY_HASH_CODE = MethodInfo.findMethod(ArrayExtensions.class, "objectArrayHashCode", Integer.TYPE, Object[].class).pure();
    public static final MethodInfo OBJECT_ARRAYS_HASH_CODE = MethodInfo.findMethod(Arrays.class, "hashCode", Integer.TYPE, Object[].class).pure();

    public static InsnTree computeEquals(ExpressionParser parser, InsnTree left, InsnTree right) {
        TypeInfo leftType = left.getTypeInfo();
        TypeInfo rightType = right.getTypeInfo();
        TypeInfo commonType = TypeMerger.computeMostSpecificType(leftType, rightType);
        left = left.cast(parser, commonType, InsnTree.CastMode.IMPLICIT_THROW, false);
        right = right.cast(parser, commonType, InsnTree.CastMode.IMPLICIT_THROW, false);
        return switch (commonType.getSort()) {
            default -> throw new IncompatibleClassChangeError();
            case TypeInfo.Sort.VOID -> throw new IllegalArgumentException("Equals on void");
            case TypeInfo.Sort.BYTE -> InsnTrees.bool(IntCompareConditionTree.equal(left, right));
            case TypeInfo.Sort.SHORT -> InsnTrees.bool(IntCompareConditionTree.equal(left, right));
            case TypeInfo.Sort.INT -> InsnTrees.bool(IntCompareConditionTree.equal(left, right));
            case TypeInfo.Sort.LONG -> InsnTrees.bool(LongCompareConditionTree.equal(left, right));
            case TypeInfo.Sort.FLOAT -> InsnTrees.bool(FloatCompareConditionTree.equal(left, right));
            case TypeInfo.Sort.DOUBLE -> InsnTrees.bool(DoubleCompareConditionTree.equal(left, right));
            case TypeInfo.Sort.CHAR -> InsnTrees.bool(IntCompareConditionTree.equal(left, right));
            case TypeInfo.Sort.BOOLEAN -> InsnTrees.bool(IntCompareConditionTree.equal(left, right));
            case TypeInfo.Sort.OBJECT -> {
                if (ARRAY_CLASSES.contains(commonType)) {
                    yield InsnTrees.invokeStatic(OBJECT_EQUALS, left, right);
                }
                yield InsnTrees.invokeStatic(OBJECTS_EQUALS, left, right);
            }
            case TypeInfo.Sort.ARRAY -> {
                TypeInfo componentType = commonType.componentType;
                switch (componentType.getSort()) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case VOID: {
                        throw new IllegalArgumentException("Array of voids");
                    }
                    case BYTE: {
                        yield InsnTrees.invokeStatic(BYTE_ARRAY_EQUALS, left, right);
                    }
                    case SHORT: {
                        yield InsnTrees.invokeStatic(SHORT_ARRAY_EQUALS, left, right);
                    }
                    case INT: {
                        yield InsnTrees.invokeStatic(INT_ARRAY_EQUALS, left, right);
                    }
                    case LONG: {
                        yield InsnTrees.invokeStatic(LONG_ARRAY_EQUALS, left, right);
                    }
                    case FLOAT: {
                        yield InsnTrees.invokeStatic(FLOAT_ARRAY_EQUALS, left, right);
                    }
                    case DOUBLE: {
                        yield InsnTrees.invokeStatic(DOUBLE_ARRAY_EQUALS, left, right);
                    }
                    case CHAR: {
                        yield InsnTrees.invokeStatic(CHAR_ARRAY_EQUALS, left, right);
                    }
                    case BOOLEAN: {
                        yield InsnTrees.invokeStatic(BOOLEAN_ARRAY_EQUALS, left, right);
                    }
                    case OBJECT: {
                        yield InsnTrees.invokeStatic(ARRAY_CLASSES.contains(componentType) ? OBJECT_ARRAY_EQUALS : OBJECT_ARRAYS_EQUALS, left, right);
                    }
                    case ARRAY: 
                }
                yield InsnTrees.invokeStatic(OBJECT_ARRAY_EQUALS, left, right);
            }
        };
    }

    public static boolean equals(Object a, Object b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.getClass().isArray()) {
            if (b.getClass().isArray()) {
                return ArrayExtensions.arrayEquals(a, b);
            }
            return false;
        }
        if (b.getClass().isArray()) {
            return false;
        }
        return a.equals(b);
    }

    public static boolean arrayEquals(Object a, Object b) {
        Class<?> bc;
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        Class<?> ac = a.getClass().getComponentType();
        if (ac != (bc = b.getClass().getComponentType())) {
            return false;
        }
        if (ac.isPrimitive()) {
            return ArrayExtensions.primitiveArrayEquals(a, b);
        }
        if (ac.isArray() || ac == Object.class) {
            return ArrayExtensions.objectArrayEquals((Object[])a, (Object[])b);
        }
        return Arrays.equals((Object[])a, (Object[])b);
    }

    public static boolean primitiveArrayEquals(Object a, Object b) {
        Class<?> bc;
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        Class<?> ac = a.getClass();
        if (ac != (bc = b.getClass())) {
            return false;
        }
        return switch (ac.getName().charAt(1)) {
            case 'B' -> Arrays.equals((byte[])a, (byte[])b);
            case 'S' -> Arrays.equals((short[])a, (short[])b);
            case 'I' -> Arrays.equals((int[])a, (int[])b);
            case 'J' -> Arrays.equals((long[])a, (long[])b);
            case 'F' -> Arrays.equals((float[])a, (float[])b);
            case 'D' -> Arrays.equals((double[])a, (double[])b);
            case 'C' -> Arrays.equals((char[])a, (char[])b);
            case 'Z' -> Arrays.equals((boolean[])a, (boolean[])b);
            default -> throw new AssertionError(ac);
        };
    }

    public static boolean objectArrayEquals(Object[] a, Object[] b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        int length = a.length;
        if (b.length != length) {
            return false;
        }
        for (int index = 0; index < length; ++index) {
            if (ArrayExtensions.equals(a[index], b[index])) continue;
            return false;
        }
        return true;
    }

    public static InsnTree computeHashCode(InsnTree object) {
        TypeInfo type = object.getTypeInfo();
        return switch (type.getSort()) {
            default -> throw new IncompatibleClassChangeError();
            case TypeInfo.Sort.VOID -> throw new IllegalArgumentException("Hash code of void");
            case TypeInfo.Sort.BYTE -> InsnTrees.invokeStatic(BYTE_HASH_CODE, object);
            case TypeInfo.Sort.SHORT -> InsnTrees.invokeStatic(SHORT_HASH_CODE, object);
            case TypeInfo.Sort.INT -> InsnTrees.invokeStatic(INT_HASH_CODE, object);
            case TypeInfo.Sort.LONG -> InsnTrees.invokeStatic(LONG_HASH_CODE, object);
            case TypeInfo.Sort.FLOAT -> InsnTrees.invokeStatic(FLOAT_HASH_CODE, object);
            case TypeInfo.Sort.DOUBLE -> InsnTrees.invokeStatic(DOUBLE_HASH_CODE, object);
            case TypeInfo.Sort.CHAR -> InsnTrees.invokeStatic(CHAR_HASH_CODE, object);
            case TypeInfo.Sort.BOOLEAN -> InsnTrees.invokeStatic(BOOLEAN_HASH_CODE, object);
            case TypeInfo.Sort.OBJECT -> InsnTrees.invokeStatic(ARRAY_CLASSES.contains(type) ? OBJECT_HASH_CODE : OBJECTS_HASH_CODE, object);
            case TypeInfo.Sort.ARRAY -> {
                TypeInfo componentType = type.componentType;
                switch (componentType.getSort()) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case VOID: {
                        throw new IllegalArgumentException("Array of voids");
                    }
                    case BYTE: {
                        yield InsnTrees.invokeStatic(BYTE_ARRAY_HASH_CODE, object);
                    }
                    case SHORT: {
                        yield InsnTrees.invokeStatic(SHORT_ARRAY_HASH_CODE, object);
                    }
                    case INT: {
                        yield InsnTrees.invokeStatic(INT_ARRAY_HASH_CODE, object);
                    }
                    case LONG: {
                        yield InsnTrees.invokeStatic(LONG_ARRAY_HASH_CODE, object);
                    }
                    case FLOAT: {
                        yield InsnTrees.invokeStatic(FLOAT_ARRAY_HASH_CODE, object);
                    }
                    case DOUBLE: {
                        yield InsnTrees.invokeStatic(DOUBLE_ARRAY_HASH_CODE, object);
                    }
                    case CHAR: {
                        yield InsnTrees.invokeStatic(CHAR_ARRAY_HASH_CODE, object);
                    }
                    case BOOLEAN: {
                        yield InsnTrees.invokeStatic(BOOLEAN_ARRAY_HASH_CODE, object);
                    }
                    case OBJECT: {
                        yield InsnTrees.invokeStatic(ARRAY_CLASSES.contains(componentType) ? OBJECT_ARRAY_HASH_CODE : OBJECT_ARRAYS_HASH_CODE, object);
                    }
                    case ARRAY: 
                }
                yield InsnTrees.invokeStatic(OBJECT_ARRAY_HASH_CODE, object);
            }
        };
    }

    public static int hashCode(Object object) {
        if (object == null) {
            return 0;
        }
        if (object.getClass().isArray()) {
            return ArrayExtensions.arrayHashCode(object);
        }
        return object.hashCode();
    }

    public static int arrayHashCode(Object object) {
        if (object == null) {
            return 0;
        }
        Class<?> c = object.getClass().getComponentType();
        if (c.isPrimitive()) {
            return ArrayExtensions.primitiveArrayHashCode(object);
        }
        if (c.isArray() || c == Object.class) {
            return ArrayExtensions.objectArrayHashCode((Object[])object);
        }
        return Arrays.hashCode((Object[])object);
    }

    public static int primitiveArrayHashCode(Object object) {
        if (object == null) {
            return 0;
        }
        Class<?> c = object.getClass();
        return switch (c.getName().charAt(1)) {
            case 'B' -> Arrays.hashCode((byte[])object);
            case 'S' -> Arrays.hashCode((short[])object);
            case 'I' -> Arrays.hashCode((int[])object);
            case 'J' -> Arrays.hashCode((long[])object);
            case 'F' -> Arrays.hashCode((float[])object);
            case 'D' -> Arrays.hashCode((double[])object);
            case 'C' -> Arrays.hashCode((char[])object);
            case 'Z' -> Arrays.hashCode((boolean[])object);
            default -> throw new AssertionError(c);
        };
    }

    public static int objectArrayHashCode(Object[] objects) {
        if (objects == null) {
            return 0;
        }
        int hash = 1;
        for (Object object : objects) {
            hash = hash * 31 + ArrayExtensions.hashCode(object);
        }
        return hash;
    }
}

