/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.chunkgen.scripted;

import builderb0y.autocodec.annotations.DefaultEmpty;
import builderb0y.autocodec.annotations.VerifyNullable;
import builderb0y.bigglobe.chunkgen.scripted.BlockSegmentList;
import builderb0y.bigglobe.chunkgen.scripted.Layer;
import builderb0y.bigglobe.columns.scripted.ColumnScript;
import builderb0y.bigglobe.columns.scripted.ScriptedColumn;
import builderb0y.bigglobe.columns.scripted.dependencies.DependencyView;
import java.util.stream.Stream;
import net.minecraft.class_2680;
import net.minecraft.class_6880;

public class Simple3DLayer
extends Layer {
    public final ColumnScript.ColumnToBlockStateScript.Holder state;
    public final ColumnScript.ColumnYToBooleanScript.Holder condition;

    public Simple3DLayer(@VerifyNullable Layer.Valid valid, class_6880<Layer> @DefaultEmpty [] children,  @VerifyNullable SurfaceScript.Holder before_children,  @VerifyNullable SurfaceScript.Holder after_children, ColumnScript.ColumnToBlockStateScript.Holder state, ColumnScript.ColumnYToBooleanScript.Holder condition) {
        super(valid, children, before_children, after_children);
        this.state = state;
        this.condition = condition;
    }

    @Override
    public void buildDependencyStream(Stream.Builder<class_6880<? extends DependencyView>> builder) {
        this.state.streamDirectDependencies().forEach(builder);
        this.condition.streamDirectDependencies().forEach(builder);
    }

    @Override
    public void emitSelfSegments(ScriptedColumn column, BlockSegmentList blocks) {
        class_2680 state = this.state.get(column);
        int minY = Math.max(this.validMinY(column), blocks.minY());
        int maxY = Math.min(this.validMaxY(column), blocks.maxY());
        int start = minY;
        boolean haveState = this.condition.get(column, minY);
        int y = minY;
        while (++y < maxY) {
            boolean nextState = this.condition.get(column, y);
            if (haveState == nextState) continue;
            if (haveState) {
                blocks.setBlockStates(start, y, state);
            }
            haveState = nextState;
            start = y;
        }
        if (haveState) {
            blocks.setBlockStates(start, maxY, state);
        }
    }
}

