/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.codecs;

import builderb0y.autocodec.AutoCodec;
import builderb0y.autocodec.coders.AutoCoder;
import builderb0y.autocodec.coders.CoderFactoryList;
import builderb0y.autocodec.coders.EnumCoder;
import builderb0y.autocodec.coders.LookupCoderFactory;
import builderb0y.autocodec.coders.PrimitiveCoders;
import builderb0y.autocodec.common.AutoHandler;
import builderb0y.autocodec.data.Data;
import builderb0y.autocodec.data.DataOps;
import builderb0y.autocodec.data.EmptyData;
import builderb0y.autocodec.decoders.DecodeContext;
import builderb0y.autocodec.decoders.DecodeException;
import builderb0y.autocodec.encoders.EncodeContext;
import builderb0y.autocodec.encoders.EncodeException;
import builderb0y.autocodec.imprinters.CollectionImprinter;
import builderb0y.autocodec.imprinters.ImprinterFactoryList;
import builderb0y.autocodec.logging.DisabledTaskLogger;
import builderb0y.autocodec.logging.IndentedTaskLogger;
import builderb0y.autocodec.logging.Printer;
import builderb0y.autocodec.logging.StackContextLogger;
import builderb0y.autocodec.logging.TaskLogger;
import builderb0y.autocodec.reflection.PseudoField;
import builderb0y.autocodec.reflection.ReflectionManager;
import builderb0y.autocodec.reflection.memberViews.FieldLikeMemberView;
import builderb0y.autocodec.reflection.memberViews.PseudoFieldView;
import builderb0y.autocodec.reflection.reification.ReifiedType;
import builderb0y.autocodec.util.AutoCodecUtil;
import builderb0y.autocodec.verifiers.FloatRangeVerifier;
import builderb0y.autocodec.verifiers.VerifierFactoryList;
import builderb0y.bigglobe.chunkgen.scripted.Layer;
import builderb0y.bigglobe.codecs.BlockStateCoder;
import builderb0y.bigglobe.codecs.BlockStateCollectionImprinter;
import builderb0y.bigglobe.codecs.DataCoder;
import builderb0y.bigglobe.codecs.DecoderContextCoder;
import builderb0y.bigglobe.codecs.StringIdentifiableEnumName;
import builderb0y.bigglobe.codecs.UUIDCoder;
import builderb0y.bigglobe.codecs.UseSuperClass;
import builderb0y.bigglobe.codecs.registries.BetterRegistryCoder;
import builderb0y.bigglobe.codecs.registries.BetterRegistryLookupCoder;
import builderb0y.bigglobe.codecs.registries.DelayedEntryListCoder;
import builderb0y.bigglobe.codecs.registries.RegistryEntryCoder;
import builderb0y.bigglobe.columns.scripted.VoronoiSettings;
import builderb0y.bigglobe.columns.scripted.decisionTrees.DecisionTreeSettings;
import builderb0y.bigglobe.columns.scripted.entries.ColumnEntry;
import builderb0y.bigglobe.columns.scripted.traits.WorldTrait;
import builderb0y.bigglobe.dynamicRegistries.BetterRegistry;
import builderb0y.bigglobe.dynamicRegistries.BigGlobeDynamicRegistries;
import builderb0y.bigglobe.dynamicRegistries.WoodPalette;
import builderb0y.bigglobe.features.dispatch.FeatureDispatcher;
import builderb0y.bigglobe.noise.Grid;
import builderb0y.bigglobe.overriders.Overrider;
import builderb0y.bigglobe.randomSources.RandomRangeVerifier;
import builderb0y.bigglobe.spawning.ExtraSpawn;
import builderb0y.bigglobe.structures.scripted.ScriptedStructure;
import builderb0y.bigglobe.util.DelayedEntryList;
import builderb0y.bigglobe.util.TextCoding;
import builderb0y.bigglobe.versions.IdentifierVersions;
import builderb0y.scripting.parsing.input.ScriptTemplate;
import com.mojang.serialization.DynamicOps;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantLock;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_117;
import net.minecraft.class_1291;
import net.minecraft.class_1299;
import net.minecraft.class_131;
import net.minecraft.class_1792;
import net.minecraft.class_1842;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2396;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2874;
import net.minecraft.class_2922;
import net.minecraft.class_2960;
import net.minecraft.class_2975;
import net.minecraft.class_3195;
import net.minecraft.class_3341;
import net.minecraft.class_3611;
import net.minecraft.class_3785;
import net.minecraft.class_4719;
import net.minecraft.class_4970;
import net.minecraft.class_5284;
import net.minecraft.class_5321;
import net.minecraft.class_5341;
import net.minecraft.class_5497;
import net.minecraft.class_6796;
import net.minecraft.class_6880;
import net.minecraft.class_6910;
import net.minecraft.class_7059;
import net.minecraft.class_7145;
import net.minecraft.class_75;
import net.minecraft.class_79;
import net.minecraft.class_7924;
import net.minecraft.class_8177;
import net.minecraft.class_8813;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BigGlobeAutoCodec {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Big Globe/Codecs");
    public static final Printer PRINTER = BigGlobeAutoCodec.createPrinter(LOGGER);
    public static final AutoCoder<class_2960> IDENTIFIER_CODER = PrimitiveCoders.stringBased((String)"BigGlobeAutoCodec.IDENTIFIER_CODER", IdentifierVersions::create, class_2960::toString);
    public static final RegistryCoders<class_2248> BLOCK_REGISTRY_CODERS = new RegistryCoders(ReifiedType.from(class_2248.class), class_7924.field_41254);
    public static final RegistryCoders<class_1792> ITEM_REGISTRY_CODERS = new RegistryCoders(ReifiedType.from(class_1792.class), class_7924.field_41197);
    public static final RegistryCoders<class_3611> FLUID_REGISTRY_CODERS = new RegistryCoders(ReifiedType.from(class_3611.class), class_7924.field_41270);
    public static final RegistryCoders<class_1842> POTION_REGISTRY_CODERS = new RegistryCoders(ReifiedType.from(class_1842.class), class_7924.field_41215);
    public static final RegistryCoders<class_2591<?>> BLOCK_ENTITY_TYPE_REGISTRY_CODERS = new RegistryCoders(ReifiedType.parameterizeWithWildcards(class_2591.class), class_7924.field_41255);
    public static final RegistryCoders<class_1299<?>> ENTITY_TYPE_REGISTRY_CODERS = new RegistryCoders(ReifiedType.parameterizeWithWildcards(class_1299.class), class_7924.field_41266);
    public static final RegistryCoders<class_1291> STATUS_EFFECT_REGISTRY_CODERS = new RegistryCoders(ReifiedType.from(class_1291.class), class_7924.field_41208);
    public static final RegistryCoders<class_2396<?>> PARTICLE_TYPE_REGISTRY_CODERS = new RegistryCoders(ReifiedType.parameterizeWithWildcards(class_2396.class), class_7924.field_41210);
    public static final RegistryCoders<class_2874> DIMENSION_TYPE_REGISTRY_CODERS = new RegistryCoders(ReifiedType.from(class_2874.class), class_7924.field_41241);
    public static final RegistryCoders<class_2922<?>> CONFIGURED_CARVER_REGISTRY_CODERS = new RegistryCoders(ReifiedType.parameterizeWithWildcards(class_2922.class), class_7924.field_41238);
    public static final RegistryCoders<class_2975<?, ?>> CONFIGURED_FEATURE_REGISTRY_CODERS = new RegistryCoders(ReifiedType.parameterizeWithWildcards(class_2975.class), class_7924.field_41239);
    public static final RegistryCoders<class_6796> PLACED_FEATURE_REGISTRY_CODERS = new RegistryCoders(ReifiedType.from(class_6796.class), class_7924.field_41245);
    public static final RegistryCoders<class_3195> STRUCTURE_REGISTRY_CODERS = new RegistryCoders(ReifiedType.from(class_3195.class), class_7924.field_41246);
    public static final RegistryCoders<class_7059> STRUCTURE_SET_REGISTRY_CODERS = new RegistryCoders(ReifiedType.from(class_7059.class), class_7924.field_41248);
    public static final RegistryCoders<class_5497> STRUCTURE_PROCESSOR_LIST_REGISTRY_CODERS = new RegistryCoders(ReifiedType.from(class_5497.class), class_7924.field_41247);
    public static final RegistryCoders<class_3785> STRUCTURE_POOL_REGISTRY_CODERS = new RegistryCoders(ReifiedType.from(class_3785.class), class_7924.field_41249);
    public static final RegistryCoders<class_1959> BIOME_REGISTRY_CODERS = new RegistryCoders(ReifiedType.from(class_1959.class), class_7924.field_41236);
    public static final RegistryCoders<class_6910> DENSITY_FUNCTION_REGISTRY_CODERS = new RegistryCoders(ReifiedType.from(class_6910.class), class_7924.field_41240);
    public static final RegistryCoders<class_5284> CHUNK_GENERATOR_SETTINGS_REGISTRY_CODERS = new RegistryCoders(ReifiedType.from(class_5284.class), class_7924.field_41243);
    public static final RegistryCoders<class_7145> WORLD_PRESET_REGISTRY_CODERS = new RegistryCoders(ReifiedType.from(class_7145.class), class_7924.field_41250);
    public static final RegistryCoders<WoodPalette> WOOD_PALETTE_REGISTRY_CODERS = new RegistryCoders<WoodPalette>(ReifiedType.from(WoodPalette.class), BigGlobeDynamicRegistries.WOOD_PALETTE_REGISTRY_KEY);
    public static final RegistryCoders<ScriptTemplate> SCRIPT_TEMPLATE_REGISTRY_CODERS = new RegistryCoders<ScriptTemplate>(ReifiedType.from(ScriptTemplate.class), BigGlobeDynamicRegistries.SCRIPT_TEMPLATE_REGISTRY_KEY);
    public static final RegistryCoders<Grid> GRID_TEMPLATE_REGISTRY_CODERS = new RegistryCoders<Grid>(ReifiedType.from(Grid.class), BigGlobeDynamicRegistries.GRID_TEMPLATE_REGISTRY_KEY);
    public static final RegistryCoders<ColumnEntry> COLUMN_ENTRY_REGISTRY_CODERS = new RegistryCoders<ColumnEntry>(ReifiedType.from(ColumnEntry.class), BigGlobeDynamicRegistries.COLUMN_ENTRY_REGISTRY_KEY);
    public static final RegistryCoders<VoronoiSettings> VORONOI_SETTINGS_REGISTRY_CODERS = new RegistryCoders<VoronoiSettings>(ReifiedType.from(VoronoiSettings.class), BigGlobeDynamicRegistries.VORONOI_SETTINGS_REGISTRY_KEY);
    public static final RegistryCoders<DecisionTreeSettings> DECISION_TREE_SETTINGS_REGISTRY_CODERS = new RegistryCoders<DecisionTreeSettings>(ReifiedType.from(DecisionTreeSettings.class), BigGlobeDynamicRegistries.DECISION_TREE_SETTINGS_REGISTRY_KEY);
    public static final RegistryCoders<Overrider> OVERRIDER_REGISTRY_CODERS = new RegistryCoders<Overrider>(ReifiedType.from(Overrider.class), BigGlobeDynamicRegistries.OVERRIDER_REGISTRY_KEY);
    public static final RegistryCoders<ScriptedStructure.CombinedStructureScripts> SCRIPT_STRUCTURE_PLACEMENT_REGISTRY_CODERS = new RegistryCoders<ScriptedStructure.CombinedStructureScripts>(ReifiedType.from(ScriptedStructure.CombinedStructureScripts.class), BigGlobeDynamicRegistries.SCRIPT_STRUCTURE_PLACEMENT_REGISTRY_KEY);
    public static final RegistryCoders<FeatureDispatcher> FEATURE_DISPATCHER_REGISTRY_CODERS = new RegistryCoders<FeatureDispatcher>(ReifiedType.from(FeatureDispatcher.class), BigGlobeDynamicRegistries.FEATURE_DISPATCHER_REGISTRY_KEY);
    public static final RegistryCoders<WorldTrait> WORLD_TRAIT_REGISTRY_CODERS = new RegistryCoders<WorldTrait>(ReifiedType.from(WorldTrait.class), BigGlobeDynamicRegistries.WORLD_TRAIT_REGISTRY_KEY);
    public static final RegistryCoders<Layer> LAYER_REGISTRY_CODERS = new RegistryCoders<Layer>(ReifiedType.from(Layer.class), BigGlobeDynamicRegistries.LAYER_REGISTRY_KEY);
    public static final RegistryCoders<ExtraSpawn> EXTRA_SPAWN_REGISTRY_CODERS = new RegistryCoders<ExtraSpawn>(ReifiedType.from(ExtraSpawn.class), BigGlobeDynamicRegistries.EXTRA_SPAWN_REGISTRY_KEY);
    public static final RegistryCoders<?>[] DYNAMIC_REGISTRY_CODERS = new RegistryCoders[]{BLOCK_REGISTRY_CODERS, ITEM_REGISTRY_CODERS, FLUID_REGISTRY_CODERS, POTION_REGISTRY_CODERS, BLOCK_ENTITY_TYPE_REGISTRY_CODERS, ENTITY_TYPE_REGISTRY_CODERS, STATUS_EFFECT_REGISTRY_CODERS, PARTICLE_TYPE_REGISTRY_CODERS, DIMENSION_TYPE_REGISTRY_CODERS, CONFIGURED_CARVER_REGISTRY_CODERS, CONFIGURED_FEATURE_REGISTRY_CODERS, PLACED_FEATURE_REGISTRY_CODERS, STRUCTURE_REGISTRY_CODERS, STRUCTURE_SET_REGISTRY_CODERS, STRUCTURE_PROCESSOR_LIST_REGISTRY_CODERS, STRUCTURE_POOL_REGISTRY_CODERS, BIOME_REGISTRY_CODERS, DENSITY_FUNCTION_REGISTRY_CODERS, CHUNK_GENERATOR_SETTINGS_REGISTRY_CODERS, WORLD_PRESET_REGISTRY_CODERS, WOOD_PALETTE_REGISTRY_CODERS, SCRIPT_TEMPLATE_REGISTRY_CODERS, GRID_TEMPLATE_REGISTRY_CODERS, COLUMN_ENTRY_REGISTRY_CODERS, VORONOI_SETTINGS_REGISTRY_CODERS, DECISION_TREE_SETTINGS_REGISTRY_CODERS, OVERRIDER_REGISTRY_CODERS, SCRIPT_STRUCTURE_PLACEMENT_REGISTRY_CODERS, FEATURE_DISPATCHER_REGISTRY_CODERS, WORLD_TRAIT_REGISTRY_CODERS, LAYER_REGISTRY_CODERS, EXTRA_SPAWN_REGISTRY_CODERS};
    public static final AutoCodec AUTO_CODEC = new AutoCodec(){

        @NotNull
        public TaskLogger createFactoryLogger(@NotNull ReentrantLock lock) {
            return LoggingMode.get("factory").createLogger(lock);
        }

        @NotNull
        public TaskLogger createEncodeLogger(@NotNull ReentrantLock lock) {
            return LoggingMode.get("encoding").createLogger(lock);
        }

        @NotNull
        public TaskLogger createDecodeLogger(@NotNull ReentrantLock lock) {
            return LoggingMode.get("decoding").createLogger(lock);
        }

        @ApiStatus.OverrideOnly
        @NotNull
        public CoderFactoryList createCoders() {
            return new CoderFactoryList(this, this){

                public void setup() {
                    super.setup();
                    this.addFactoryToStart((AutoHandler.AutoFactory)UseSuperClass.Coder.Factory.INSTANCE);
                    this.addFactoryBefore(LookupCoderFactory.class, (AutoHandler.AutoFactory)Grid.GridRegistryEntryCoder.Factory.INSTANCE);
                    this.addFactoryAfter(LookupCoderFactory.class, (AutoHandler.AutoFactory)RegistryEntryCoder.Factory.INSTANCE);
                    ((EnumCoder.Factory)this.getFactory(EnumCoder.Factory.class)).nameGetter = StringIdentifiableEnumName.INSTANCE;
                }

                @NotNull
                public AutoCoder.CoderFactory createLookupFactory() {
                    return new LookupCoderFactory(){

                        public void setup() {
                            super.setup();
                            this.addRaw(class_2520.class, (AutoCoder)new AutoCoder.NamedCoder<class_2520>(this, "NbtElementCoder"){

                                @ApiStatus.OverrideOnly
                                @Nullable
                                public <T_Encoded> class_2520 decode(@NotNull DecodeContext<T_Encoded> context) throws DecodeException {
                                    if (context.isEmpty()) {
                                        return null;
                                    }
                                    return (class_2520)DataOps.UNCOMPRESSED.convertTo((DynamicOps)class_2509.field_11560, context.data);
                                }

                                @ApiStatus.OverrideOnly
                                @NotNull
                                public <T_Encoded> Data encode(@NotNull EncodeContext<T_Encoded, class_2520> context) throws EncodeException {
                                    if (context.object == null) {
                                        return EmptyData.INSTANCE;
                                    }
                                    return (Data)class_2509.field_11560.method_29146((DynamicOps)DataOps.UNCOMPRESSED, (class_2520)context.object);
                                }
                            });
                            this.addRaw(UUID.class, (AutoCoder)UUIDCoder.INSTANCE);
                            for (RegistryCoders<?> coders : DYNAMIC_REGISTRY_CODERS) {
                                coders.addAllTo(this);
                            }
                            this.addGeneric(ReifiedType.parameterize(class_5321.class, (ReifiedType[])new ReifiedType[]{ReifiedType.from(class_1937.class)}), PrimitiveCoders.stringBased((String)"AutoCoder<RegistryKey<World>>", string -> class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)IdentifierVersions.create(string)), key -> key.method_29177().toString()));
                            this.addRaw(Data.class, (AutoCoder)DataCoder.INSTANCE);
                            this.addRaw(DecodeContext.class, (AutoCoder)DecoderContextCoder.INSTANCE);
                            this.addRaw(class_2960.class, IDENTIFIER_CODER);
                            this.addRaw(class_2680.class, (AutoCoder)BlockStateCoder.INSTANCE);
                            this.addRaw(BetterRegistry.Lookup.class, (AutoCoder)BetterRegistryLookupCoder.INSTANCE);
                            this.addRaw(class_1966.class, (AutoCoder)autoCodec.wrapDFUCodec(class_1966.field_24713));
                            this.addRaw(class_3195.class_7302.class, (AutoCoder)autoCodec.wrapDFUCodec(class_3195.class_7302.field_38430.codec()));
                            this.addRaw(class_79.class, (AutoCoder)autoCodec.wrapDFUCodec(class_75.field_45802));
                            this.addRaw(class_117.class, (AutoCoder)autoCodec.wrapDFUCodec(class_131.field_50023));
                            this.addRaw(class_5341.class, (AutoCoder)autoCodec.wrapDFUCodec(class_5341.field_51809));
                            this.addRaw(class_4970.class_2251.class, (AutoCoder)autoCodec.wrapDFUCodec(class_4970.class_2251.field_46532));
                            this.addRaw(class_8813.class, (AutoCoder)autoCodec.wrapDFUCodec(class_8813.field_46510));
                            this.addRaw(class_8177.class, (AutoCoder)autoCodec.wrapDFUCodec(class_8177.field_46534));
                            this.addRaw(class_4719.class, (AutoCoder)autoCodec.wrapDFUCodec(class_4719.field_46535));
                            this.addRaw(class_3341.class, (AutoCoder)autoCodec.wrapDFUCodec(class_3341.field_29325));
                            this.addRaw(class_2561.class, TextCoding.CODER);
                        }
                    };
                }
            };
        }

        @NotNull
        public ImprinterFactoryList createImprinters() {
            return new ImprinterFactoryList(this, this){

                public void setup() {
                    super.setup();
                    this.addFactoryBefore((AutoHandler.AutoFactory)CollectionImprinter.Factory.INSTANCE, (AutoHandler.AutoFactory)BlockStateCollectionImprinter.Factory.INSTANCE);
                }
            };
        }

        @NotNull
        public VerifierFactoryList createVerifiers() {
            return new VerifierFactoryList(this, this){

                public void setup() {
                    super.setup();
                    this.addFactoryAfter((AutoHandler.AutoFactory)FloatRangeVerifier.Factory.INSTANCE, (AutoHandler.AutoFactory)RandomRangeVerifier.Factory.INSTANCE);
                }
            };
        }

        @NotNull
        public ReflectionManager createReflectionManager() {
            return new ReflectionManager(this){
                public static final Method BLOCK_SETTINGS_GETTER;

                @NotNull
                public <T_Owner> ReflectionManager.ClassCache<T_Owner> createClassCache(@NotNull Class<T_Owner> owner) {
                    ReflectionManager.ClassCache cache = super.createClassCache(owner);
                    if (owner == BLOCK_SETTINGS_GETTER.getDeclaringClass()) {
                        cache.methods = new Method[]{BLOCK_SETTINGS_GETTER};
                    }
                    return cache;
                }

                @NotNull
                public <T_Owner> ReflectionManager.TypeCache<T_Owner> createTypeCache(@NotNull ReifiedType<T_Owner> owner) {
                    ReflectionManager.TypeCache cache = super.createTypeCache(owner);
                    if (owner.getRawClass() == BLOCK_SETTINGS_GETTER.getDeclaringClass()) {
                        cache.fields = new FieldLikeMemberView[]{new PseudoFieldView(owner, new PseudoField(owner.getRawClass(), "settings", BLOCK_SETTINGS_GETTER, null))};
                    }
                    return cache;
                }

                public boolean canView(@NotNull Class<?> clazz) {
                    return super.canView(clazz) && (clazz.getName().startsWith("builderb0y.") || clazz.getName().startsWith("java.util."));
                }

                public boolean canView(@NotNull Field field) {
                    return super.canView(field) && field.getDeclaringClass().getName().startsWith("builderb0y.");
                }

                static {
                    try {
                        BLOCK_SETTINGS_GETTER = class_4970.class.getDeclaredMethod(FabricLoader.getInstance().getMappingResolver().mapMethodName("intermediary", "net.minecraft.class_4970", "method_54095", "()Lnet/minecraft/class_4970$class_2251;"), new Class[0]);
                    }
                    catch (NoSuchMethodException exception) {
                        throw AutoCodecUtil.rethrow((Throwable)exception);
                    }
                }
            };
        }
    };

    public static AutoCoder<class_2960> createNamespacedIdentifierCodec(String namespace) {
        return PrimitiveCoders.stringBased((String)("Identifier with default namespace '" + namespace + "'"), string -> BigGlobeAutoCodec.toID(string, namespace), id -> BigGlobeAutoCodec.toString(id, namespace));
    }

    public static class_2960 toID(String string, String defaultNamespace) {
        String path;
        String namespace;
        int colon = string.indexOf(58);
        if (colon >= 0) {
            namespace = string.substring(0, colon);
            path = string.substring(colon + 1);
        } else {
            namespace = defaultNamespace;
            path = string;
        }
        return IdentifierVersions.create(namespace, path);
    }

    public static String toString(class_2960 identifier, String defaultNamespace) {
        return identifier.method_12836().equals(defaultNamespace) ? identifier.method_12832() : identifier.toString();
    }

    public static Printer createPrinter(final Logger logger) {
        return new Printer(){

            public void print(@NotNull String message) {
                logger.info(message);
            }

            public void printError(@NotNull String error) {
                logger.error(error);
            }
        };
    }

    public static class RegistryCoders<T> {
        @NotNull
        public final class_5321<class_2378<T>> registryKey;
        @NotNull
        public final ReifiedType<T> objectType;
        @NotNull
        public final ReifiedType<class_2378<T>> registryType;
        @NotNull
        public final ReifiedType<BetterRegistry<T>> betterRegistryType;
        @NotNull
        public final ReifiedType<class_6880<T>> registryEntryType;
        @NotNull
        public final ReifiedType<DelayedEntryList<T>> delayedTagType;
        @NotNull
        public final BetterRegistryCoder<T> betterRegistryCoder;
        @NotNull
        public final DelayedEntryListCoder<T> delayedEntryListCoder;

        public RegistryCoders(@NotNull ReifiedType<T> objectType, @NotNull class_5321<class_2378<T>> registryKey) {
            this.registryKey = registryKey;
            this.objectType = objectType;
            this.registryType = ReifiedType.parameterize(class_2378.class, (ReifiedType[])new ReifiedType[]{objectType});
            this.registryEntryType = ReifiedType.parameterize(class_6880.class, (ReifiedType[])new ReifiedType[]{objectType});
            this.delayedTagType = ReifiedType.parameterize(DelayedEntryList.class, (ReifiedType[])new ReifiedType[]{objectType});
            this.betterRegistryType = ReifiedType.parameterize(BetterRegistry.class, (ReifiedType[])new ReifiedType[]{objectType});
            this.betterRegistryCoder = new BetterRegistryCoder<T>(this.betterRegistryType, registryKey);
            this.delayedEntryListCoder = new DelayedEntryListCoder<T>(this.delayedTagType, registryKey);
        }

        public void addAllTo(LookupCoderFactory factory) {
            factory.addGeneric(this.betterRegistryType, this.betterRegistryCoder);
            factory.addGeneric(this.delayedTagType, this.delayedEntryListCoder);
            RegistryEntryCoder.Factory.INSTANCE.register(this.objectType, this.registryKey);
        }
    }

    public static enum LoggingMode {
        DISABLED{

            @Override
            public TaskLogger createLogger(ReentrantLock lock) {
                return new DisabledTaskLogger();
            }
        }
        ,
        DEFAULT{

            @Override
            public TaskLogger createLogger(ReentrantLock lock) {
                return new StackContextLogger(lock, PRINTER, true);
            }
        }
        ,
        VERBOSE{

            @Override
            public TaskLogger createLogger(ReentrantLock lock) {
                return new IndentedTaskLogger(lock, PRINTER, false);
            }
        };


        public static LoggingMode get(String key) {
            String fullKey = "bigglobe.codecs.logging." + key;
            String value = System.getProperty(fullKey);
            if (value != null) {
                return switch (value.toLowerCase(Locale.ROOT)) {
                    case "disabled" -> DISABLED;
                    case "default" -> DEFAULT;
                    case "verbose" -> VERBOSE;
                    default -> {
                        LOGGER.warn("Unrecognized logging mode: -D" + fullKey + "=" + value + ". Valid logging modes are disabled, default, and verbose.");
                        yield DEFAULT;
                    }
                };
            }
            return DEFAULT;
        }

        public abstract TaskLogger createLogger(ReentrantLock var1);
    }
}

