/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.columns.scripted.classes;

import builderb0y.bigglobe.columns.scripted.classes.AbstractMethodSpec;
import builderb0y.bigglobe.columns.scripted.classes.AbstractPropertySpec;
import builderb0y.bigglobe.columns.scripted.classes.BaseClassSpec;
import builderb0y.bigglobe.columns.scripted.classes.BaseMethodSpec;
import builderb0y.bigglobe.columns.scripted.classes.BasePropertySpec;
import builderb0y.bigglobe.columns.scripted.classes.ClassHierarchy;
import builderb0y.bigglobe.columns.scripted.classes.ConstructorSpec;
import builderb0y.bigglobe.columns.scripted.classes.CustomClassFormatException;
import builderb0y.bigglobe.columns.scripted.classes.ElementSpec;
import builderb0y.bigglobe.columns.scripted.classes.FieldSpec;
import builderb0y.bigglobe.columns.scripted.classes.NormalMethodSpec;
import builderb0y.bigglobe.columns.scripted.classes.NormalPropertySpec;
import builderb0y.bigglobe.columns.scripted.classes.OverrideMethodSpec;
import builderb0y.bigglobe.columns.scripted.classes.OverridePropertySpec;
import builderb0y.bigglobe.util.UnregisteredObjectException;
import builderb0y.scripting.bytecode.TypeInfo;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.stream.Stream;
import net.minecraft.class_6880;

public class OverrideTracker {
    public final ClassHierarchy hierarchy;
    public final class_6880<ElementSpec> owner;
    public final Object2ObjectOpenHashMap<String, TrackedField> fields = new Object2ObjectOpenHashMap();
    public final Object2ObjectOpenHashMap<BaseMethodSpec.MethodSpecDesc, TrackedMethod> methods = new Object2ObjectOpenHashMap();
    public final Object2ObjectOpenHashMap<String, TrackedProperty> properties = new Object2ObjectOpenHashMap();

    public OverrideTracker(ClassHierarchy hierarchy, class_6880<ElementSpec> owner) {
        this.hierarchy = hierarchy;
        this.owner = owner;
    }

    public OverrideTracker(ClassHierarchy hierarchy, class_6880<ElementSpec> owner, OverrideTracker from) {
        this(hierarchy, owner);
        this.fields.putAll(from.fields);
        this.methods.putAll(from.methods);
    }

    public boolean hasAnyAbstractMethods() {
        for (TrackedMethod method : this.methods.values()) {
            if (method.type != TrackedMethod.Type.ABSTRACT) continue;
            return true;
        }
        for (TrackedProperty property : this.properties.values()) {
            if (property.type != TrackedProperty.Type.ABSTRACT) continue;
            return true;
        }
        return false;
    }

    public Stream<class_6880<ElementSpec>> getAbstractMembers() {
        return Stream.concat(this.methods.values().stream().filter(method -> method.type == TrackedMethod.Type.ABSTRACT).map(TrackedMethod::declaration), this.properties.values().stream().filter(property -> property.type == TrackedProperty.Type.ABSTRACT).map(TrackedProperty::declaration));
    }

    public void addReservedField(String name) {
        this.fields.put((Object)name, (Object)new TrackedField(this.owner, null, TrackedField.Type.RESERVED));
    }

    public void addReservedMethod(BaseMethodSpec.MethodSpecDesc desc) {
        this.methods.put((Object)desc, (Object)new TrackedMethod(this.owner, null, TrackedMethod.Type.RESERVED));
    }

    public void addReservedMethod(String name, TypeInfo ... parameters) {
        this.addReservedMethod(new BaseMethodSpec.MethodSpecDesc(name, Arrays.asList(parameters)));
    }

    public void addNormalField(FieldSpec field) throws CustomClassFormatException {
        class_6880<ElementSpec> entry = this.hierarchy.entryOf(field);
        TrackedProperty existingProperty = (TrackedProperty)this.properties.get((Object)field.name);
        if (existingProperty != null) {
            throw new CustomClassFormatException("Field " + String.valueOf(UnregisteredObjectException.getID(entry)) + " in class " + String.valueOf(UnregisteredObjectException.getID(this.owner)) + " conflicts with property " + String.valueOf(UnregisteredObjectException.getID(existingProperty.declaration)) + " in class " + String.valueOf(UnregisteredObjectException.getID(existingProperty.owner)));
        }
        TrackedField existing = (TrackedField)this.fields.get((Object)field.name);
        if (existing != null) {
            if (existing.type == TrackedField.Type.RESERVED) {
                throw new CustomClassFormatException("Field " + field.name + " is reserved.");
            }
            if (existing.owner == this.owner) {
                throw new CustomClassFormatException("Multiple fields named " + field.name + " in class " + String.valueOf(UnregisteredObjectException.getID(this.owner)));
            }
            throw new CustomClassFormatException("Field " + field.name + " in class " + String.valueOf(UnregisteredObjectException.getID(this.owner)) + " shadows another field with the same name in a class being extended.");
        }
        this.fields.put((Object)field.name, (Object)new TrackedField(this.owner, entry, TrackedField.Type.NORMAL));
    }

    public void checkPropertyConflicts(BasePropertySpec property) throws CustomClassFormatException {
        class_6880<ElementSpec> entry = this.hierarchy.entryOf(property);
        TrackedField existingField = (TrackedField)this.fields.get((Object)property.name());
        if (existingField != null) {
            if (existingField.type == TrackedField.Type.RESERVED) {
                throw new CustomClassFormatException("Property name " + property.name() + " used by " + String.valueOf(UnregisteredObjectException.getID(entry)) + " is reserved.");
            }
            throw new CustomClassFormatException("Property " + String.valueOf(UnregisteredObjectException.getID(entry)) + " in class " + String.valueOf(UnregisteredObjectException.getID(this.owner)) + " conflicts with field " + String.valueOf(UnregisteredObjectException.getID(existingField.declaration)) + " in class " + String.valueOf(UnregisteredObjectException.getID(existingField.owner)));
        }
        TrackedMethod existingGetter = (TrackedMethod)this.methods.get((Object)new BaseMethodSpec.MethodSpecDesc(property.name(), Collections.emptyList()));
        if (existingGetter != null) {
            if (existingGetter.type == TrackedMethod.Type.RESERVED) {
                throw new CustomClassFormatException("Property name " + property.name() + " used by " + String.valueOf(UnregisteredObjectException.getID(entry)) + " is reserved.");
            }
            throw new CustomClassFormatException("Internal getter method of property " + String.valueOf(UnregisteredObjectException.getID(entry)) + " in class " + String.valueOf(UnregisteredObjectException.getID(this.owner)) + " conflicts with method " + String.valueOf(UnregisteredObjectException.getID(existingGetter.declaration)) + " in class " + String.valueOf(UnregisteredObjectException.getID(existingGetter.owner)));
        }
        TypeInfo typeInfo = ElementSpec.asType(property.getPropertyType()).getTypeInfo();
        TrackedMethod existingSetter = (TrackedMethod)this.methods.get((Object)new BaseMethodSpec.MethodSpecDesc(property.name(), Collections.singletonList(typeInfo)));
        if (existingSetter != null) {
            if (existingSetter.type == TrackedMethod.Type.RESERVED) {
                throw new CustomClassFormatException("Property name " + property.name() + " used by " + String.valueOf(UnregisteredObjectException.getID(entry)) + " is reserved.");
            }
            throw new CustomClassFormatException("Internal setter method of property " + String.valueOf(UnregisteredObjectException.getID(entry)) + " in class " + String.valueOf(UnregisteredObjectException.getID(this.owner)) + " conflicts with method " + String.valueOf(UnregisteredObjectException.getID(existingSetter.declaration)) + " in class " + String.valueOf(UnregisteredObjectException.getID(existingSetter.owner)));
        }
    }

    public void addNormalProperty(NormalPropertySpec property) throws CustomClassFormatException {
        this.checkPropertyConflicts(property);
        class_6880<ElementSpec> entry = this.hierarchy.entryOf(property);
        TrackedProperty existingProperty = (TrackedProperty)this.properties.get((Object)property.name);
        if (existingProperty != null) {
            if (existingProperty.owner == this.owner) {
                throw new CustomClassFormatException("Multiple properties named " + property.name + " in class " + String.valueOf(UnregisteredObjectException.getID(this.owner)) + ": [" + String.valueOf(UnregisteredObjectException.getID(entry)) + ", " + String.valueOf(UnregisteredObjectException.getID(existingProperty.declaration)) + "]");
            }
            throw new CustomClassFormatException("Property " + String.valueOf(UnregisteredObjectException.getID(entry)) + " in class " + String.valueOf(UnregisteredObjectException.getID(this.owner)) + " overrides property " + String.valueOf(UnregisteredObjectException.getID(existingProperty.declaration)) + " in class " + String.valueOf(UnregisteredObjectException.getID(existingProperty.owner)) + ", but its type was property/normal. If overriding is intentional, its type should be property/override");
        }
        this.properties.put((Object)property.name, (Object)new TrackedProperty(this.owner, entry, TrackedProperty.Type.NORMAL, property.isSettable()));
    }

    public void addOverrideProperty(OverridePropertySpec property) throws CustomClassFormatException {
        this.checkPropertyConflicts(property);
        class_6880<ElementSpec> entry = this.hierarchy.entryOf(property);
        TrackedProperty existingProperty = (TrackedProperty)this.properties.get((Object)property.name());
        if (existingProperty == null) {
            throw new CustomClassFormatException("Property " + String.valueOf(UnregisteredObjectException.getID(entry)) + " overrides property " + String.valueOf(UnregisteredObjectException.getID(property.override)) + " but that property is not inherited by class " + String.valueOf(UnregisteredObjectException.getID(this.owner)));
        }
        if (existingProperty.owner == this.owner) {
            throw new CustomClassFormatException("Multiple properties named " + property.name() + " in class " + String.valueOf(UnregisteredObjectException.getID(this.owner)) + ": [" + String.valueOf(UnregisteredObjectException.getID(entry)) + ", " + String.valueOf(UnregisteredObjectException.getID(existingProperty.declaration)) + "]");
        }
        if (property.override != existingProperty.declaration) {
            throw new CustomClassFormatException("Property " + String.valueOf(UnregisteredObjectException.getID(entry)) + " overrides property " + String.valueOf(UnregisteredObjectException.getID(property.override)) + " but that property is already overridden by " + String.valueOf(UnregisteredObjectException.getID(existingProperty.declaration)) + " in class " + String.valueOf(UnregisteredObjectException.getID(existingProperty.owner)));
        }
        this.properties.put((Object)property.name(), (Object)new TrackedProperty(this.owner, entry, TrackedProperty.Type.NORMAL, property.isSettable()));
    }

    public void addAbstractProperty(AbstractPropertySpec property) throws CustomClassFormatException {
        this.checkPropertyConflicts(property);
        class_6880<ElementSpec> entry = this.hierarchy.entryOf(property);
        TrackedProperty existingProperty = (TrackedProperty)this.properties.get((Object)property.name);
        if (existingProperty != null) {
            if (existingProperty.owner == this.owner) {
                throw new CustomClassFormatException("Multiple properties named " + property.name + " in class " + String.valueOf(UnregisteredObjectException.getID(this.owner)) + ": [" + String.valueOf(UnregisteredObjectException.getID(entry)) + ", " + String.valueOf(UnregisteredObjectException.getID(existingProperty.declaration)) + "]");
            }
            throw new CustomClassFormatException("Property " + String.valueOf(UnregisteredObjectException.getID(entry)) + " in class " + String.valueOf(UnregisteredObjectException.getID(this.owner)) + " overrides property " + String.valueOf(UnregisteredObjectException.getID(existingProperty.declaration)) + " in class " + String.valueOf(UnregisteredObjectException.getID(existingProperty.owner)) + ", but its type was property/abstract. Abstract properties cannot (currently) override other properties.");
        }
        this.properties.put((Object)property.name, (Object)new TrackedProperty(this.owner, entry, TrackedProperty.Type.NORMAL, property.isSettable()));
    }

    public void addConstructor(ConstructorSpec constructor) throws CustomClassFormatException {
        class_6880<ElementSpec> entry = this.hierarchy.entryOf(constructor);
        ConstructorSpec.ConstructorContext context = (ConstructorSpec.ConstructorContext)((BaseClassSpec)this.owner.comp_349()).getCompileContext(constructor);
        TrackedMethod existing = (TrackedMethod)this.methods.get((Object)context.descriptor);
        if (existing != null) {
            if (existing.type == TrackedMethod.Type.RESERVED) {
                throw new CustomClassFormatException("Constructor " + String.valueOf(context.descriptor) + " is reserved.");
            }
            if (existing.owner == this.owner) {
                throw new CustomClassFormatException("Constructor " + String.valueOf(UnregisteredObjectException.getID(entry)) + " in class " + String.valueOf(UnregisteredObjectException.getID(this.owner)) + " conflicts with " + String.valueOf(UnregisteredObjectException.getID(existing.declaration)));
            }
        }
        this.methods.put((Object)context.descriptor, (Object)new TrackedMethod(this.owner, entry, TrackedMethod.Type.CONSTRUCTOR));
    }

    public void checkPropertyConflicts(BaseMethodSpec method) throws CustomClassFormatException {
        class_6880<ElementSpec> entry = this.hierarchy.entryOf(method);
        BaseMethodSpec.MethodSpecDesc desc = method.getDescriptor();
        switch (desc.parameters().size()) {
            case 0: {
                TrackedProperty existingProperty = (TrackedProperty)this.properties.get((Object)method.name());
                if (existingProperty == null) break;
                throw new CustomClassFormatException("Method " + String.valueOf(UnregisteredObjectException.getID(entry)) + " in class " + String.valueOf(UnregisteredObjectException.getID(this.owner)) + " conflicts with internal getter of property " + String.valueOf(UnregisteredObjectException.getID(existingProperty.declaration)) + " in class " + String.valueOf(UnregisteredObjectException.getID(existingProperty.owner)));
            }
            case 1: {
                TrackedProperty existingProperty = (TrackedProperty)this.properties.get((Object)method.name());
                if (existingProperty == null) break;
                throw new CustomClassFormatException("Method " + String.valueOf(UnregisteredObjectException.getID(entry)) + " in class " + String.valueOf(UnregisteredObjectException.getID(this.owner)) + " conflicts with internal setter of property " + String.valueOf(UnregisteredObjectException.getID(existingProperty.declaration)) + " in class " + String.valueOf(UnregisteredObjectException.getID(existingProperty.owner)));
            }
        }
    }

    public void addInstanceMethod(NormalMethodSpec method) throws CustomClassFormatException {
        class_6880<ElementSpec> entry = this.hierarchy.entryOf(method);
        BaseMethodSpec.MethodSpecDesc desc = method.getDescriptor();
        TrackedMethod existingMethod = (TrackedMethod)this.methods.get((Object)desc);
        if (existingMethod != null) {
            if (existingMethod.type == TrackedMethod.Type.RESERVED) {
                throw new CustomClassFormatException("Method " + String.valueOf(desc) + " is reserved.");
            }
            if (existingMethod.owner == this.owner) {
                throw new CustomClassFormatException("Multiple methods named " + method.name() + " in class " + String.valueOf(UnregisteredObjectException.getID(this.owner)) + " with parameters " + String.valueOf(desc.parameters()) + ": [" + String.valueOf(UnregisteredObjectException.getID(entry)) + ", " + String.valueOf(UnregisteredObjectException.getID(existingMethod.declaration)) + "]");
            }
            if (existingMethod.type != TrackedMethod.Type.CONSTRUCTOR) {
                throw new CustomClassFormatException("Method " + String.valueOf(UnregisteredObjectException.getID(entry)) + " in class " + String.valueOf(UnregisteredObjectException.getID(this.owner)) + " conflicts with method " + String.valueOf(UnregisteredObjectException.getID(existingMethod.declaration)) + " in class " + String.valueOf(UnregisteredObjectException.getID(existingMethod.owner)));
            }
        }
        this.checkPropertyConflicts(method);
        this.methods.put((Object)desc, (Object)new TrackedMethod(this.owner, entry, TrackedMethod.Type.NORMAL));
    }

    public void addAbstractMethod(AbstractMethodSpec method) throws CustomClassFormatException {
        class_6880<ElementSpec> entry = this.hierarchy.entryOf(method);
        BaseMethodSpec.MethodSpecDesc desc = method.getDescriptor();
        TrackedMethod existingMethod = (TrackedMethod)this.methods.get((Object)desc);
        if (existingMethod != null) {
            if (existingMethod.type == TrackedMethod.Type.RESERVED) {
                throw new CustomClassFormatException("Method " + String.valueOf(desc) + " is reserved.");
            }
            if (existingMethod.owner == this.owner) {
                throw new CustomClassFormatException("Multiple methods named " + desc.name() + " in class " + String.valueOf(UnregisteredObjectException.getID(this.owner)) + " with parameters " + String.valueOf(desc.parameters()) + ": [" + String.valueOf(UnregisteredObjectException.getID(entry)) + ", " + String.valueOf(UnregisteredObjectException.getID(existingMethod.declaration)) + "]");
            }
            if (existingMethod.type != TrackedMethod.Type.CONSTRUCTOR) {
                throw new CustomClassFormatException("Method " + String.valueOf(UnregisteredObjectException.getID(entry)) + " in class " + String.valueOf(UnregisteredObjectException.getID(this.owner)) + " overrides method " + String.valueOf(UnregisteredObjectException.getID(existingMethod.declaration)) + " in class " + String.valueOf(UnregisteredObjectException.getID(existingMethod.owner)) + " but has a type of method/abstract. Abstract methods cannot (currently) override other methods.");
            }
        }
        this.checkPropertyConflicts(method);
        this.methods.put((Object)desc, (Object)new TrackedMethod(this.owner, entry, TrackedMethod.Type.ABSTRACT));
    }

    public void addOverrideMethod(OverrideMethodSpec method) throws CustomClassFormatException {
        class_6880<ElementSpec> entry = this.hierarchy.entryOf(method);
        BaseMethodSpec.MethodSpecDesc desc = method.getDescriptor();
        TrackedMethod existingMethod = (TrackedMethod)this.methods.get((Object)desc);
        if (existingMethod == null) {
            throw new CustomClassFormatException("Method " + String.valueOf(UnregisteredObjectException.getID(entry)) + " overrides " + String.valueOf(UnregisteredObjectException.getID(method.override)) + " but that method is not inherited by class " + String.valueOf(UnregisteredObjectException.getID(this.owner)));
        }
        if (existingMethod.type == TrackedMethod.Type.RESERVED) {
            throw new CustomClassFormatException("Method " + String.valueOf(desc) + " is reserved.");
        }
        if (existingMethod.owner == this.owner) {
            throw new CustomClassFormatException("Multiple methods named " + desc.name() + " in class " + String.valueOf(UnregisteredObjectException.getID(this.owner)) + " with parameters " + String.valueOf(desc.parameters()) + ": [" + String.valueOf(UnregisteredObjectException.getID(entry)) + ", " + String.valueOf(UnregisteredObjectException.getID(existingMethod.declaration)) + "]");
        }
        if (method.override != existingMethod.declaration) {
            throw new CustomClassFormatException("Method " + String.valueOf(UnregisteredObjectException.getID(entry)) + " overrides " + String.valueOf(UnregisteredObjectException.getID(method.override)) + " but that method is already overridden by " + String.valueOf(UnregisteredObjectException.getID(existingMethod.declaration)) + " in class " + String.valueOf(UnregisteredObjectException.getID(existingMethod.owner)));
        }
        this.checkPropertyConflicts(method);
        this.methods.put((Object)desc, (Object)new TrackedMethod(this.owner, entry, TrackedMethod.Type.NORMAL));
    }

    public record TrackedMethod(class_6880<ElementSpec> owner, class_6880<ElementSpec> declaration, Type type) {

        public static enum Type {
            NORMAL,
            ABSTRACT,
            CONSTRUCTOR,
            RESERVED;

        }
    }

    public record TrackedProperty(class_6880<ElementSpec> owner, class_6880<ElementSpec> declaration, Type type, boolean hasSetter) {

        public static enum Type {
            NORMAL,
            ABSTRACT;

        }
    }

    public record TrackedField(class_6880<ElementSpec> owner, class_6880<ElementSpec> declaration, Type type) {

        public static enum Type {
            NORMAL,
            RESERVED;

        }
    }
}

