/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.columns.scripted.classes;

import builderb0y.bigglobe.columns.scripted.ScriptedColumn;
import builderb0y.bigglobe.columns.scripted2.ConstructorInfo;
import builderb0y.bigglobe.math.BigGlobeMath;
import builderb0y.bigglobe.noise.Permuter;
import builderb0y.bigglobe.settings.VoronoiDiagram2D;
import builderb0y.bigglobe.util.Derivative2D;
import builderb0y.scripting.bytecode.FieldInfo;
import builderb0y.scripting.bytecode.MethodInfo;
import builderb0y.scripting.bytecode.tree.InsnTree;
import builderb0y.scripting.environments.MutableScriptEnvironment;
import builderb0y.scripting.util.InfoHolder;

public class VoronoiBase {
    public static final int SOFT_DISTANCE_SQUARED_INDEX = 0;
    public static final int SOFT_DISTANCE_INDEX = 1;
    public static final int HARD_DISTANCE_INDEX = 2;
    public static final int EUCLIDEAN_DISTANCE_INDEX = 3;
    public static final int CENTER_COLUMN_INDEX = 4;
    public static final Info INFO = new Info();
    public static final ConstructorInfo CONSTRUCTOR_INFO = new ConstructorInfo(VoronoiBase.class);
    public final VoronoiDiagram2D.Cell $cell;
    public ScriptedColumn column;
    public ScriptedColumn center_column;
    public int $flags;
    public final Derivative2D $softDistanceSquared = new Derivative2D();
    public final Derivative2D $softDistance = new Derivative2D();
    public double $hardDistance;
    public double $euclideanDistance;

    public VoronoiBase(ScriptedColumn column, VoronoiDiagram2D.Cell $cell) {
        this.column = column;
        this.$cell = $cell;
    }

    public long unsalted_seed() {
        VoronoiDiagram2D.SeedPoint seedPoint = this.$cell.center;
        return Permuter.permute(this.column.baseSeed(), seedPoint.cellX, seedPoint.cellZ);
    }

    public long salted_seed(long salt) {
        VoronoiDiagram2D.SeedPoint seedPoint = this.$cell.center;
        return Permuter.permute(this.column.baseSeed() ^ salt, seedPoint.cellX, seedPoint.cellZ);
    }

    public int cell_x() {
        return this.$cell.center.cellX;
    }

    public int cell_z() {
        return this.$cell.center.cellZ;
    }

    public int center_x() {
        return this.$cell.center.centerX;
    }

    public int center_z() {
        return this.$cell.center.centerZ;
    }

    public double soft_distance_squared() {
        this.$pre_compute_soft_distance_squared();
        return this.$softDistanceSquared.value;
    }

    public double dx_soft_distance_squared() {
        this.$pre_compute_soft_distance_squared();
        return this.$softDistanceSquared.dx;
    }

    public double dz_soft_distance_squared() {
        this.$pre_compute_soft_distance_squared();
        return this.$softDistanceSquared.dy;
    }

    public void $pre_compute_soft_distance_squared() {
        int oldFlags = this.$flags;
        int newFlags = oldFlags | 1;
        if (oldFlags != newFlags) {
            this.$flags = newFlags;
            this.$cell.derivativeProgressToEdgeSquaredD(this.$softDistanceSquared, this.column.x(), this.column.z());
        }
    }

    public double soft_distance() {
        this.$pre_compute_soft_distance();
        return this.$softDistance.value;
    }

    public double dx_soft_distance() {
        this.$pre_compute_soft_distance();
        return this.$softDistance.dx;
    }

    public double dz_soft_distance() {
        this.$pre_compute_soft_distance();
        return this.$softDistance.dy;
    }

    public void $pre_compute_soft_distance() {
        int oldFlags = this.$flags;
        int newFlags = oldFlags | 2;
        if (oldFlags != newFlags) {
            this.$flags = newFlags;
            this.$pre_compute_soft_distance_squared();
            this.$softDistance.set(this.$softDistanceSquared).sqrt();
        }
    }

    public double hard_distance() {
        this.$pre_compute_hard_distance();
        return this.$hardDistance;
    }

    public void $pre_compute_hard_distance() {
        int oldFlags = this.$flags;
        int newFlags = oldFlags | 4;
        if (oldFlags != newFlags) {
            this.$flags = newFlags;
            this.$hardDistance = this.$cell.hardProgressToEdgeD(this.column.x(), this.column.z());
        }
    }

    public double hard_distance_squared() {
        return BigGlobeMath.squareD(this.hard_distance());
    }

    public double euclidean_distance_squared() {
        return BigGlobeMath.squareD(this.column.x() - this.center_x(), this.column.z() - this.center_z());
    }

    public double euclidean_distance() {
        this.$pre_compute_euclidean_distance();
        return this.$euclideanDistance;
    }

    public void $pre_compute_euclidean_distance() {
        int oldFlags = this.$flags;
        int newFlags = oldFlags | 8;
        if (oldFlags != newFlags) {
            this.$flags = newFlags;
            this.$euclideanDistance = Math.sqrt(this.euclidean_distance_squared());
        }
    }

    public ScriptedColumn center_column() {
        this.$pre_compute_center_column();
        return this.center_column;
    }

    public void $pre_compute_center_column() {
        int oldFlags = this.$flags;
        int newFlags = oldFlags | 0x10;
        if (oldFlags != newFlags) {
            this.$flags = newFlags;
            this.center_column = this.column.blankCopy();
            this.center_column.setParamsUnchecked(this.center_column.params.at(this.center_x(), this.center_z()));
        }
    }

    public static class Info
    extends InfoHolder {
        public FieldInfo column;
        public FieldInfo $cell;
        public MethodInfo cell_x;
        public MethodInfo cell_z;
        public MethodInfo center_x;
        public MethodInfo center_z;
        public MethodInfo soft_distance_squared;
        public MethodInfo dx_soft_distance_squared;
        public MethodInfo dz_soft_distance_squared;
        public MethodInfo soft_distance;
        public MethodInfo dx_soft_distance;
        public MethodInfo dz_soft_distance;
        public MethodInfo hard_distance;
        public MethodInfo hard_distance_squared;
        public MethodInfo euclidean_distance;
        public MethodInfo euclidean_distance_squared;
        public MethodInfo unsalted_seed;
        public MethodInfo salted_seed;
        public MethodInfo center_column;

        public void setupInternalEnvironment(MutableScriptEnvironment environment, InsnTree loadVoronoi) {
            environment.addVariableInvoke(loadVoronoi, this.cell_x).addVariableInvoke(loadVoronoi, this.cell_z).addVariableInvoke(loadVoronoi, this.center_x).addVariableInvoke(loadVoronoi, this.center_z).addVariableInvoke(loadVoronoi, this.soft_distance_squared).addVariableInvoke(loadVoronoi, this.dx_soft_distance_squared).addVariableInvoke(loadVoronoi, this.dz_soft_distance_squared).addVariableInvoke(loadVoronoi, this.soft_distance).addVariableInvoke(loadVoronoi, this.dx_soft_distance).addVariableInvoke(loadVoronoi, this.dz_soft_distance).addVariableInvoke(loadVoronoi, this.hard_distance_squared).addVariableInvoke(loadVoronoi, this.hard_distance).addVariableInvoke(loadVoronoi, this.euclidean_distance_squared).addVariableInvoke(loadVoronoi, this.euclidean_distance);
        }

        public void setupExternalEnvironment(MutableScriptEnvironment environment) {
            environment.addFieldInvoke("cell_x", this.cell_x).addFieldInvoke("cell_z", this.cell_z).addFieldInvoke("center_x", this.center_x).addFieldInvoke("center_z", this.center_z).addFieldInvoke("soft_distance_squared", this.soft_distance_squared).addFieldInvoke("dx_soft_distance_squared", this.dx_soft_distance_squared).addFieldInvoke("dz_soft_distance_squared", this.dz_soft_distance_squared).addFieldInvoke("soft_distance", this.soft_distance).addFieldInvoke("dx_soft_distance", this.dx_soft_distance).addFieldInvoke("dz_soft_distance", this.dz_soft_distance).addFieldInvoke("hard_distance_squared", this.hard_distance_squared).addFieldInvoke("hard_distance", this.hard_distance).addFieldInvoke("euclidean_distance_squared", this.euclidean_distance_squared).addFieldInvoke("euclidean_distance", this.euclidean_distance);
        }
    }

    @FunctionalInterface
    public static interface Factory {
        public VoronoiBase create(ScriptedColumn var1, VoronoiDiagram2D.Cell var2);
    }
}

