/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.columns.scripted.types;

import builderb0y.autocodec.data.Data;
import builderb0y.bigglobe.columns.scripted.compile.ColumnCompileContext;
import builderb0y.bigglobe.columns.scripted.types.ColumnValueType;
import builderb0y.scripting.bytecode.InsnTrees;
import builderb0y.scripting.bytecode.TypeInfo;
import builderb0y.scripting.bytecode.tree.InsnTree;

public abstract class AbstractColumnValueType
implements ColumnValueType {
    public abstract TypeInfo getTypeInfo();

    @Override
    public ColumnValueType.TypeContext createType(ColumnCompileContext context) {
        return new ColumnValueType.TypeContext(this.getTypeInfo(), null);
    }

    public static <T> T requireNonNull(T value, Data data, String type) {
        if (value != null) {
            return value;
        }
        throw new IllegalStateException("Not a " + type + ": " + String.valueOf(data));
    }

    @Override
    public InsnTree createConstant(Data data, ColumnCompileContext context) {
        if (data.isEmpty()) {
            return InsnTrees.ldc(null, this.getTypeInfo());
        }
        return switch (this.getTypeInfo().getSort()) {
            default -> throw new IncompatibleClassChangeError();
            case TypeInfo.Sort.VOID -> throw new IllegalStateException("Attempting to create void constant");
            case TypeInfo.Sort.BOOLEAN -> InsnTrees.ldc(AbstractColumnValueType.requireNonNull(data.tryAsBoolean(), (Data)data, (String)"boolean").value);
            case TypeInfo.Sort.BYTE -> InsnTrees.ldc(AbstractColumnValueType.requireNonNull(data.tryAsNumber(), data, "byte").byteValue());
            case TypeInfo.Sort.CHAR -> InsnTrees.ldc(AbstractColumnValueType.requireNonNull(data.tryAsString(), (Data)data, (String)"char").value.charAt(0));
            case TypeInfo.Sort.SHORT -> InsnTrees.ldc(AbstractColumnValueType.requireNonNull(data.tryAsNumber(), data, "short").shortValue());
            case TypeInfo.Sort.INT -> InsnTrees.ldc(AbstractColumnValueType.requireNonNull(data.tryAsNumber(), data, "int").intValue());
            case TypeInfo.Sort.LONG -> InsnTrees.ldc(AbstractColumnValueType.requireNonNull(data.tryAsNumber(), data, "long").longValue());
            case TypeInfo.Sort.FLOAT -> InsnTrees.ldc(AbstractColumnValueType.requireNonNull(data.tryAsNumber(), data, "float").floatValue());
            case TypeInfo.Sort.DOUBLE -> InsnTrees.ldc(AbstractColumnValueType.requireNonNull(data.tryAsNumber(), data, "double").doubleValue());
            case TypeInfo.Sort.OBJECT, TypeInfo.Sort.ARRAY -> throw new IllegalStateException("Sub-classes must implement handling for type " + String.valueOf(this.getTypeInfo()));
        };
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public int hashCode() {
        return this.getTypeInfo().hashCode() ^ this.getClass().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj != null && obj.getClass() == this.getClass() && ((AbstractColumnValueType)obj).getTypeInfo().equals(this.getTypeInfo());
    }
}

