/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.compat;

import builderb0y.autocodec.util.AutoCodecUtil;
import builderb0y.bigglobe.BigGlobeMod;
import builderb0y.bigglobe.chunkgen.BigGlobeScriptedChunkGenerator;
import builderb0y.bigglobe.compat.InstalledMods;
import builderb0y.bigglobe.compat.dhChunkGen.DhScriptedWorldGenerator;
import builderb0y.bigglobe.config.BigGlobeConfig;
import com.seibel.distanthorizons.api.DhApi;
import com.seibel.distanthorizons.api.interfaces.block.IDhApiBiomeWrapper;
import com.seibel.distanthorizons.api.interfaces.block.IDhApiBlockStateWrapper;
import com.seibel.distanthorizons.api.interfaces.override.worldGenerator.IDhApiWorldGenerator;
import com.seibel.distanthorizons.api.interfaces.world.IDhApiLevelWrapper;
import com.seibel.distanthorizons.api.methods.events.DhApiEventRegister;
import com.seibel.distanthorizons.api.methods.events.abstractEvents.DhApiLevelLoadEvent;
import com.seibel.distanthorizons.api.methods.events.interfaces.IDhApiEvent;
import com.seibel.distanthorizons.api.methods.events.sharedParameterObjects.DhApiEventParam;
import com.seibel.distanthorizons.api.objects.data.DhApiChunk;
import com.seibel.distanthorizons.api.objects.data.DhApiTerrainDataPoint;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import net.minecraft.class_2794;
import net.minecraft.class_3218;

public class DistantHorizonsCompat {
    public static final MethodHandle isOnDistantHorizonThread;

    public static boolean isOnDistantHorizonThread() {
        try {
            return isOnDistantHorizonThread.invokeExact();
        }
        catch (Throwable throwable) {
            throw AutoCodecUtil.rethrow((Throwable)throwable);
        }
    }

    public static void init() {
        if (InstalledMods.DISTANT_HORIZONS) {
            try {
                DHCode.init();
            }
            catch (LinkageError error) {
                BigGlobeMod.LOGGER.error("Failed to setup Distant Horizons integration: ", (Throwable)error);
            }
        }
    }

    static {
        MethodHandle handle;
        try {
            Class<?> api = Class.forName("com.seibel.distanthorizons.api.DhApi");
            handle = MethodHandles.lookup().findStatic(api, "isDhThread", MethodType.methodType(Boolean.TYPE));
            BigGlobeMod.LOGGER.info("Distant horizons API compatibility enabled.");
        }
        catch (Exception api) {
            try {
                Class<?> environment = Class.forName("loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.worldGeneration.BatchGenerationEnvironment", false, DistantHorizonsCompat.class.getClassLoader());
                handle = MethodHandles.lookup().findStatic(environment, "isCurrentThreadDistantGeneratorThread", MethodType.methodType(Boolean.TYPE));
                BigGlobeMod.LOGGER.info("Distant horizons 2.0 compatibility enabled.");
            }
            catch (Exception environment) {
                try {
                    Class<?> environment2 = Class.forName("fabric.com.seibel.lod.common.wrappers.worldGeneration.BatchGenerationEnvironment", false, DistantHorizonsCompat.class.getClassLoader());
                    handle = MethodHandles.lookup().findStatic(environment2, "isCurrentThreadDistantGeneratorThread", MethodType.methodType(Boolean.TYPE));
                    BigGlobeMod.LOGGER.info("Distant horizons 1.6 compatibility enabled.");
                }
                catch (Exception exception) {
                    BigGlobeMod.LOGGER.info("Distant horizons compatibility disabled.");
                    handle = MethodHandles.constant(Boolean.TYPE, Boolean.FALSE);
                }
            }
        }
        isOnDistantHorizonThread = handle;
    }

    public static class DHCode {
        public static DhApiChunk newChunk(int chunkX, int chunkZ, int minY, int maxY) {
            return DhApiChunk.create((int)chunkX, (int)chunkZ, (int)minY, (int)maxY);
        }

        public static DhApiTerrainDataPoint newDataPoint(byte detailLevel, int blockLight, int skyLight, int minY, int maxY, IDhApiBlockStateWrapper state, IDhApiBiomeWrapper biome) {
            return DhApiTerrainDataPoint.create((byte)detailLevel, (int)blockLight, (int)skyLight, (int)minY, (int)maxY, (IDhApiBlockStateWrapper)state, (IDhApiBiomeWrapper)biome);
        }

        public static void init() {
            DhApiEventRegister.on(DhApiLevelLoadEvent.class, (IDhApiEvent)new DhApiLevelLoadEvent(){

                public void onLevelLoad(DhApiEventParam<DhApiLevelLoadEvent.EventParam> param) {
                    class_3218 serverWorld;
                    class_2794 class_27942;
                    IDhApiLevelWrapper levelWrapper = ((DhApiLevelLoadEvent.EventParam)param.value).levelWrapper;
                    Object object = levelWrapper.getWrappedMcObject();
                    if (object instanceof class_3218 && (class_27942 = (serverWorld = (class_3218)object).method_14178().method_12129()) instanceof BigGlobeScriptedChunkGenerator) {
                        BigGlobeScriptedChunkGenerator generator = (BigGlobeScriptedChunkGenerator)class_27942;
                        if (BigGlobeConfig.INSTANCE.get().distantHorizonsIntegration.hyperspeedGeneration) {
                            DhApi.worldGenOverrides.registerWorldGeneratorOverride(levelWrapper, (IDhApiWorldGenerator)new DhScriptedWorldGenerator(levelWrapper, serverWorld, generator));
                        } else {
                            BigGlobeMod.LOGGER.info("Not using hyperspeed DH world generator, as it is disabled in Big Globe's config file.");
                        }
                    }
                }
            });
        }

        static {
            DhApiChunk.create((int)0, (int)0, (int)0, (int)128);
            DhApiTerrainDataPoint.create((byte)0, (int)0, (int)0, (int)0, (int)128, null, null);
        }
    }
}

