/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.dynamicRegistries;

import builderb0y.bigglobe.util.UnregisteredObjectException;
import builderb0y.bigglobe.versions.IdentifierVersions;
import builderb0y.bigglobe.versions.RegistryVersions;
import java.util.stream.Stream;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7225;
import net.minecraft.class_7871;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface BetterRegistry<T> {
    public class_5321<class_2378<T>> getKey();

    @Nullable
    public class_6880<T> getEntry(class_5321<T> var1);

    @NotNull
    default public class_6880<T> requireEntry(class_5321<T> key) {
        class_6880<T> entry = this.getEntry(key);
        if (entry != null) {
            return entry;
        }
        StringBuilder message = new StringBuilder(128).append("Key ").append(key.method_29177()).append(" not present in registry ").append(this.getKey().method_29177()).append('.');
        if (this.getTag(class_6862.method_40092(RegistryVersions.getRegistryKey(key), (class_2960)key.method_29177()), false) != null) {
            message.append(" Note: a tag with this name exists. Did you forget to prefix the name with '#'?");
        }
        throw new IllegalStateException(message.toString());
    }

    @Nullable
    public class_6885<T> getTag(class_6862<T> var1, boolean var2);

    @NotNull
    default public class_6885<T> requireTag(class_6862<T> key) {
        class_6885<T> tag = this.getTag(key, true);
        if (tag != null) {
            return tag;
        }
        StringBuilder message = new StringBuilder().append("Tag ").append(key.comp_327()).append(" not present in registry ").append(this.getKey().method_29177()).append('.');
        if (this.getEntry(class_5321.method_29179(RegistryVersions.getRegistryKey(key), (class_2960)key.comp_327())) != null) {
            message.append(" Note: an entry with this name exists. Did you prefix the name with '#' by mistake?");
        }
        throw new NullPointerException(message.toString());
    }

    public Stream<class_6880<T>> streamEntries();

    public Stream<class_6885<T>> streamTags();

    default public class_6880<T> requireById(class_2960 id) {
        return this.requireEntry(class_5321.method_29179(this.getKey(), (class_2960)id));
    }

    default public class_6880<T> requireByName(String name) {
        return this.requireById(IdentifierVersions.create(name));
    }

    default public class_6880<T> getById(class_2960 id) {
        return this.getEntry(class_5321.method_29179(this.getKey(), (class_2960)id));
    }

    default public class_6880<T> getByName(String name) {
        return this.getById(IdentifierVersions.create(name));
    }

    default public Iterable<class_6880<T>> entries() {
        return this.streamEntries()::iterator;
    }

    default public Iterable<class_5321<T>> keys() {
        return this.streamEntries().map(UnregisteredObjectException::getKey)::iterator;
    }

    default public Iterable<T> values() {
        return this.streamEntries().map(class_6880::comp_349)::iterator;
    }

    public static <T> Stream<T> castStream(Stream<? extends T> stream) {
        return stream;
    }

    public static interface Lookup {
        public <T> BetterRegistry<T> getRegistry(class_5321<class_2378<T>> var1);
    }

    public static class BetterDynamicRegistry<T>
    implements BetterRegistry<T> {
        public final class_7225.class_7226<T> wrapperImpl;
        public final class_7871<T> lookup;

        public BetterDynamicRegistry(class_7225.class_7226<T> wrapperImpl, class_7871<T> lookup) {
            this.wrapperImpl = wrapperImpl;
            this.lookup = lookup;
        }

        @Override
        public class_5321<class_2378<T>> getKey() {
            return RegistryVersions.getRegistryKey(this.wrapperImpl);
        }

        @Override
        public class_6880<T> getEntry(class_5321<T> key) {
            return this.lookup.method_46746(key).orElse(null);
        }

        @Override
        public class_6885<T> getTag(class_6862<T> key, boolean create) {
            return (create ? this.lookup : this.wrapperImpl).method_46733(key).orElse(null);
        }

        @Override
        public Stream<class_6880<T>> streamEntries() {
            return BetterRegistry.castStream(this.wrapperImpl.method_42017());
        }

        @Override
        public Stream<class_6885<T>> streamTags() {
            return BetterRegistry.castStream(this.wrapperImpl.method_42020());
        }
    }

    public static class BetterHardCodedRegistry<T>
    implements BetterRegistry<T> {
        public final class_2378<T> registry;

        public BetterHardCodedRegistry(class_2378<T> registry) {
            this.registry = registry;
        }

        @Override
        public class_5321<class_2378<T>> getKey() {
            return RegistryVersions.getRegistryKey(this.registry);
        }

        @Override
        public class_6880<T> getEntry(class_5321<T> key) {
            return this.registry.method_46746(key).orElse(null);
        }

        @Override
        public class_6885<T> getTag(class_6862<T> key, boolean create) {
            return this.registry.method_46733(key).orElse(null);
        }

        @Override
        public Stream<class_6880<T>> streamEntries() {
            return BetterRegistry.castStream(this.registry.method_42017());
        }

        @Override
        public Stream<class_6885<T>> streamTags() {
            return BetterRegistry.castStream(this.registry.method_40272());
        }
    }
}

