/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.features;

import builderb0y.autocodec.util.TypeFormatter;
import builderb0y.bigglobe.blocks.BlockStates;
import builderb0y.bigglobe.features.BlockQueueStructureWorldAccess;
import builderb0y.bigglobe.versions.BlockEntityVersions;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Map;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_5281;
import org.jetbrains.annotations.Debug;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Debug.Renderer(hasChildren="true", childrenArray="this.intellij_childrenArray()")
public class BlockQueue {
    public Long2ObjectLinkedOpenHashMap<class_2680> queuedBlocks = new Long2ObjectLinkedOpenHashMap(1024);
    public Long2ObjectLinkedOpenHashMap<class_2586> queuedBlockEntities = new Long2ObjectLinkedOpenHashMap(0);
    public int flags;

    public BlockQueue(int flags) {
        this.flags = flags;
    }

    public BlockQueue(boolean causeBlockUpdates) {
        this.flags = causeBlockUpdates ? 3 : 18;
    }

    public BlockQueueStructureWorldAccess createWorld(class_5281 world) {
        return new BlockQueueStructureWorldAccess(world, this);
    }

    public void queueBlock(class_2338 pos, class_2680 state) {
        this.queueBlock(pos.method_10063(), state);
    }

    public void queueBlock(long pos, class_2680 state) {
        this.queuedBlocks.put(pos, (Object)state);
        if (state.method_31709()) {
            class_2586 blockEntity = ((class_2343)state.method_26204()).method_10123(class_2338.method_10092((long)pos), state);
            if (blockEntity != null) {
                this.queueBlockEntity(pos, blockEntity);
            }
        } else {
            this.queuedBlockEntities.remove(pos);
        }
    }

    public void queueReplacement(class_2338 pos, class_2680 from, class_2680 to) {
        this.queueReplacement(pos.method_10063(), from, to);
    }

    public void queueReplacement(long pos, class_2680 from, class_2680 to) {
        this.queueBlock(pos, to);
    }

    public void queueBlockEntity(long pos, class_2586 blockEntity) {
        this.queuedBlockEntities.put(pos, (Object)blockEntity);
    }

    public void queueBlockEntity(class_2338 pos, class_2586 blockEntity) {
        this.queueBlockEntity(pos.method_10063(), blockEntity);
    }

    @Nullable
    public class_2586 getBlockEntity(class_2338 pos) {
        return this.getBlockEntity(pos.method_10063());
    }

    @Nullable
    public class_2586 getBlockEntity(long pos) {
        return (class_2586)this.queuedBlockEntities.get(pos);
    }

    public void placeQueuedBlocks(class_1936 world) {
        if (!this.queuedBlocks.isEmpty()) {
            Long2ObjectMap.Entry entry;
            class_2338.class_2339 pos = new class_2338.class_2339();
            ObjectBidirectionalIterator iterator = this.queuedBlocks.long2ObjectEntrySet().fastIterator();
            while (iterator.hasNext()) {
                entry = (Long2ObjectMap.Entry)iterator.next();
                world.method_8652((class_2338)pos.method_16363(entry.getLongKey()), (class_2680)entry.getValue(), this.flags);
            }
            if (!this.queuedBlockEntities.isEmpty()) {
                iterator = this.queuedBlockEntities.long2ObjectEntrySet().fastIterator();
                while (iterator.hasNext()) {
                    entry = (Long2ObjectMap.Entry)iterator.next();
                    class_2586 worldBlockEntity = world.method_8321((class_2338)pos.method_16363(entry.getLongKey()));
                    if (worldBlockEntity == null) continue;
                    class_2586 queuedBlockEntity = (class_2586)entry.getValue();
                    BlockEntityVersions.readFromNbt(worldBlockEntity, BlockEntityVersions.writeToNbt(queuedBlockEntity));
                }
            }
        }
    }

    public int blockCount() {
        return this.queuedBlocks.size();
    }

    public class_2680 getBlockStateOrNull(class_2338 pos) {
        return (class_2680)this.queuedBlocks.get(pos.method_10063());
    }

    public class_2680 getBlockState(class_2338 pos) {
        class_2680 state = (class_2680)this.queuedBlocks.get(pos.method_10063());
        return state != null ? state : BlockStates.AIR;
    }

    public class_2680 getBlockState(class_2338 pos, class_1922 fallback) {
        class_2680 state = (class_2680)this.queuedBlocks.get(pos.method_10063());
        return state != null ? state : fallback.method_8320(pos);
    }

    public String toString() {
        return ((StringBuilder)TypeFormatter.appendSimpleClassUnchecked((Appendable)new StringBuilder(32), this.getClass())).append(": { flags: ").append(this.flags).append(", size: ").append(this.queuedBlocks.size()).append(" }").toString();
    }

    @TestOnly
    public Object[] intellij_childrenArray() {
        return new Object[]{Map.entry("flags", this.flags), Map.entry("queuedBlocks", BlockQueue.intellij_decodePositions(this.queuedBlocks)), Map.entry("queuedBlockEntities", BlockQueue.intellij_decodePositions(this.queuedBlockEntities))};
    }

    public static <T> Object intellij_decodePositions(Long2ObjectMap<T> map) {
        if (map == null) {
            return "null";
        }
        int size = map.size();
        QueuedObject[] blocks = new QueuedObject[size];
        int index = 0;
        ObjectIterator iterator = Long2ObjectMaps.fastIterator(map);
        while (iterator.hasNext()) {
            Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)iterator.next();
            blocks[index++] = new QueuedObject<Object>(entry.getLongKey(), entry.getValue());
        }
        assert (index == blocks.length);
        return blocks;
    }

    public record QueuedObject<T>(int x, int y, int z, long packed, T object) {
        public QueuedObject(long packed, T object) {
            this(class_2338.method_10061((long)packed), class_2338.method_10071((long)packed), class_2338.method_10083((long)packed), packed, object);
        }

        public QueuedObject(int x, int y, int z, T state) {
            this(x, y, z, class_2338.method_10064((int)x, (int)y, (int)z), state);
        }
    }
}

