/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.features;

import builderb0y.autocodec.annotations.VerifyFloatRange;
import builderb0y.autocodec.annotations.VerifyNullable;
import builderb0y.bigglobe.chunkgen.BigGlobeScriptedChunkGenerator;
import builderb0y.bigglobe.codecs.BigGlobeAutoCodec;
import builderb0y.bigglobe.columns.restrictions.ColumnRestriction;
import builderb0y.bigglobe.columns.scripted.ScriptedColumn;
import builderb0y.bigglobe.features.SingleBlockFeature;
import builderb0y.bigglobe.math.BigGlobeMath;
import builderb0y.bigglobe.noise.Permuter;
import builderb0y.bigglobe.randomLists.DelegatingContainedRandomList;
import builderb0y.bigglobe.randomLists.IRestrictedListElement;
import builderb0y.bigglobe.randomSources.RandomRangeVerifier;
import builderb0y.bigglobe.randomSources.RandomSource;
import builderb0y.bigglobe.settings.VariationsList;
import builderb0y.bigglobe.versions.BlockStateVersions;
import com.mojang.serialization.Codec;
import java.util.random.RandomGenerator;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_3031;
import net.minecraft.class_3037;
import net.minecraft.class_5539;
import net.minecraft.class_5821;

public class NetherFlowerFeature
extends class_3031<Config> {
    public NetherFlowerFeature(Codec<Config> configCodec) {
        super(configCodec);
    }

    public NetherFlowerFeature() {
        this((Codec<Config>)BigGlobeAutoCodec.AUTO_CODEC.createDFUCodec(Config.class));
    }

    public boolean method_13151(class_5821<Config> context) {
        if (((Config)context.method_33656()).requiresColumn && !(context.method_33653() instanceof BigGlobeScriptedChunkGenerator)) {
            return false;
        }
        ScriptedColumn column = ((Config)context.method_33656()).requiresColumn ? ((BigGlobeScriptedChunkGenerator)context.method_33653()).newColumn((class_5539)context.method_33652(), context.method_33655().method_10263(), context.method_33655().method_10260(), ScriptedColumn.ColumnUsage.FEATURES.maybeDhHints()) : null;
        class_2338.class_2339 mutablePos = new class_2338.class_2339();
        Permuter permuter = Permuter.from(context.method_33654());
        DelegatingContainedRandomList entries = new DelegatingContainedRandomList(((Config)context.method_33656()).entries.elements);
        if (Permuter.nextChancedBoolean((RandomGenerator)permuter, ((Config)context.method_33656()).randomize_chance)) {
            double radius = ((Config)context.method_33656()).randomize_radius.get(column, context.method_33655().method_10264(), permuter);
            int count = Permuter.roundRandomlyI((RandomGenerator)permuter, radius * radius * 0.25);
            for (int attempt = 0; attempt < count; ++attempt) {
                Entry entry = (Entry)entries.getRandomElement(permuter);
                this.generate(context, permuter, entry, radius, mutablePos);
            }
        } else {
            Entry entry = (Entry)entries.getRandomElement(permuter);
            double radius = entry.radius.get(column, context.method_33655().method_10264(), permuter);
            int count = Permuter.roundRandomlyI((RandomGenerator)permuter, radius * radius * 0.25);
            for (int attempt = 0; attempt < count; ++attempt) {
                this.generate(context, permuter, entry, radius, mutablePos);
            }
        }
        return true;
    }

    public void generate(class_5821<Config> context, Permuter permuter, Entry entry, double radius, class_2338.class_2339 mutablePos) {
        double r = permuter.nextDouble(radius);
        double theta = permuter.nextDouble(Math.PI * 2);
        double x = Math.cos(theta) * r + (double)context.method_33655().method_10263() + 0.5;
        double z = Math.sin(theta) * r + (double)context.method_33655().method_10260() + 0.5;
        mutablePos.method_10103(BigGlobeMath.floorI(x), context.method_33655().method_10264(), BigGlobeMath.floorI(z));
        class_2791 chunk = context.method_33652().method_22350((class_2338)mutablePos);
        while (BlockStateVersions.isReplaceable(chunk.method_8320((class_2338)mutablePos))) {
            mutablePos.method_33098(mutablePos.method_10264() - 1);
            if (!(r * r + BigGlobeMath.squareD(mutablePos.method_10264() - context.method_33655().method_10264()) > radius * radius)) continue;
            return;
        }
        while (!BlockStateVersions.isReplaceable(chunk.method_8320((class_2338)mutablePos))) {
            mutablePos.method_33098(mutablePos.method_10264() + 1);
            if (!(r * r + BigGlobeMath.squareD(mutablePos.method_10264() - context.method_33655().method_10264()) > radius * radius)) continue;
            return;
        }
        if (entry.under != null) {
            mutablePos.method_33098(mutablePos.method_10264() - 1);
            class_2680 revert = chunk.method_8320((class_2338)mutablePos);
            if (SingleBlockFeature.place((class_1936)context.method_33652(), (class_2338)mutablePos, permuter, entry.under)) {
                mutablePos.method_33098(mutablePos.method_10264() + 1);
                if (!SingleBlockFeature.place((class_1936)context.method_33652(), (class_2338)mutablePos, permuter, entry.state)) {
                    mutablePos.method_33098(mutablePos.method_10264() - 1);
                    context.method_33652().method_8652((class_2338)mutablePos, revert, 3);
                }
            }
        } else {
            SingleBlockFeature.place((class_1936)context.method_33652(), (class_2338)mutablePos, permuter, entry.state);
        }
    }

    public static class Config
    implements class_3037 {
        public final @VerifyFloatRange(min=0.0, max=1.0) double randomize_chance;
        public final @RandomRangeVerifier.VerifyRandomRange(min=0.0, minInclusive=false, max=16.0) RandomSource randomize_radius;
        public final VariationsList<Entry> entries;
        public final boolean requiresColumn;

        public Config(double randomize_chance, RandomSource randomize_radius, VariationsList<Entry> entries) {
            this.randomize_chance = randomize_chance;
            this.randomize_radius = randomize_radius;
            this.entries = entries;
            this.requiresColumn = this.requiresColumn();
        }

        public boolean requiresColumn() {
            if (this.randomize_radius.requiresColumn()) {
                return true;
            }
            for (Entry entry : this.entries.elements) {
                if (!entry.radius.requiresColumn()) continue;
                return true;
            }
            return false;
        }
    }

    public static class Entry
    implements IRestrictedListElement {
        public final double weight;
        public final ColumnRestriction restrictions;
        public final @RandomRangeVerifier.VerifyRandomRange(min=0.0, minInclusive=false, max=16.0) RandomSource radius;
        public final SingleBlockFeature.Config state;
        public final @VerifyNullable SingleBlockFeature.Config under;

        public Entry(double weight, ColumnRestriction restrictions, RandomSource radius, SingleBlockFeature.Config state, @VerifyNullable SingleBlockFeature.Config under) {
            this.weight = weight;
            this.restrictions = restrictions;
            this.radius = radius;
            this.state = state;
            this.under = under;
        }

        @Override
        public double getWeight() {
            return this.weight;
        }

        @Override
        public ColumnRestriction getRestrictions() {
            return this.restrictions;
        }
    }
}

