/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.features;

import builderb0y.autocodec.annotations.VerifyFloatRange;
import builderb0y.bigglobe.chunkgen.BigGlobeScriptedChunkGenerator;
import builderb0y.bigglobe.chunkgen.SectionGenerationContext;
import builderb0y.bigglobe.chunkgen.perSection.PaletteIdReplacer;
import builderb0y.bigglobe.codecs.BigGlobeAutoCodec;
import builderb0y.bigglobe.codecs.BlockStateCoder;
import builderb0y.bigglobe.columns.restrictions.ColumnRestriction;
import builderb0y.bigglobe.features.DummyFeature;
import builderb0y.bigglobe.features.RockReplacerFeature;
import builderb0y.bigglobe.math.BigGlobeMath;
import builderb0y.bigglobe.noise.Grid2D;
import builderb0y.bigglobe.noise.NumberArray;
import builderb0y.bigglobe.noise.Permuter;
import builderb0y.bigglobe.randomLists.DelegatingContainedRandomList;
import builderb0y.bigglobe.randomLists.IWeightedListElement;
import builderb0y.bigglobe.scripting.wrappers.WorldWrapper;
import builderb0y.bigglobe.settings.Seed;
import builderb0y.bigglobe.settings.VariationsList;
import builderb0y.bigglobe.util.Async;
import builderb0y.bigglobe.util.BigGlobeThreadPool;
import builderb0y.bigglobe.util.BlockState2ObjectMap;
import com.mojang.serialization.Codec;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2826;
import net.minecraft.class_6490;

public class RockLayerFeature
extends DummyFeature<Config>
implements RockReplacerFeature<Config> {
    public RockLayerFeature(Codec<Config> codec) {
        super(codec);
    }

    public RockLayerFeature() {
        this((Codec<Config>)BigGlobeAutoCodec.AUTO_CODEC.createDFUCodec(Config.class));
    }

    @Override
    public void replaceRocks(BigGlobeScriptedChunkGenerator generator, WorldWrapper worldWrapper, class_2791 chunk, int minSection, int maxSection, Config config) {
        int totalSections = maxSection - minSection;
        int threads = Math.min(Runtime.getRuntime().availableProcessors(), totalSections);
        int sectionsPerThread = (totalSections + threads - 1) / threads;
        DelegatingContainedRandomList.RandomAccessDelegatingContainedRandomList entries = new DelegatingContainedRandomList.RandomAccessDelegatingContainedRandomList(config.entries.elements);
        Async.loop(BigGlobeThreadPool.autoExecutor(), threads, thread -> {
            try (NumberArray centerSamples = NumberArray.allocateDoublesDirect(16);
                 NumberArray thicknessSamples = NumberArray.allocateDoublesDirect(16);
                 NumberArray columnMinYs = NumberArray.allocateIntsDirect(256);
                 NumberArray columnMaxYs = NumberArray.allocateIntsDirect(256);){
                long configSeed = config.seed.xor(generator.columnSeed);
                int startX = chunk.method_12004().method_8326();
                int startZ = chunk.method_12004().method_8328();
                int startSection = sectionsPerThread * thread + minSection;
                int endSection = Math.min(sectionsPerThread * (thread + 1) + minSection, maxSection);
                int minThreadY = startSection << 4;
                int maxThreadY = endSection << 4;
                int minLayer = BigGlobeMath.ceilI(((double)minThreadY - config.maxWindow) / config.repeat);
                int maxLayer = BigGlobeMath.floorI(((double)maxThreadY - config.minWindow) / config.repeat);
                for (int layer = minLayer; layer <= maxLayer; ++layer) {
                    long layerSeed = Permuter.permute(configSeed, layer);
                    Entry entry = (Entry)entries.getRandomElement(layerSeed);
                    double averageCenter = (double)layer * config.repeat;
                    int layerMinY = Integer.MAX_VALUE;
                    int layerMaxY = Integer.MIN_VALUE;
                    for (int relativeZ = 0; relativeZ < 16; ++relativeZ) {
                        entry.center().getBulkX(layerSeed, startX, startZ | relativeZ, centerSamples);
                        entry.thickness().getBulkX(layerSeed, startX, startZ | relativeZ, thicknessSamples);
                        for (int relativeX = 0; relativeX < 16; ++relativeX) {
                            int index = relativeZ << 4 | relativeX;
                            double center = centerSamples.implGetD(relativeX) + averageCenter;
                            double thickness = thicknessSamples.implGetD(relativeX) - (1.0 - entry.restrictions().getRestriction(worldWrapper.lookupColumn(startX | relativeX, startZ | relativeZ), BigGlobeMath.floorI(center))) * entry.thickness().maxValue();
                            columnMinYs.setI(index, BigGlobeMath.floorI(center - thickness));
                            columnMaxYs.setI(index, BigGlobeMath.floorI(center + thickness));
                            layerMinY = Math.min(layerMinY, columnMinYs.implGetI(index));
                            layerMaxY = Math.max(layerMaxY, columnMaxYs.implGetI(index));
                        }
                    }
                    if (layerMaxY < layerMinY) continue;
                    int layerSectionMinY = Math.max(layerMinY >> 4, startSection);
                    int layerSectionMaxY = Math.min(layerMaxY >> 4, endSection - 1);
                    for (int layerSectionY = layerSectionMinY; layerSectionY <= layerSectionMaxY; ++layerSectionY) {
                        class_2826 section = chunk.method_38259(chunk.method_31603(layerSectionY));
                        SectionGenerationContext context = SectionGenerationContext.forSectionCoord(chunk, section, layerSectionY);
                        PaletteIdReplacer replacer = entry.getReplacer(context);
                        if (replacer == null) continue;
                        class_6490 storage = context.storage();
                        int sectionMinY = context.startY();
                        int sectionMaxY = sectionMinY | 0xF;
                        for (int horizontalIndex = 0; horizontalIndex < 256; ++horizontalIndex) {
                            int columnMinY = Math.max(columnMinYs.implGetI(horizontalIndex), sectionMinY);
                            int columnMaxY = Math.min(columnMaxYs.implGetI(horizontalIndex), sectionMaxY);
                            for (int columnY = columnMinY; columnY <= columnMaxY; ++columnY) {
                                int newID;
                                int relativeY = columnY & 0xF;
                                int index = relativeY << 8 | horizontalIndex;
                                int oldID = storage.method_15211(index);
                                if (oldID == (newID = replacer.getReplacement(oldID))) continue;
                                storage.method_15210(index, newID);
                            }
                        }
                    }
                }
            }
        });
    }

    public static class Config
    extends DummyFeature.DummyConfig {
        public final @Seed.SeedModes(value=6) Seed seed;
        public final @VerifyFloatRange(min=0.0, minInclusive=false) double repeat;
        public final VariationsList<Entry> entries;
        public final transient double minWindow;
        public final transient double maxWindow;

        public Config(Seed seed, double repeat, VariationsList<Entry> entries) {
            this.seed = seed;
            this.repeat = repeat;
            this.entries = entries;
            this.minWindow = entries.elements.stream().mapToDouble(entry -> entry.center.minValue() - entry.thickness.maxValue()).min().orElse(0.0);
            this.maxWindow = entries.elements.stream().mapToDouble(entry -> entry.center.maxValue() + entry.thickness.maxValue()).max().orElse(0.0);
        }
    }

    public record Entry(double weight, Grid2D center, Grid2D thickness, BlockState2ObjectMap<@BlockStateCoder.VerifyNormal class_2680> blocks, ColumnRestriction restrictions) implements IWeightedListElement
    {
        @Override
        public double getWeight() {
            return this.weight;
        }

        public PaletteIdReplacer getReplacer(SectionGenerationContext context) {
            return PaletteIdReplacer.of(context, this.blocks);
        }
    }
}

