/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.features;

import builderb0y.autocodec.annotations.MemberUsage;
import builderb0y.autocodec.annotations.SingletonArray;
import builderb0y.autocodec.annotations.UseCoder;
import builderb0y.autocodec.annotations.VerifyNotEmpty;
import builderb0y.autocodec.annotations.VerifyNullable;
import builderb0y.autocodec.coders.AutoCoder;
import builderb0y.autocodec.coders.EncoderDecoderCoder;
import builderb0y.autocodec.coders.RecordCoder;
import builderb0y.autocodec.common.FactoryContext;
import builderb0y.autocodec.data.Data;
import builderb0y.autocodec.data.EmptyData;
import builderb0y.autocodec.decoders.DecodeContext;
import builderb0y.autocodec.decoders.DecodeException;
import builderb0y.autocodec.encoders.EncodeContext;
import builderb0y.autocodec.encoders.EncodeException;
import builderb0y.autocodec.reflection.reification.ReifiedType;
import builderb0y.bigglobe.blocks.BlockStates;
import builderb0y.bigglobe.codecs.BigGlobeAutoCodec;
import builderb0y.bigglobe.features.RawFeature;
import builderb0y.bigglobe.mixins.PlantBlock_CanPlantOnTopAccess;
import builderb0y.bigglobe.noise.Permuter;
import builderb0y.bigglobe.scripting.wrappers.WorldWrapper;
import builderb0y.bigglobe.util.WorldOrChunk;
import builderb0y.bigglobe.versions.BlockStateVersions;
import builderb0y.bigglobe.versions.ChunkVersions;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.random.RandomGenerator;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_2791;
import net.minecraft.class_3031;
import net.minecraft.class_3037;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SingleBlockFeature
extends class_3031<Config>
implements RawFeature<Config> {
    public static final Predicate<class_2680> IS_REPLACEABLE = BlockStateVersions::isReplaceable;
    public static final Predicate<class_2680> NOT_REPLACEABLE = state -> !BlockStateVersions.isReplaceable(state);
    public static final Predicate<class_2680> IS_AIR = class_4970.class_4971::method_26215;
    public static final Predicate<class_2680> IS_SOURCE_WATER = state -> state == BlockStates.WATER;
    public static final Predicate<class_2680> HAS_WATER = state -> state.method_26227().method_15772() == class_3612.field_15910;
    public static int CAN_PLACE = 1;
    public static int REPLACE_BELOW = 2;
    public static int REPLACE_ABOVE = 4;

    public SingleBlockFeature(Codec<Config> configCodec) {
        super(configCodec);
    }

    public SingleBlockFeature() {
        this((Codec<Config>)BigGlobeAutoCodec.AUTO_CODEC.createDFUCodec(Config.class));
    }

    public static Predicate<class_2680> matchWaterlogged(class_2680 state) {
        return state.method_26227().method_15772() == class_3612.field_15910 ? IS_SOURCE_WATER : IS_AIR;
    }

    public static class_2680[] getStates(class_2680 state) {
        if (state.method_28498((class_2769)class_2741.field_12533)) {
            return new class_2680[]{(class_2680)state.method_11657((class_2769)class_2741.field_12533, (Comparable)class_2756.field_12607), (class_2680)state.method_11657((class_2769)class_2741.field_12533, (Comparable)class_2756.field_12609)};
        }
        return new class_2680[]{state};
    }

    public static int checkFluids(class_1922 world, class_2338 origin, class_2680[] states, Predicate<class_2680> replace) {
        int result = CAN_PLACE;
        int length = states.length;
        for (int offsetY = 0; offsetY < length; ++offsetY) {
            class_2680 oldState = world.method_8320(origin.method_10086(offsetY));
            if (!replace.test(oldState)) {
                return 0;
            }
            class_2756 half = oldState.method_28500((class_2769)class_2741.field_12533).orElse(null);
            if (half != null) {
                switch (half) {
                    case field_12607: {
                        if (offsetY + 1 < length || oldState.method_26204() != world.method_8320(origin.method_10086(offsetY + 1)).method_26204()) break;
                        result |= REPLACE_ABOVE;
                        break;
                    }
                    case field_12609: {
                        if (offsetY - 1 >= 0 || oldState.method_26204() != world.method_8320(origin.method_10086(offsetY - 1)).method_26204()) break;
                        result |= REPLACE_BELOW;
                    }
                }
            }
            class_2680 newState = states[offsetY];
            class_3610 fluidState = oldState.method_26227();
            if (fluidState.method_15769()) {
                if (newState.method_28498((class_2769)class_2741.field_12508)) {
                    newState = (class_2680)newState.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.FALSE);
                } else if (!states[offsetY].method_26227().method_15769()) {
                    return 0;
                }
            } else if (fluidState.method_15772() == class_3612.field_15910) {
                if (newState.method_28498((class_2769)class_2741.field_12508)) {
                    newState = (class_2680)newState.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.TRUE);
                } else if (states[offsetY].method_26227().method_15772() != class_3612.field_15910) {
                    return 0;
                }
            } else {
                return 0;
            }
            states[offsetY] = newState;
        }
        return result;
    }

    public static boolean place(class_1936 world, class_2338 pos, class_2680 place, Predicate<class_2680> replace) {
        class_2338 downPos;
        class_2680 downState;
        PlantBlock_CanPlantOnTopAccess plantBlock;
        class_2248 class_22482 = place.method_26204();
        if (class_22482 instanceof PlantBlock_CanPlantOnTopAccess ? !(plantBlock = (PlantBlock_CanPlantOnTopAccess)class_22482).bigglobe_canPlantOnTop(downState = world.method_8320(downPos = pos.method_10074()), (class_1922)world, downPos) : !place.method_26184((class_4538)world, pos)) {
            return false;
        }
        class_2680[] states = SingleBlockFeature.getStates(place);
        int flags = SingleBlockFeature.checkFluids((class_1922)world, pos, states, replace);
        if ((flags & CAN_PLACE) == 0) {
            return false;
        }
        int length = states.length;
        for (int offsetY = 0; offsetY < length; ++offsetY) {
            world.method_8652(pos.method_10086(offsetY), states[offsetY], 19);
        }
        if ((flags & REPLACE_BELOW) != 0) {
            class_2338 down = pos.method_10074();
            world.method_8652(down, world.method_8316(down).method_15759(), 19);
        }
        if ((flags & REPLACE_ABOVE) != 0) {
            class_2338 up = pos.method_10086(states.length);
            world.method_8652(up, world.method_8316(up).method_15759(), 19);
        }
        return true;
    }

    public static boolean placeEarly(class_2791 chunk, class_2338 pos, class_2680 place, Predicate<class_2680> replace) {
        class_2680[] states = SingleBlockFeature.getStates(place);
        int flags = SingleBlockFeature.checkFluids((class_1922)chunk, pos, states, replace);
        if ((flags & CAN_PLACE) == 0) {
            return false;
        }
        int length = states.length;
        for (int offsetY = 0; offsetY < length; ++offsetY) {
            ChunkVersions.setBlockState(chunk, pos.method_10086(offsetY), states[offsetY], 18);
        }
        if ((flags & REPLACE_BELOW) != 0) {
            class_2338 down = pos.method_10074();
            ChunkVersions.setBlockState(chunk, down, chunk.method_8316(down).method_15759(), 18);
        }
        if ((flags & REPLACE_ABOVE) != 0) {
            class_2338 up = pos.method_10086(states.length);
            ChunkVersions.setBlockState(chunk, up, chunk.method_8316(up).method_15759(), 18);
        }
        return true;
    }

    public static boolean place(class_1936 world, class_2338 pos, RandomGenerator random, Config config) {
        return SingleBlockFeature.place(world, pos, config.place.get(random.nextInt(config.place.size())), (Predicate<class_2680>)config);
    }

    public static boolean place(class_1936 world, class_2338 pos, long seed, Config config) {
        return SingleBlockFeature.place(world, pos, config.place.get(Permuter.nextBoundedInt(seed, config.place.size())), (Predicate<class_2680>)config);
    }

    public boolean method_13151(class_5821<Config> context) {
        Config config = (Config)context.method_33656();
        return SingleBlockFeature.place((class_1936)context.method_33652(), context.method_33655(), config.getState(context.method_33654()), (Predicate<class_2680>)config);
    }

    @Override
    public boolean generate(WorldWrapper world, Config config, class_2338 pos) {
        return SingleBlockFeature.placeEarly(((WorldOrChunk.ChunkDelegator)world.world).chunk, pos, config.getState(world.random), config);
    }

    @UseCoder(name="new", in=ConfigCoder.class, usage=MemberUsage.METHOD_IS_FACTORY, strict=false)
    public record Config(@VerifyNotEmpty @SingletonArray List<class_2680> place, @VerifyNotEmpty @SingletonArray @VerifyNullable Set<class_2680> replace) implements class_3037,
    Predicate<class_2680>
    {
        public class_2680 getState(RandomGenerator random) {
            return Permuter.choose(random, this.place);
        }

        public class_2680 getState(class_5819 random) {
            return this.place.get(random.method_43048(this.place.size()));
        }

        public class_2680 getState(long seed) {
            return Permuter.choose(seed, this.place);
        }

        @Override
        public boolean test(class_2680 state) {
            return this.replace != null ? this.replace.contains(state) : BlockStateVersions.isReplaceable(state);
        }
    }

    public static class ConfigCoder
    extends AutoCoder.NamedCoder<Config> {
        public static final ReifiedType<List<class_2680>> BLOCKSTATE_LIST_REIFIED_TYPE = new ReifiedType<List<class_2680>>(){};
        public final AutoCoder<Config> withReplace;
        public final AutoCoder<List<class_2680>> placeOnly;

        public ConfigCoder(FactoryContext<Config> context) {
            super("ConfigCoder");
            this.withReplace = context.forceCreateCoder((AutoCoder.CoderFactory)RecordCoder.Factory.INSTANCE);
            FactoryContext replaceContext = context.type(BLOCKSTATE_LIST_REIFIED_TYPE);
            this.placeOnly = replaceContext.forceCreateCoder((AutoCoder.CoderFactory)EncoderDecoderCoder.Factory.INSTANCE);
        }

        @NotNull
        public <T_Encoded> Data encode(@NotNull EncodeContext<T_Encoded, Config> context) throws EncodeException {
            if (context.object == null) {
                return EmptyData.INSTANCE;
            }
            if (((Config)context.object).replace == null) {
                return context.object(((Config)context.object).place).encodeWith(this.placeOnly);
            }
            return context.encodeWith(this.withReplace);
        }

        @Nullable
        public <T_Encoded> Config decode(@NotNull DecodeContext<T_Encoded> context) throws DecodeException {
            if (context.isEmpty()) {
                return null;
            }
            if (context.isString()) {
                return new Config((List)context.decodeWith(this.placeOnly), null);
            }
            return (Config)context.decodeWith(this.withReplace);
        }
    }
}

