/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.hyperspace;

import builderb0y.autocodec.data.ListData;
import builderb0y.autocodec.data.MapData;
import builderb0y.autocodec.fixers.DataFixContext;
import builderb0y.autocodec.fixers.DataFixException;
import builderb0y.autocodec.fixers.VersionedFixer;
import builderb0y.bigglobe.hyperspace.ServerWaypointManager;
import org.jetbrains.annotations.NotNull;

public class HyperspaceStorageVersions
extends VersionedFixer<ServerWaypointManager> {
    public static final HyperspaceStorageVersions INSTANCE = new HyperspaceStorageVersions();
    public static final int V0_UUIDS = 0;
    public static final int V1_VARINT_IDS = 1;
    public static final int V2_INLINE_POS = 2;
    public static final int CURRENT_VERSION = 2;

    public HyperspaceStorageVersions() {
        super("HyperspaceStorageVersions", 2);
    }

    @NotNull
    public <T_Encoded> DataFixContext<T_Encoded> fixData(@NotNull DataFixContext<T_Encoded> context, int version) throws DataFixException {
        switch (version) {
            default: {
                throw new DataFixException(() -> "Unknown hyperspace storage version: " + version);
            }
            case 0: {
                this.convertUUIDsToIDs(context);
            }
            case 1: {
                this.inlinePositions(context);
            }
            case 2: 
        }
        return context;
    }

    public <T_Encoded> void convertUUIDsToIDs(DataFixContext<T_Encoded> context) throws DataFixException {
        ListData waypoints = context.forceGetMember("waypoints").forceAsList();
        int size = waypoints.value.size();
        for (int index = 0; index < size; ++index) {
            MapData waypoint = ((DataFixContext)context.fork(index, waypoints.get(index))).forceAsMap();
            waypoint.remove("uuid");
            waypoint.putInt("id", index);
        }
        context.putInt("nextID", size);
    }

    public <T_Encoded> void inlinePositions(DataFixContext<T_Encoded> context) throws DataFixException {
    }
}

