/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.hyperspace;

import builderb0y.autocodec.annotations.AddPseudoField;
import builderb0y.autocodec.annotations.MemberUsage;
import builderb0y.autocodec.annotations.UseFixer;
import builderb0y.autocodec.annotations.UseImprinter;
import builderb0y.autocodec.coders.AutoCoder;
import builderb0y.autocodec.common.FactoryContext;
import builderb0y.autocodec.decoders.DecodeException;
import builderb0y.autocodec.imprinters.AutoImprinter;
import builderb0y.autocodec.imprinters.ImprintContext;
import builderb0y.autocodec.imprinters.ImprintException;
import builderb0y.autocodec.reflection.reification.ReifiedType;
import builderb0y.bigglobe.BigGlobeMod;
import builderb0y.bigglobe.codecs.BigGlobeAutoCodec;
import builderb0y.bigglobe.hyperspace.HyperspaceConstants;
import builderb0y.bigglobe.hyperspace.HyperspaceStorageVersions;
import builderb0y.bigglobe.hyperspace.PackedPos;
import builderb0y.bigglobe.hyperspace.PlayerWaypointData;
import builderb0y.bigglobe.hyperspace.PlayerWaypointManager;
import builderb0y.bigglobe.hyperspace.ServerWaypointData;
import builderb0y.bigglobe.hyperspace.WaypointLookup;
import builderb0y.bigglobe.hyperspace.WaypointManager;
import builderb0y.bigglobe.versions.EntityVersions;
import builderb0y.bigglobe.versions.GameProfileVersions;
import java.util.Collection;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.class_10741;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@AddPseudoField(value="waypoints")
@UseFixer(name="INSTANCE", in=HyperspaceStorageVersions.class, usage=MemberUsage.FIELD_CONTAINS_HANDLER)
@UseImprinter(name="new", in=Imprinter.class, usage=MemberUsage.METHOD_IS_FACTORY)
public class ServerWaypointManager
extends WaypointManager<ServerWaypointData> {
    public static final class_10741<ServerWaypointManager> TYPE = new class_10741("bigglobe_hyperspace_waypoints", ServerWaypointManager::new, BigGlobeAutoCodec.AUTO_CODEC.createDFUCodec(ServerWaypointManager.class), null);
    public int nextID;

    public Collection<ServerWaypointData> waypoints() {
        return this.getAllWaypoints();
    }

    @Nullable
    public static ServerWaypointManager get(class_3218 world) {
        if (world.method_27983() != HyperspaceConstants.WORLD_KEY && (world = world.method_8503().method_3847(HyperspaceConstants.WORLD_KEY)) == null) {
            return null;
        }
        return (ServerWaypointManager)world.method_17983().method_17924(TYPE);
    }

    public int nextID() {
        int prevID = this.nextID;
        int nextID = prevID + 1;
        if (nextID == 0) {
            throw new IllegalStateException("Ran out of IDs for waypoints.");
        }
        this.nextID = nextID;
        return prevID;
    }

    public Stream<ServerWaypointData> getVisibleWaypoints(class_1657 player) {
        return this.getVisibleWaypoints(GameProfileVersions.getUUID(player.method_7334()), (class_5321<class_1937>)EntityVersions.getWorld((class_1297)player).method_27983());
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Stream<ServerWaypointData> getVisibleWaypoints(UUID playerUUID, class_5321<class_1937> playerWorld) {
        void var3_8;
        void var3_10;
        WaypointLookup global = (WaypointLookup)((Object)this.byOwner.get(null));
        if (playerUUID == null) {
            if (global == null || global.isEmpty()) return Stream.empty();
            Stream stream = global.values().stream();
        } else {
            WaypointLookup owned = (WaypointLookup)((Object)this.byOwner.get(playerUUID));
            if (global != null && !global.isEmpty()) {
                if (owned != null && !owned.isEmpty()) {
                    Stream stream = Stream.concat(global.values().stream(), owned.values().stream());
                } else {
                    Stream stream = global.values().stream();
                }
            } else {
                if (owned == null || owned.isEmpty()) return Stream.empty();
                Stream stream = owned.values().stream();
            }
        }
        if (playerWorld == HyperspaceConstants.WORLD_KEY) return var3_10;
        Stream<ServerWaypointData> stream = var3_8.filter(data -> data.destinationPosition().world() == playerWorld);
        return var3_10;
    }

    @Override
    public boolean addWaypoint(ServerWaypointData waypoint, boolean sync) {
        if (super.addWaypoint(waypoint, sync)) {
            MinecraftServer server;
            if (sync && (server = BigGlobeMod.currentServer) != null) {
                if (waypoint.owner() != null) {
                    PlayerWaypointManager playerManager;
                    class_3222 player = server.method_3760().method_14602(waypoint.owner());
                    if (player != null && (playerManager = PlayerWaypointManager.get((class_1657)player)) != null) {
                        PlayerWaypointData serverWaypoint = EntityVersions.getWorld((class_1297)player).method_27983() == HyperspaceConstants.WORLD_KEY ? waypoint.relativize(playerManager.entrance != null ? playerManager.entrance.pos() : PackedPos.ZERO) : waypoint.absolutize();
                        playerManager.addWaypoint(serverWaypoint, true);
                    }
                } else {
                    class_3218 world = server.method_3847(waypoint.pos().world());
                    if (world != null) {
                        for (class_3222 player : world.method_18456()) {
                            PlayerWaypointManager manager = PlayerWaypointManager.get((class_1657)player);
                            if (manager == null) continue;
                            manager.addWaypoint(waypoint.absolutize(), true);
                        }
                    } else {
                        BigGlobeMod.LOGGER.warn("Attempt to add waypoint to non-existent world: " + String.valueOf(waypoint));
                    }
                    world = server.method_3847(HyperspaceConstants.WORLD_KEY);
                    if (world != null) {
                        for (class_3222 player : world.method_18456()) {
                            PlayerWaypointManager serverManager = PlayerWaypointManager.get((class_1657)player);
                            if (serverManager == null) continue;
                            PlayerWaypointData serverWaypoint = waypoint.relativize(serverManager.entrance != null ? serverManager.entrance.pos() : PackedPos.ZERO);
                            serverManager.addWaypoint(serverWaypoint, true);
                        }
                    }
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public ServerWaypointData removeWaypoint(int id, boolean sync) {
        MinecraftServer server;
        ServerWaypointData removed = (ServerWaypointData)super.removeWaypoint(id, sync);
        if (removed != null && sync && (server = BigGlobeMod.currentServer) != null) {
            if (removed.owner() != null) {
                PlayerWaypointManager manager;
                class_3222 player = server.method_3760().method_14602(removed.owner());
                if (player != null && (manager = PlayerWaypointManager.get((class_1657)player)) != null) {
                    manager.removeWaypoint(id, true);
                }
            } else {
                PlayerWaypointManager manager;
                class_3218 world = server.method_3847(removed.pos().world());
                if (world != null) {
                    for (class_3222 player : world.method_18456()) {
                        manager = PlayerWaypointManager.get((class_1657)player);
                        if (manager == null) continue;
                        manager.removeWaypoint(id, true);
                    }
                } else {
                    BigGlobeMod.LOGGER.warn("Attempt to remove waypoint from non-existent world: " + String.valueOf(removed));
                }
                world = server.method_3847(HyperspaceConstants.WORLD_KEY);
                if (world != null) {
                    for (class_3222 player : world.method_18456()) {
                        manager = PlayerWaypointManager.get((class_1657)player);
                        if (manager == null) continue;
                        manager.removeWaypoint(id, true);
                    }
                }
            }
        }
        return removed;
    }

    public static class Imprinter
    extends AutoImprinter.NamedImprinter<ServerWaypointManager> {
        public final AutoCoder<ServerWaypointData> waypointCoder;

        public Imprinter(FactoryContext<ServerWaypointManager> context) {
            super("ServerWaypointManager.Imprinter");
            this.waypointCoder = context.type(ReifiedType.from(ServerWaypointData.class)).forceCreateCoder();
        }

        @ApiStatus.OverrideOnly
        public <T_Encoded> void imprint(@NotNull ImprintContext<T_Encoded, ServerWaypointManager> context) throws ImprintException {
            ServerWaypointManager manager = (ServerWaypointManager)((Object)context.object);
            manager.nextID = ((ImprintContext)context.forceGetMember("nextID")).forceAsInt();
            ImprintException rootException = null;
            for (ImprintContext waypoint : ((ImprintContext)context.forceGetMember("waypoints")).listIterable()) {
                try {
                    manager.addWaypoint((ServerWaypointData)waypoint.decodeWith(this.waypointCoder), false);
                }
                catch (DecodeException exception) {
                    if (rootException == null) {
                        rootException = new ImprintException(() -> "Some waypoints failed to be deserialized, see below.");
                    }
                    rootException.addSuppressed((Throwable)exception);
                }
            }
            if (rootException != null) {
                throw rootException;
            }
        }

        public @Nullable Stream<@NotNull String> getKeys() {
            return Stream.of("version", "waypoints", "nextID");
        }
    }
}

