/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.noise.processing;

import builderb0y.bigglobe.noise.Grid;
import builderb0y.bigglobe.noise.processing.UnaryGrid;

public abstract class AbsGrid
implements UnaryGrid {
    public final transient double minValue;
    public final transient double maxValue;

    public AbsGrid(Grid grid) {
        double min = grid.minValue();
        double max = grid.maxValue();
        double absMin = Math.abs(min);
        double absMax = Math.abs(max);
        this.minValue = min <= 0.0 && max >= 0.0 ? 0.0 : Math.min(absMin, absMax);
        this.maxValue = Math.max(absMin, absMax);
    }

    @Override
    public double minValue() {
        return this.minValue;
    }

    @Override
    public double maxValue() {
        return this.maxValue;
    }

    @Override
    public double operate(double value) {
        return Math.abs(value);
    }
}

