/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.noise.processing;

import builderb0y.bigglobe.noise.Grid;
import builderb0y.bigglobe.noise.processing.LayeredGrid;

public abstract class SummingGrid
implements LayeredGrid {
    public final transient double minValue;
    public final transient double maxValue;

    public SummingGrid(Grid ... layers) {
        double minValue = layers[0].minValue();
        double maxValue = layers[0].maxValue();
        int length = layers.length;
        for (int index = 1; index < length; ++index) {
            minValue += layers[index].minValue();
            maxValue += layers[index].maxValue();
        }
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    @Override
    public double minValue() {
        return this.minValue;
    }

    @Override
    public double maxValue() {
        return this.maxValue;
    }

    @Override
    public boolean isProduct() {
        return false;
    }
}

