/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.rendering.lods;

import builderb0y.bigglobe.config.BigGlobeConfig;
import builderb0y.bigglobe.versions.HeightLimitViewVersions;
import builderb0y.bigglobe.versions.RenderVersions;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.minecraft.class_243;
import net.minecraft.class_5539;
import net.minecraft.class_757;
import org.joml.FrustumIntersection;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

@Environment(value=EnvType.CLIENT)
public class LodFrustum {
    public FrustumIntersection jomlFrustum = new FrustumIntersection();
    public double x;
    public double y;
    public double z;
    public float nearClippingPlane;
    public float farClippingPlane;
    public float generationBuffer;
    public Matrix4f modelViewMatrix = new Matrix4f();
    public Matrix4f projectionMatrix = new Matrix4f();
    public Matrix4f modelViewProjectionMatrix = new Matrix4f();

    public void setup(WorldRenderContext context) {
        this.modelViewMatrix.set((Matrix4fc)context.positionMatrix());
        class_243 cameraPos = context.camera().method_19326();
        this.x = cameraPos.field_1352;
        this.y = cameraPos.field_1351;
        this.z = cameraPos.field_1350;
        class_757 renderer = context.gameRenderer();
        float vanillaViewDistance = renderer.method_3193();
        float aboveDifference = (float)(this.y - (double)HeightLimitViewVersions.getMaxY((class_5539)context.world()));
        if (aboveDifference > 0.0f) {
            vanillaViewDistance = Math.max(vanillaViewDistance, aboveDifference * 0.25f);
        }
        this.projectionMatrix.set(RenderVersions.projectionMatrix(context));
        this.nearClippingPlane = vanillaViewDistance * BigGlobeConfig.INSTANCE.get().lodRendering.minViewDistance;
        this.farClippingPlane = vanillaViewDistance * BigGlobeConfig.INSTANCE.get().lodRendering.maxViewDistance;
        this.changeNearFar(this.projectionMatrix, 0.05f, renderer.method_32796(), this.nearClippingPlane, this.farClippingPlane);
        this.generationBuffer = vanillaViewDistance * BigGlobeConfig.INSTANCE.get().lodRendering.generationBufferDistance;
        this.projectionMatrix.mul((Matrix4fc)this.modelViewMatrix, this.modelViewProjectionMatrix);
        this.jomlFrustum.set((Matrix4fc)this.modelViewProjectionMatrix, false);
    }

    public void changeNearFar(Matrix4f matrix, float oldNear, float oldFar, float newNear, float newFar) {
        float denominator = (newNear - newFar) * oldFar * oldNear;
        float l = newFar * newNear * (oldNear - oldFar) / denominator;
        float r = newFar * newNear * (oldNear + oldFar) / denominator - (newNear + newFar) / (newNear - newFar);
        float m02 = r * matrix.m03() + l * matrix.m02();
        float m12 = r * matrix.m13() + l * matrix.m12();
        float m22 = r * matrix.m23() + l * matrix.m22();
        float m32 = r * matrix.m33() + l * matrix.m32();
        matrix.m02(m02).m12(m12).m22(m22).m32(m32);
    }

    public Boolean test(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        int test = this.jomlFrustum.intersectAab((float)(minX - this.x), (float)(minY - this.y), (float)(minZ - this.z), (float)(maxX - this.x), (float)(maxY - this.y), (float)(maxZ - this.z));
        if (test == -2) {
            return Boolean.TRUE;
        }
        if (test != -1) {
            return Boolean.FALSE;
        }
        return null;
    }
}

