/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.rendering.lods;

import builderb0y.bigglobe.math.BigGlobeMath;
import builderb0y.bigglobe.rendering.ResourceTracker;
import builderb0y.bigglobe.rendering.lods.CompactVertexConsumer;
import builderb0y.bigglobe.rendering.lods.CompactVertexFormat;
import builderb0y.bigglobe.rendering.lods.VersionedVertexConsumer;
import net.minecraft.class_3532;
import net.minecraft.class_4608;
import net.minecraft.class_765;
import net.minecraft.class_9848;

public class SidedVertexConsumer
extends VersionedVertexConsumer {
    public final CompactVertexConsumer posX;
    public final CompactVertexConsumer negX;
    public final CompactVertexConsumer posZ;
    public final CompactVertexConsumer negZ;
    public final CompactVertexConsumer all;
    public Vertex[] quad;

    public SidedVertexConsumer(long vertexCount, CompactVertexFormat format) {
        super(format.flags | 0x20);
        this.posX = new CompactVertexConsumer(vertexCount, format);
        this.posZ = new CompactVertexConsumer(vertexCount, format);
        this.negX = new CompactVertexConsumer(vertexCount, format);
        this.negZ = new CompactVertexConsumer(vertexCount, format);
        this.all = new CompactVertexConsumer(vertexCount, format);
        this.quad = new Vertex[4];
        this.quad[0] = new Vertex();
        this.quad[1] = new Vertex();
        this.quad[2] = new Vertex();
        this.quad[3] = new Vertex();
    }

    @Override
    public void endVertex() {
        if ((this.vertexCount & 3) == 0) {
            CompactVertexConsumer delegate = this.quad[0].selectDelegateFromNormal(this);
            if (delegate != this.all) {
                for (int index = 1; index < 4; ++index) {
                    CompactVertexConsumer otherDelegate = this.quad[index].selectDelegateFromNormal(this);
                    if (otherDelegate == delegate) continue;
                    delegate = this.all;
                    break;
                }
            }
            for (Vertex v : this.quad) {
                delegate.method_22912(v.x, v.y, v.z).method_39415(v.color).method_22913(v.u, v.v).method_22922(v.overlay).method_60803(v.light).method_22914(v.nx, v.ny, v.nz);
            }
        }
        super.endVertex();
    }

    @Override
    public void handlePosition(float x, float y, float z) {
        Vertex vertex = this.quad[this.vertexCount & 3];
        vertex.x = x;
        vertex.y = y;
        vertex.z = z;
    }

    @Override
    public void handleColor(float red, float green, float blue, float alpha) {
        this.handleColor((int)(red * 255.0f), (int)(green * 255.0f), (int)(blue * 255.0f), (int)(alpha * 255.0f));
    }

    @Override
    public void handleColor(int red, int green, int blue, int alpha) {
        this.handleColor(class_9848.method_61324((int)alpha, (int)red, (int)green, (int)blue));
    }

    @Override
    public void handleColor(int argb) {
        this.quad[this.vertexCount & 3].color = argb;
    }

    @Override
    public void handleTexture(float u, float v) {
        Vertex vertex = this.quad[this.vertexCount & 3];
        vertex.u = u;
        vertex.v = v;
    }

    @Override
    public void handleOverlay(int u, int v) {
        this.handleOverlay(class_4608.method_23625((int)u, (int)v));
    }

    @Override
    public void handleOverlay(int uv) {
        this.quad[this.vertexCount & 2].overlay = uv;
    }

    @Override
    public void handleLight(int blocklight, int skylight) {
        this.handleLight(class_765.method_23687((int)blocklight, (int)skylight));
    }

    @Override
    public void handleLight(int light) {
        this.quad[this.vertexCount & 3].light = light;
    }

    @Override
    public void handleNormal(float nx, float ny, float nz) {
        Vertex vertex = this.quad[this.vertexCount & 3];
        vertex.nx = nx;
        vertex.ny = ny;
        vertex.nz = nz;
    }

    @Override
    public void close() {
        ResourceTracker.closeAll(this.posX, this.negX, this.posZ, this.negZ, this.all);
    }

    public static class Vertex {
        public float x;
        public float y;
        public float z;
        public int color;
        public float u;
        public float v;
        public int overlay;
        public int light;
        public float nx;
        public float ny;
        public float nz;

        public CompactVertexConsumer selectDelegateFromNormal(SidedVertexConsumer sided) {
            return switch (BigGlobeMath.roundI(this.nx + this.nz * 2.0f)) {
                case -2 -> {
                    if (class_3532.method_15347((float)this.nz, (float)-1.0f)) {
                        yield sided.negZ;
                    }
                    yield sided.all;
                }
                case -1 -> {
                    if (class_3532.method_15347((float)this.nx, (float)-1.0f)) {
                        yield sided.negX;
                    }
                    yield sided.all;
                }
                default -> sided.all;
                case 1 -> {
                    if (class_3532.method_15347((float)this.nx, (float)1.0f)) {
                        yield sided.posX;
                    }
                    yield sided.all;
                }
                case 2 -> class_3532.method_15347((float)this.nz, (float)1.0f) ? sided.posZ : sided.all;
            };
        }
    }
}

