/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.scripting.environments;

import builderb0y.bigglobe.math.BigGlobeMath;
import builderb0y.bigglobe.scripting.wrappers.WorldWrapper;
import builderb0y.bigglobe.util.Directions;
import builderb0y.bigglobe.util.Symmetry;
import builderb0y.bigglobe.util.coordinators.CoordinateFunctions;
import builderb0y.bigglobe.util.coordinators.Coordinator;
import builderb0y.bigglobe.versions.BlockEntityVersions;
import builderb0y.bigglobe.versions.IdentifierVersions;
import builderb0y.scripting.bytecode.InsnTrees;
import builderb0y.scripting.bytecode.MethodInfo;
import builderb0y.scripting.bytecode.tree.InsnTree;
import builderb0y.scripting.environments.Handlers;
import builderb0y.scripting.environments.MutableScriptEnvironment;
import builderb0y.scripting.environments.ScriptEnvironment;
import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3730;
import net.minecraft.class_7923;

public class CoordinatorScriptEnvironment {
    public static final MethodInfo ALL_OF = MethodInfo.findMethod(Coordinator.class, "combine", Coordinator.class, Coordinator[].class);
    public static final MethodInfo TRANSLATE = MethodInfo.findMethod(Coordinator.class, "translate", Coordinator.class, Integer.TYPE, Integer.TYPE, Integer.TYPE);
    public static final MethodInfo MULTI_TRANSLATE = MethodInfo.findMethod(Coordinator.class, "multiTranslate", Coordinator.class, int[].class);
    public static final MethodInfo SYMMETRIFY_1 = MethodInfo.findMethod(Coordinator.class, "symmetric", Coordinator.class, Symmetry.class);
    public static final MethodInfo SYMMETRIFY_2 = MethodInfo.findMethod(Coordinator.class, "symmetric", Coordinator.class, Symmetry.class, Symmetry.class);
    public static final MethodInfo SYMMETRIFY_4 = MethodInfo.findMethod(Coordinator.class, "symmetric", Coordinator.class, Symmetry.class, Symmetry.class, Symmetry.class, Symmetry.class);
    public static final MethodInfo SYMMETRIFY_VARARGS = MethodInfo.findMethod(Coordinator.class, "symmetric", Coordinator.class, Symmetry[].class);
    public static final MutableScriptEnvironment BASE = new MutableScriptEnvironment().addType("Coordinator", Coordinator.class).addQualifiedFunction(InsnTrees.type(Coordinator.class), "allOf", new MutableScriptEnvironment.FunctionHandler.Named("Coordinator.allOf(Coordinator... coordinators)", (parser, name, arguments) -> {
        InsnTree[] castArguments = ScriptEnvironment.castArguments(parser, "allOf", InsnTrees.types(Coordinator.class, arguments.length), InsnTree.CastMode.IMPLICIT_NULL, arguments);
        if (castArguments == null) {
            return null;
        }
        InsnTree array = InsnTrees.newArrayWithContents(parser, InsnTrees.type(Coordinator[].class), castArguments);
        return new MutableScriptEnvironment.CastResult(InsnTrees.invokeStatic(ALL_OF, array), castArguments != arguments);
    })).addMethodInvokeSpecific(Coordinator.class, "setBlockState", Void.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, class_2680.class).addMethodInvokeSpecific(Coordinator.class, "setBlockStateCuboid", Void.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, class_2680.class).addMethodInvokeSpecific(Coordinator.class, "setBlockStateLine", Void.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, class_2680.class).addMethodInvokeStatics(CoordinatorScriptEnvironment.class, "setBlockData", "setBlockDataLine", "setBlockDataCuboid", "mergeBlockData", "mergeBlockDataLine", "mergeBlockDataCuboid").addMethod(InsnTrees.type(Coordinator.class), "translate", new MutableScriptEnvironment.MethodHandler.Named("translate(int... offsets ;(number of offsets must be divisible by 3))", (parser, receiver, name, mode, arguments) -> {
        if (arguments.length % 3 != 0) {
            return null;
        }
        InsnTree[] offsets = ScriptEnvironment.castArguments(parser, "translate", InsnTrees.types("I".repeat(arguments.length)), InsnTree.CastMode.IMPLICIT_NULL, arguments);
        if (offsets == null) {
            return null;
        }
        if (offsets.length == 3) {
            return new MutableScriptEnvironment.CastResult(InsnTrees.invokeInstance(receiver, TRANSLATE, offsets), offsets != arguments);
        }
        InsnTree array = InsnTrees.newArrayWithContents(parser, InsnTrees.type(int[].class), offsets);
        return new MutableScriptEnvironment.CastResult(InsnTrees.invokeInstance(receiver, MULTI_TRANSLATE, array), offsets != arguments);
    })).addMethod(InsnTrees.type(Coordinator.class), "symmetrify", new MutableScriptEnvironment.MethodHandler.Named("symmetrify(Symmetry...)", (parser, receiver, name, mode, arguments) -> {
        InsnTree[] symmetries = ScriptEnvironment.castArguments(parser, "symmetrify", InsnTrees.types(Symmetry.class, arguments.length), InsnTree.CastMode.IMPLICIT_NULL, arguments);
        if (symmetries == null) {
            return null;
        }
        return new MutableScriptEnvironment.CastResult(switch (symmetries.length) {
            case 1 -> InsnTrees.invokeInstance(receiver, SYMMETRIFY_1, symmetries);
            case 2 -> InsnTrees.invokeInstance(receiver, SYMMETRIFY_2, symmetries);
            case 4 -> InsnTrees.invokeInstance(receiver, SYMMETRIFY_4, symmetries);
            default -> InsnTrees.invokeInstance(receiver, SYMMETRIFY_VARARGS, InsnTrees.newArrayWithContents(parser, InsnTrees.type(Symmetry[].class), symmetries));
        }, symmetries != arguments);
    })).addMethod(InsnTrees.type(Coordinator.class), "rotate1x", Handlers.builder(Coordinator.class, "rotate1x").addReceiverArgument(Coordinator.class).addNestedArgument(Handlers.builder(Directions.class, "scriptRotation").addRequiredArgument(Integer.TYPE)).buildMethod()).addMethodInvokeSpecific(Coordinator.class, "rotate2x180", Coordinator.class, new Class[0]).addMethodInvokeSpecific(Coordinator.class, "rotate4x90", Coordinator.class, new Class[0]).addMethodInvokeSpecific(Coordinator.class, "flip1X", Coordinator.class, new Class[0]).addMethodInvokeSpecific(Coordinator.class, "flip1Z", Coordinator.class, new Class[0]).addMethodInvokeSpecific(Coordinator.class, "flip2X", Coordinator.class, new Class[0]).addMethodInvokeSpecific(Coordinator.class, "flip2Z", Coordinator.class, new Class[0]).addMethodInvokeSpecific(Coordinator.class, "flip4XZ", Coordinator.class, new Class[0]).addMethodInvokeSpecific(Coordinator.class, "stack", Coordinator.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE).addMethodInvokeSpecific(Coordinator.class, "inBox", Coordinator.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE).addMethodMultiInvokeStatic(CoordinatorScriptEnvironment.class, "summon");

    public static Consumer<MutableScriptEnvironment> create(InsnTree loadWorld) {
        return environment -> environment.addAll(BASE).addQualifiedFunction(InsnTrees.type(Coordinator.class), "new", Handlers.builder(WorldWrapper.class, "coordinator").addImplicitArgument(loadWorld).buildFunction());
    }

    public static void setBlockData(Coordinator coordinator, int x, int y, int z, class_2487 data) {
        coordinator.getBlockEntity(x, y, z, CoordinatorScriptEnvironment.setter(data));
    }

    public static void setBlockDataLine(Coordinator coordinator, int x, int y, int z, int dx, int dy, int dz, int length, class_2487 data) {
        coordinator.getBlockEntityLine(x, y, z, dx, dy, dz, length, CoordinatorScriptEnvironment.setter(data));
    }

    public static void setBlockDataCuboid(Coordinator coordinator, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, class_2487 data) {
        coordinator.getBlockEntityCuboid(minX, minY, minZ, maxX, maxY, maxZ, CoordinatorScriptEnvironment.setter(data));
    }

    public static void mergeBlockData(Coordinator coordinator, int x, int y, int z, class_2487 data) {
        coordinator.getBlockEntity(x, y, z, CoordinatorScriptEnvironment.merger(data));
    }

    public static void mergeBlockDataLine(Coordinator coordinator, int x, int y, int z, int dx, int dy, int dz, int length, class_2487 data) {
        coordinator.getBlockEntityLine(x, y, z, dx, dy, dz, length, CoordinatorScriptEnvironment.merger(data));
    }

    public static void mergeBlockDataCuboid(Coordinator coordinator, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, class_2487 data) {
        coordinator.getBlockEntityCuboid(minX, minY, minZ, maxX, maxY, maxZ, CoordinatorScriptEnvironment.merger(data));
    }

    public static CoordinateFunctions.CoordinateConsumer<class_2586> setter(class_2487 data) {
        return (pos, blockEntity) -> {
            BlockEntityVersions.readFromNbt(blockEntity, data);
            blockEntity.method_5431();
        };
    }

    public static CoordinateFunctions.CoordinateConsumer<class_2586> merger(class_2487 data) {
        return (pos, blockEntity) -> {
            class_2487 newData;
            class_2487 oldData = BlockEntityVersions.writeToNbt(blockEntity);
            if (!oldData.equals((Object)(newData = oldData.method_10553().method_10543(data)))) {
                BlockEntityVersions.readFromNbt(blockEntity, newData);
                blockEntity.method_5431();
            }
        };
    }

    public static void summon(Coordinator coordinator, double x, double y, double z, String entityTypeName) {
        class_2960 identifier = IdentifierVersions.create(entityTypeName);
        if (!class_7923.field_41177.method_10250(identifier)) {
            throw new IllegalArgumentException("Unknown entity type: " + entityTypeName);
        }
        class_1299 entityType = (class_1299)class_7923.field_41177.method_63535(identifier);
        double offsetX = BigGlobeMath.modulus_BP(x, 1.0);
        double offsetY = BigGlobeMath.modulus_BP(y, 1.0);
        double offsetZ = BigGlobeMath.modulus_BP(z, 1.0);
        coordinator.addEntity(BigGlobeMath.floorI(x), BigGlobeMath.floorI(y), BigGlobeMath.floorI(z), (pos, world) -> {
            double newX = (double)pos.method_10263() + offsetX;
            double newY = (double)pos.method_10264() + offsetY;
            double newZ = (double)pos.method_10260() + offsetZ;
            class_1297 entity = entityType.method_5883((class_1937)world, class_3730.field_16472);
            if (entity != null) {
                entity.method_5808(newX, newY, newZ, entity.method_36454(), entity.method_36455());
                return entity;
            }
            throw new IllegalArgumentException("Entity type " + entityTypeName + " is not enabled in this world's feature flags.");
        });
    }

    public static void summon(Coordinator coordinator, double x, double y, double z, String entityTypeName, class_2487 data) {
        class_2960 identifier = IdentifierVersions.create(entityTypeName);
        if (!class_7923.field_41177.method_10250(identifier)) {
            throw new IllegalArgumentException("Unknown entity type: " + entityTypeName);
        }
        double offsetX = BigGlobeMath.modulus_BP(x, 1.0);
        double offsetY = BigGlobeMath.modulus_BP(y, 1.0);
        double offsetZ = BigGlobeMath.modulus_BP(z, 1.0);
        class_2487 copy = data.method_10553();
        copy.method_10582("id", entityTypeName);
        coordinator.addEntity(BigGlobeMath.floorI(x), BigGlobeMath.floorI(y), BigGlobeMath.floorI(z), (pos, world) -> {
            double newX = (double)pos.method_10263() + offsetX;
            double newY = (double)pos.method_10264() + offsetY;
            double newZ = (double)pos.method_10260() + offsetZ;
            return class_1299.method_71371((class_2487)copy, (class_1937)world, (class_3730)class_3730.field_16472, entity -> {
                entity.method_5808(newX, newY, newZ, entity.method_36454(), entity.method_36455());
                return entity;
            });
        });
    }
}

