/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.scripting.environments;

import builderb0y.bigglobe.dynamicRegistries.BigGlobeDynamicRegistries;
import builderb0y.bigglobe.noise.Grid;
import builderb0y.bigglobe.noise.Grid1D;
import builderb0y.bigglobe.noise.Grid2D;
import builderb0y.bigglobe.noise.Grid3D;
import builderb0y.bigglobe.noise.NumberArray;
import builderb0y.bigglobe.noise.source.ConstantGrid1D;
import builderb0y.bigglobe.noise.source.ConstantGrid2D;
import builderb0y.bigglobe.noise.source.ConstantGrid3D;
import builderb0y.scripting.bytecode.ConstantFactory;
import builderb0y.scripting.bytecode.InsnTrees;
import builderb0y.scripting.bytecode.MethodCompileContext;
import builderb0y.scripting.bytecode.MethodInfo;
import builderb0y.scripting.bytecode.TypeInfo;
import builderb0y.scripting.bytecode.tree.InsnTree;
import builderb0y.scripting.bytecode.tree.instructions.update.ArgumentedObjectUpdateInsnTree;
import builderb0y.scripting.environments.Handlers;
import builderb0y.scripting.environments.MutableScriptEnvironment;
import builderb0y.scripting.environments.ScriptEnvironment;
import builderb0y.scripting.parsing.ExpressionParser;
import builderb0y.scripting.parsing.ScriptParsingException;
import builderb0y.scripting.util.TypeInfos;
import java.lang.invoke.MethodHandles;
import java.util.function.Consumer;
import net.minecraft.class_6880;

public class GridScriptEnvironment {
    public static final ConstantFactory GRID = new ConstantFactory(GridScriptEnvironment.class, "getGrid", String.class, Grid.class);
    public static final ConstantFactory GRID_1D = new ConstantFactory(GridScriptEnvironment.class, "getGrid1D", String.class, Grid1D.class);
    public static final ConstantFactory GRID_2D = new ConstantFactory(GridScriptEnvironment.class, "getGrid2D", String.class, Grid2D.class);
    public static final ConstantFactory GRID_3D = new ConstantFactory(GridScriptEnvironment.class, "getGrid3D", String.class, Grid3D.class);
    public static final Grid EMPTY_GRID = new Grid(){

        @Override
        public double minValue() {
            return 0.0;
        }

        @Override
        public double maxValue() {
            return 0.0;
        }

        @Override
        public int getDimensions() {
            return 0;
        }
    };
    public static final Grid1D EMPTY_GRID_1D = new ConstantGrid1D(0.0);
    public static final Grid2D EMPTY_GRID_2D = new ConstantGrid2D(0.0);
    public static final Grid3D EMPTY_GRID_3D = new ConstantGrid3D(0.0);
    public static final MutableScriptEnvironment BASE = new MutableScriptEnvironment().addType("Grid", Grid.class).addType("Grid1D", Grid1D.class).addType("Grid2D", Grid2D.class).addType("Grid3D", Grid3D.class).addCastConstant(GRID, true).addCastConstant(GRID_1D, true).addCastConstant(GRID_2D, true).addCastConstant(GRID_3D, true).addFieldInvoke("minValue", Grid.INFO.minValue).addFieldInvoke("maxValue", Grid.INFO.maxValue).addFieldInvoke("dimensions", Grid.INFO.getDimensions).addMethodInvoke("getValue", Grid1D.INFO.getValue).addMethodInvoke("getValuesX", Grid1D.INFO.getBulkX).addMethodInvoke("getValue", Grid2D.INFO.getValue).addMethodInvoke("getValuesX", Grid2D.INFO.getBulkX).addMethodInvoke("getValuesY", Grid2D.INFO.getBulkY).addMethodInvoke("getValue", Grid3D.INFO.getValue).addMethodInvoke("getValuesX", Grid3D.INFO.getBulkX).addMethodInvoke("getValuesY", Grid3D.INFO.getBulkY).addMethodInvoke("getValuesZ", Grid3D.INFO.getBulkZ).addType("NumberArray", NumberArray.class).addFunctionInvokeStatic("newBooleanArray", NumberArray.INFO.allocateBooleansDirectZero).addFunctionInvokeStatic("newByteArray", NumberArray.INFO.allocateBytesDirectZero).addFunctionInvokeStatic("newShortArray", NumberArray.INFO.allocateShortsDirectZero).addFunctionInvokeStatic("newIntArray", NumberArray.INFO.allocateIntsDirectZero).addFunctionInvokeStatic("newLongArray", NumberArray.INFO.allocateLongsDirectZero).addFunctionInvokeStatic("newFloatArray", NumberArray.INFO.allocateFloatsDirectZero).addFunctionInvokeStatic("newDoubleArray", NumberArray.INFO.allocateDoublesDirectZero).addMethodInvoke("getBoolean", NumberArray.INFO.getZ).addMethodInvoke("getByte", NumberArray.INFO.getB).addMethodInvoke("getShort", NumberArray.INFO.getS).addMethodInvoke("getInt", NumberArray.INFO.getI).addMethodInvoke("getLong", NumberArray.INFO.getL).addMethodInvoke("getFloat", NumberArray.INFO.getF).addMethodInvoke("getDouble", NumberArray.INFO.getD).addMethodInvoke("setBoolean", NumberArray.INFO.setZ).addMethodInvoke("setByte", NumberArray.INFO.setB).addMethodInvoke("setShort", NumberArray.INFO.setS).addMethodInvoke("setInt", NumberArray.INFO.setI).addMethodInvoke("setLong", NumberArray.INFO.setL).addMethodInvoke("setFloat", NumberArray.INFO.setF).addMethodInvoke("setDouble", NumberArray.INFO.setD).addMethodInvoke("fillBoolean", NumberArray.INFO.fillZ).addMethodInvoke("fillByte", NumberArray.INFO.fillB).addMethodInvoke("fillShort", NumberArray.INFO.fillS).addMethodInvoke("fillInt", NumberArray.INFO.fillI).addMethodInvoke("fillLong", NumberArray.INFO.fillL).addMethodInvoke("fillFloat", NumberArray.INFO.fillF).addMethodInvoke("fillDouble", NumberArray.INFO.fillD).addMethodInvoke("fillBoolean", NumberArray.INFO.fillFromToZ).addMethodInvoke("fillByte", NumberArray.INFO.fillFromToB).addMethodInvoke("fillShort", NumberArray.INFO.fillFromToS).addMethodInvoke("fillInt", NumberArray.INFO.fillFromToI).addMethodInvoke("fillLong", NumberArray.INFO.fillFromToL).addMethodInvoke("fillFloat", NumberArray.INFO.fillFromToF).addMethodInvoke("fillDouble", NumberArray.INFO.fillFromToD).addMethod(InsnTrees.type(NumberArray.class), "", new MutableScriptEnvironment.MethodHandler.Named("Automatic-precision getter and setter for NumberArray", (parser, receiver, name, mode, arguments) -> {
        InsnTree castArgument = ScriptEnvironment.castArgument(parser, "", TypeInfos.INT, InsnTree.CastMode.IMPLICIT_THROW, arguments);
        return new MutableScriptEnvironment.CastResult(new NumberArrayGetterInsnTree(receiver, castArgument, TypeInfos.DOUBLE), castArgument != arguments[0]);
    })).addFieldInvoke("length", NumberArray.INFO.length).addMethodInvoke("prefix", NumberArray.INFO.prefix).addMethodInvoke("sliceFromTo", NumberArray.INFO.sliceFromTo).addMethodInvoke("sliceOffsetLength", NumberArray.INFO.sliceOffsetLength);

    public static Consumer<MutableScriptEnvironment> create() {
        return environment -> environment.addAll(BASE);
    }

    public static Consumer<MutableScriptEnvironment> createWithSeed(InsnTree loadSeed) {
        return environment -> environment.configure(GridScriptEnvironment.create()).addMethod(InsnTrees.type(Grid1D.class), "getValue", Handlers.builder(Grid1D.class, "getValue").addReceiverArgument(Grid1D.class).addArguments(loadSeed, Character.valueOf('I')).buildMethod()).addMethod(InsnTrees.type(Grid1D.class), "getValuesX", Handlers.builder(Grid1D.class, "getBulkX").addReceiverArgument(Grid1D.class).addArguments(loadSeed, Character.valueOf('I'), NumberArray.class).buildMethod()).addMethod(InsnTrees.type(Grid2D.class), "getValue", Handlers.builder(Grid2D.class, "getValue").addReceiverArgument(Grid2D.class).addArguments(loadSeed, "II").buildMethod()).addMethod(InsnTrees.type(Grid2D.class), "getValuesX", Handlers.builder(Grid2D.class, "getBulkX").addReceiverArgument(Grid2D.class).addArguments(loadSeed, "II", NumberArray.class).buildMethod()).addMethod(InsnTrees.type(Grid2D.class), "getValuesY", Handlers.builder(Grid2D.class, "getBulkY").addReceiverArgument(Grid2D.class).addArguments(loadSeed, "II", NumberArray.class).buildMethod()).addMethod(InsnTrees.type(Grid3D.class), "getValue", Handlers.builder(Grid3D.class, "getValue").addReceiverArgument(Grid3D.class).addArguments(loadSeed, "III").buildMethod()).addMethod(InsnTrees.type(Grid3D.class), "getValuesX", Handlers.builder(Grid3D.class, "getBulkX").addReceiverArgument(Grid3D.class).addArguments(loadSeed, "III", NumberArray.class).buildMethod()).addMethod(InsnTrees.type(Grid3D.class), "getValuesY", Handlers.builder(Grid3D.class, "getBulkY").addReceiverArgument(Grid3D.class).addArguments(loadSeed, "III", NumberArray.class).buildMethod()).addMethod(InsnTrees.type(Grid3D.class), "getValuesZ", Handlers.builder(Grid3D.class, "getBulkZ").addReceiverArgument(Grid3D.class).addArguments(loadSeed, "III", NumberArray.class).buildMethod());
    }

    public static String precision(NumberArray array) {
        return switch (array.type) {
            case 0 -> "byte";
            case 1 -> "short";
            case 2 -> "int";
            case 3 -> "long";
            case 4 -> "float";
            case 5 -> "double";
            case 6 -> "boolean";
            default -> throw new IllegalStateException("Invalid type: " + array.type);
        };
    }

    public static Grid1D getGrid1D(MethodHandles.Lookup caller, String name, Class<?> type, String id, int flags) {
        return GridScriptEnvironment.getGrid1D(id, flags);
    }

    public static Grid1D getGrid1D(String id, int flags) {
        Grid grid = GridScriptEnvironment.getGrid(id, flags);
        return grid == EMPTY_GRID ? EMPTY_GRID_1D : (Grid1D)grid;
    }

    public static Grid2D getGrid2D(MethodHandles.Lookup caller, String name, Class<?> type, String id, int flags) {
        return GridScriptEnvironment.getGrid2D(id, flags);
    }

    public static Grid2D getGrid2D(String id, int flags) {
        Grid grid = GridScriptEnvironment.getGrid(id, flags);
        return grid == EMPTY_GRID ? EMPTY_GRID_2D : (Grid2D)grid;
    }

    public static Grid3D getGrid3D(MethodHandles.Lookup caller, String name, Class<?> type, String id, int flags) {
        return GridScriptEnvironment.getGrid3D(id, flags);
    }

    public static Grid3D getGrid3D(String id, int flags) {
        Grid grid = GridScriptEnvironment.getGrid(id, flags);
        return grid == EMPTY_GRID ? EMPTY_GRID_3D : (Grid3D)grid;
    }

    public static Grid getGrid(MethodHandles.Lookup caller, String name, Class<?> type, String id, int flags) {
        return GridScriptEnvironment.getGrid(id, flags);
    }

    public static Grid getGrid(String id, int flags) {
        class_6880<Grid> entry = ConstantFactory.getEntryServerOnly(BigGlobeDynamicRegistries.GRID_TEMPLATE_REGISTRY_KEY, id, flags, EMPTY_GRID);
        return entry != null ? (Grid)entry.comp_349() : null;
    }

    public static class NumberArrayGetterInsnTree
    implements InsnTree {
        public final InsnTree loadArray;
        public final InsnTree loadIndex;
        public final TypeInfo type;

        public NumberArrayGetterInsnTree(InsnTree loadArray, InsnTree loadIndex, TypeInfo type) {
            this.loadArray = loadArray;
            this.loadIndex = loadIndex;
            this.type = type;
        }

        public static MethodInfo getter(TypeInfo type) {
            return switch (type.getSort()) {
                default -> throw new IncompatibleClassChangeError();
                case TypeInfo.Sort.BYTE -> NumberArray.INFO.getB;
                case TypeInfo.Sort.SHORT -> NumberArray.INFO.getS;
                case TypeInfo.Sort.INT -> NumberArray.INFO.getI;
                case TypeInfo.Sort.LONG -> NumberArray.INFO.getL;
                case TypeInfo.Sort.FLOAT -> NumberArray.INFO.getF;
                case TypeInfo.Sort.DOUBLE -> NumberArray.INFO.getD;
                case TypeInfo.Sort.BOOLEAN -> NumberArray.INFO.getZ;
                case TypeInfo.Sort.CHAR, TypeInfo.Sort.VOID, TypeInfo.Sort.OBJECT, TypeInfo.Sort.ARRAY -> throw new IllegalStateException("Invalid NumberArray type: " + String.valueOf(type));
            };
        }

        public static MethodInfo setter(TypeInfo type) {
            return switch (type.getSort()) {
                default -> throw new IncompatibleClassChangeError();
                case TypeInfo.Sort.BYTE -> NumberArray.INFO.setB;
                case TypeInfo.Sort.SHORT -> NumberArray.INFO.setS;
                case TypeInfo.Sort.INT -> NumberArray.INFO.setI;
                case TypeInfo.Sort.LONG -> NumberArray.INFO.setL;
                case TypeInfo.Sort.FLOAT -> NumberArray.INFO.setF;
                case TypeInfo.Sort.DOUBLE -> NumberArray.INFO.setD;
                case TypeInfo.Sort.BOOLEAN -> NumberArray.INFO.setZ;
                case TypeInfo.Sort.CHAR, TypeInfo.Sort.VOID, TypeInfo.Sort.OBJECT, TypeInfo.Sort.ARRAY -> throw new IllegalStateException("Invalid NumberArray type: " + String.valueOf(type));
            };
        }

        @Override
        public void emitBytecode(MethodCompileContext method) {
            this.loadArray.emitBytecode(method);
            this.loadIndex.emitBytecode(method);
            NumberArrayGetterInsnTree.getter(this.type).emitBytecode(method);
        }

        @Override
        public TypeInfo getTypeInfo() {
            return this.type;
        }

        @Override
        public InsnTree doCast(ExpressionParser parser, TypeInfo type, InsnTree.CastMode mode, boolean nullable) {
            if (type.isNumber() || type.getSort() == TypeInfo.Sort.BOOLEAN) {
                return new NumberArrayGetterInsnTree(this.loadArray, this.loadIndex, type);
            }
            throw new ClassCastException("Cannot cast NumberArray element to " + String.valueOf(type));
        }

        @Override
        public InsnTree update(ExpressionParser parser, InsnTree.UpdateOp op, InsnTree.UpdateOrder order, InsnTree rightValue) throws ScriptParsingException {
            if (rightValue.getTypeInfo().isNumber() || rightValue.getTypeInfo().getSort() == TypeInfo.Sort.BOOLEAN) {
                return new ArgumentedObjectUpdateInsnTree(order, op == InsnTree.UpdateOp.ASSIGN, ArgumentedObjectUpdateInsnTree.ArgumentedObjectUpdateEmitters.forGetterSetter(this.loadArray, this.loadIndex, NumberArrayGetterInsnTree.getter(rightValue.getTypeInfo()), NumberArrayGetterInsnTree.setter(rightValue.getTypeInfo()), rightValue));
            }
            throw new ScriptParsingException("Can't store " + String.valueOf(rightValue.getTypeInfo()) + " in NumberArray", parser.input);
        }
    }
}

