/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.scripting.environments;

import builderb0y.scripting.bytecode.ConstantFactory;
import java.lang.invoke.MethodHandles;
import net.minecraft.class_155;
import org.jetbrains.annotations.NotNull;

public record MinecraftVersion(int major, int minor, int bugfix) implements Comparable<MinecraftVersion>
{
    public static final MinecraftVersion CURRENT;
    public static final ConstantFactory CONSTANT_FACTORY;

    public static MinecraftVersion of(MethodHandles.Lookup caller, String name, Class<?> type, String string, int flags) {
        return MinecraftVersion.of(string, flags);
    }

    public static MinecraftVersion of(String string, int flags) {
        if (string == null) {
            return null;
        }
        int major = 0;
        int minor = 0;
        int bugfix = 0;
        int point = 0;
        int length = string.length();
        for (int index = 0; index < length; ++index) {
            char c = string.charAt(index);
            if (c == '.') {
                if (++point > 2) {
                    if ((flags & 2) != 0) {
                        return null;
                    }
                    throw new IllegalArgumentException("More than 2 points in version: " + string);
                }
                major = minor;
                minor = bugfix;
                bugfix = 0;
                continue;
            }
            int digit = Character.digit(c, 10);
            if (digit >= 0) {
                bugfix = Math.addExact(Math.multiplyExact(bugfix, 10), digit);
                continue;
            }
            if ((flags & 2) != 0) {
                return null;
            }
            throw new NumberFormatException("Non-digit character in version string: " + string);
        }
        if (point == 0) {
            if ((flags & 2) != 0) {
                return null;
            }
            throw new IllegalArgumentException("No points in version: " + string);
        }
        if (point == 1) {
            major = minor;
            minor = bugfix;
            bugfix = 0;
        }
        return new MinecraftVersion(major, minor, bugfix);
    }

    @Override
    public int compareTo(@NotNull MinecraftVersion that) {
        int compare = Integer.compare(this.major, that.major);
        if (compare != 0) {
            return compare;
        }
        compare = Integer.compare(this.minor, that.minor);
        if (compare != 0) {
            return compare;
        }
        return Integer.compare(this.bugfix, that.bugfix);
    }

    @Override
    public String toString() {
        return this.major + "." + this.minor + "." + this.bugfix;
    }

    static {
        MinecraftVersion version;
        try {
            version = MinecraftVersion.of(class_155.method_16673().comp_4025(), 2);
        }
        catch (Exception e) {
            version = null;
        }
        CURRENT = version;
        CONSTANT_FACTORY = ConstantFactory.autoOfString();
    }
}

