/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.scripting.wrappers;

import builderb0y.bigglobe.BigGlobeMod;
import builderb0y.bigglobe.codecs.BlockStateCoder;
import builderb0y.bigglobe.fluids.BigGlobeFluidTags;
import builderb0y.bigglobe.scripting.ScriptLogger;
import builderb0y.bigglobe.scripting.wrappers.WorldWrapper;
import builderb0y.bigglobe.scripting.wrappers.tags.BlockTag;
import builderb0y.bigglobe.scripting.wrappers.tags.TagParser;
import builderb0y.bigglobe.util.Directions;
import builderb0y.bigglobe.versions.BlockStateVersions;
import builderb0y.bigglobe.versions.IdentifierVersions;
import builderb0y.scripting.bytecode.ConstantFactory;
import builderb0y.scripting.bytecode.InsnTrees;
import builderb0y.scripting.bytecode.MethodInfo;
import builderb0y.scripting.bytecode.TypeInfo;
import java.lang.invoke.MethodHandles;
import java.util.Set;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2682;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3486;
import net.minecraft.class_3542;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class BlockStateWrapper {
    public static final TypeInfo TYPE = InsnTrees.type(class_2680.class);
    public static final ConstantFactory CONSTANT_FACTORY = new ConstantFactory(BlockStateWrapper.class, "getState", String.class, class_2680.class);
    public static final ConstantFactory DEFAULT_CONSTANT_FACTORY = new ConstantFactory(BlockStateWrapper.class, "getDefaultState", String.class, class_2680.class);
    public static final MethodInfo GET_PROPERTY = MethodInfo.getMethod(BlockStateWrapper.class, "getProperty");
    public static final MethodInfo WITH = MethodInfo.getMethod(BlockStateWrapper.class, "with");
    public static final MethodInfo WITH_NULLABLE = MethodInfo.getMethod(BlockStateWrapper.class, "withNullable");
    public static final TagParser TAG_PARSER = new TagParser("BlockTag", BlockTag.class, "BlockState", MethodInfo.inCaller("isIn"));

    public static class_2680 getState(MethodHandles.Lookup caller, String name, Class<?> type, String id, int flags) {
        BlockStateCoder.BlockProperties block;
        if (id == null) {
            return null;
        }
        try {
            block = BlockStateCoder.decodeStateWithMissingErrors(BlockStateCoder.findBlockRegistry(), id).unwrapEager(arg_0 -> ((Logger)BigGlobeMod.LOGGER).warn(arg_0), RuntimeException::new);
            if (!block.enabled()) {
                throw new RuntimeException("Disabled block: " + id);
            }
        }
        catch (Exception exception) {
            if ((flags & 2) != 0) {
                return null;
            }
            throw exception;
        }
        Set<class_2769<?>> missing = block.missing();
        if (!missing.isEmpty()) {
            ScriptLogger.LOGGER.warn("Missing properties for state " + id + ": " + String.valueOf(missing));
        }
        return block.state();
    }

    public static class_2680 getState(String id, int flags) {
        if (id == null) {
            return null;
        }
        try {
            BlockStateCoder.BlockProperties block = BlockStateCoder.decodeState(BlockStateCoder.findBlockRegistry(), id).unwrapEager(arg_0 -> ((Logger)BigGlobeMod.LOGGER).warn(arg_0), RuntimeException::new);
            if (!block.enabled()) {
                throw new RuntimeException("Disabled block: " + id);
            }
            return block.state();
        }
        catch (Exception exception) {
            if ((flags & 2) != 0) {
                return null;
            }
            throw exception;
        }
    }

    public static class_2680 getDefaultState(MethodHandles.Lookup caller, String name, Class<?> type, String id, int flags) {
        return BlockStateWrapper.getDefaultState(id, flags);
    }

    public static class_2680 getDefaultState(String id, int flags) {
        if (id == null) {
            return null;
        }
        try {
            class_2960 identifier = IdentifierVersions.create(id);
            if (class_7923.field_41175.method_10250(identifier)) {
                return ((class_2248)class_7923.field_41175.method_63535(identifier)).method_9564();
            }
            throw new RuntimeException("Unknown block: " + id);
        }
        catch (RuntimeException exception) {
            if ((flags & 2) != 0) {
                return null;
            }
            throw exception;
        }
    }

    public static boolean isIn(class_2680 state, BlockTag tag) {
        return tag.list.contains(state.method_41520());
    }

    public static class_2248 getBlock(class_2680 state) {
        return state.method_26204();
    }

    public static boolean isAir(class_2680 state) {
        return state.method_26215();
    }

    public static boolean isReplaceable(class_2680 state) {
        return BlockStateVersions.isReplaceable(state);
    }

    public static boolean blocksLight(class_2680 state) {
        return state.method_26225();
    }

    public static boolean hasCollision(class_2680 state) {
        return !state.method_26220((class_1922)class_2682.field_12294, class_2338.field_10980).method_1110();
    }

    public static boolean hasFullCubeCollision(class_2680 state) {
        return class_2248.method_9614((class_265)state.method_26220((class_1922)class_2682.field_12294, class_2338.field_10980));
    }

    public static boolean hasFullCubeOutline(class_2680 state) {
        return class_2248.method_9614((class_265)state.method_26218((class_1922)class_2682.field_12294, class_2338.field_10980));
    }

    public static class_2680 rotate(class_2680 state, int rotation) {
        return state.method_26186(Directions.scriptRotation(rotation));
    }

    public static class_2680 mirror(class_2680 state, String axis) {
        return state.method_26185(Directions.scriptMirror(axis));
    }

    @Nullable
    public static <C extends Comparable<C>> C getProperty(class_2680 state, String name) {
        class_2769 property = state.method_26204().method_9595().method_11663(name);
        if (property == null) {
            return null;
        }
        Object value = state.method_11654(property);
        if (value instanceof class_3542) {
            class_3542 e = (class_3542)value;
            value = e.method_15434();
        }
        return (C)value;
    }

    public static class_2680 withNullable(class_2680 state, String name, Comparable<?> value) {
        return state == null ? null : BlockStateWrapper.with(state, name, value);
    }

    public static class_2680 with(class_2680 state, String name, Comparable<?> value) {
        String string;
        class_2769 property = state.method_26204().method_9595().method_11663(name);
        if (property == null) {
            return state;
        }
        if (value instanceof String && (value = (Comparable)property.method_11900(string = (String)((Object)value)).orElse(null)) == null) {
            return state;
        }
        if (!property.method_11902().isInstance(value)) {
            return state;
        }
        return (class_2680)state.method_11657(property, value);
    }

    public static boolean canPlaceAt(WorldWrapper world, class_2680 state, int x, int y, int z) {
        class_2338.class_2339 pos = world.immutablePos(x, y, z);
        return pos != null && BlockStateVersions.isReplaceable(world.world.method_8320((class_2338)pos)) && world.world.canPlace((class_2338)pos, state);
    }

    public static boolean canStayAt(WorldWrapper world, class_2680 state, int x, int y, int z) {
        class_2338.class_2339 pos = world.immutablePos(x, y, z);
        return pos == null || world.world.canPlace((class_2338)pos, state);
    }

    public static boolean hasWater(class_2680 state) {
        return state.method_26227().method_15767(class_3486.field_15517);
    }

    public static boolean hasLava(class_2680 state) {
        return state.method_26227().method_15767(class_3486.field_15518);
    }

    public static boolean hasSoulLava(class_2680 state) {
        return state.method_26227().method_15767(BigGlobeFluidTags.SOUL_LAVA);
    }

    public static boolean hasFluid(class_2680 state) {
        return !state.method_26227().method_15769();
    }
}

