/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.scripting.wrappers;

import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.objects.ObjectArrays;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConstantMap<K, V>
extends AbstractMap<K, V> {
    public static final Object NULL = new Object(){

        public String toString() {
            return "null signaler";
        }
    };
    public final K[] keys;
    public final V[] values;
    public final int[] order;
    public transient EntrySet entrySet;

    @NotNull
    public static <K> Object wrap(@Nullable K object) {
        return object == null ? NULL : object;
    }

    @Nullable
    public static <K> K unwrap(@NotNull Object object) {
        return (K)(object == NULL ? null : object);
    }

    public ConstantMap() {
        this.keys = ObjectArrays.EMPTY_ARRAY;
        this.values = ObjectArrays.EMPTY_ARRAY;
        this.order = IntArrays.EMPTY_ARRAY;
    }

    public ConstantMap(Object ... keysAndValues) {
        int keyValueLength = keysAndValues.length;
        if ((keyValueLength & 1) != 0) {
            throw new IllegalArgumentException("Odd number of arguments");
        }
        int capacity = Integer.highestOneBit(keyValueLength);
        int mask = capacity - 1;
        int size = keyValueLength >>> 1;
        Object[] keys = new Object[capacity];
        Object[] values = new Object[capacity];
        int[] order = new int[size];
        int orderIndex = 0;
        int keyValueIndex = 0;
        while (keyValueIndex < keyValueLength) {
            Object key = ConstantMap.wrap(keysAndValues[keyValueIndex++]);
            Object value = keysAndValues[keyValueIndex++];
            int position = key.hashCode();
            position ^= position >>> 16;
            position &= mask;
            while (keys[position] != null) {
                if (keys[position].equals(key)) {
                    throw new IllegalArgumentException("Duplicate key: " + String.valueOf(key));
                }
                position = position + 1 & mask;
            }
            keys[position] = key;
            values[position] = value;
            order[orderIndex++] = position;
        }
        this.keys = keys;
        this.values = values;
        this.order = order;
    }

    @Override
    public int size() {
        return this.order.length;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getPosition(key) >= 0;
    }

    @Override
    public boolean containsValue(Object value) {
        V[] values = this.values;
        if (value != null) {
            for (int position : this.order) {
                if (!value.equals(values[position])) continue;
                return true;
            }
        } else {
            for (int position : this.order) {
                if (values[position] != null) continue;
                return true;
            }
        }
        return false;
    }

    public int getPosition(Object key) {
        if (key == null) {
            key = NULL;
        }
        int position = key.hashCode();
        position ^= position >>> 16;
        K[] keys = this.keys;
        int mask = keys.length - 1;
        position &= mask;
        while (keys[position] != null) {
            if (keys[position].equals(key)) {
                return position;
            }
            position = position + 1 & mask;
        }
        return -1;
    }

    @Override
    @Nullable
    public V get(Object key) {
        int position = this.getPosition(key);
        return position >= 0 ? (V)this.values[position] : null;
    }

    @Override
    public V getOrDefault(Object key, V defaultValue) {
        int position = this.getPosition(key);
        return position >= 0 ? this.values[position] : defaultValue;
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        return this.entrySet == null ? (this.entrySet = new EntrySet()) : this.entrySet;
    }

    public class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public int size() {
            return ConstantMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            if (o instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)o;
                int position = ConstantMap.this.getPosition(entry.getKey());
                return position >= 0 && Objects.equals(entry.getValue(), ConstantMap.this.values[position]);
            }
            return false;
        }
    }

    public record Entry<K, V>(K getKey, V getValue) implements Map.Entry<K, V>
    {
        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof Map.Entry)) return false;
            Map.Entry that = (Map.Entry)obj;
            if (!Objects.equals(this.getKey(), that.getKey())) return false;
            if (!Objects.equals(this.getValue(), that.getValue())) return false;
            return true;
        }

        @Override
        public int hashCode() {
            return Objects.hashCode(this.getKey()) ^ Objects.hashCode(this.getValue());
        }

        @Override
        public String toString() {
            return String.valueOf(this.getKey()) + " -> " + String.valueOf(this.getValue());
        }
    }

    public class EntryIterator
    implements Iterator<Map.Entry<K, V>> {
        public int index;

        @Override
        public boolean hasNext() {
            return this.index < ConstantMap.this.order.length;
        }

        @Override
        public Map.Entry<K, V> next() {
            if (this.index >= ConstantMap.this.order.length) {
                throw new NoSuchElementException();
            }
            int position = ConstantMap.this.order[this.index++];
            return new Entry(ConstantMap.unwrap(ConstantMap.this.keys[position]), ConstantMap.this.values[position]);
        }
    }
}

